/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.line;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletResponse;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.line.LineChart;
import org.primefaces.component.chart.series.ChartSeries;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.resource.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineChartRenderer
extends BaseChartRenderer
implements PartialRenderer {
    @Override
    protected void encodeChartScript(FacesContext facesContext, UIChart chart) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = chart.getClientId(facesContext);
        String xfieldName = this.getFieldName(chart.getValueExpression("xfield"));
        List<ChartSeries> series = this.getSeries(chart);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady(\"" + clientId + "\", function() {\n");
        if (!chart.isLive()) {
            this.encodeLocalData(facesContext, chart, xfieldName, series);
        }
        this.encodeDataSource(facesContext, chart, xfieldName, series);
        this.encodeSeriesDef(facesContext, chart, series);
        this.encodeChartWidget(facesContext, chart, clientId, xfieldName);
        writer.write("});\n");
        writer.endElement("script");
    }

    private void encodeLocalData(FacesContext facesContext, UIChart chart, String xfieldName, List<ChartSeries> series) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write(this.getLocalDataVar(chart) + " = [");
        Collection value = (Collection)chart.getValue();
        Iterator iterator = value.iterator();
        while (iterator.hasNext()) {
            facesContext.getExternalContext().getRequestMap().put(chart.getVar(), iterator.next());
            String xfieldValue = chart.getValueExpression("xfield").getValue(facesContext.getELContext()).toString();
            writer.write("{" + xfieldName + ":\"" + xfieldValue + "\"");
            for (ChartSeries axis : series) {
                ValueExpression ve = axis.getValueExpression("value");
                String fieldName = this.getFieldName(axis.getValueExpression("value"));
                writer.write("," + fieldName + ":" + ve.getValue(facesContext.getELContext()).toString());
            }
            writer.write("}");
            if (!iterator.hasNext()) continue;
            writer.write(",\n");
        }
        writer.write("];\n");
    }

    private void encodeDataSource(FacesContext facesContext, UIChart chart, String xfieldName, List<ChartSeries> series) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String dataSourceVar = this.getDataSourceVar(chart);
        if (chart.isLive()) {
            writer.write("var " + dataSourceVar + " = new YAHOO.util.DataSource(\"" + this.getActionURL(facesContext) + "\");\n");
            writer.write(dataSourceVar + ".connMethodPost = true;\n");
            writer.write(dataSourceVar + ".responseType=YAHOO.util.DataSource.TYPE_JSON;\n");
            writer.write(dataSourceVar + ".responseSchema = {resultsList:\"LiveChartDataResponse.Data\", fields:[\"" + xfieldName + "\"");
        } else {
            writer.write("var " + dataSourceVar + " = new YAHOO.util.DataSource(" + this.getLocalDataVar(chart) + ");\n");
            writer.write(dataSourceVar + ".responseType=YAHOO.util.DataSource.TYPE_JSARRAY;\n");
            writer.write(dataSourceVar + ".responseSchema = {fields:[\"" + xfieldName + "\"");
        }
        for (ChartSeries axis : series) {
            writer.write(",\"" + this.getFieldName(axis.getValueExpression("value")) + "\"");
        }
        writer.write("]};\n");
    }

    private void encodeSeriesDef(FacesContext facesContext, UIChart chart, List<ChartSeries> series) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write("var " + this.getSeriesDefVar(chart) + " = [");
        for (int i = 0; i < series.size(); ++i) {
            ChartSeries currentSeries = series.get(i);
            String fieldName = this.getFieldName(currentSeries.getValueExpression("value"));
            writer.write("{displayName:'" + currentSeries.getLabel() + "', yField:'" + fieldName + "'");
            if (currentSeries.getStyle() != null) {
                writer.write(",style:" + currentSeries.getStyle());
            }
            writer.write("}");
            if (i == series.size() - 1) continue;
            writer.write(",");
        }
        writer.write("];\n");
    }

    private void encodeChartWidget(FacesContext facesContext, UIChart chart, String clientId, String xfieldName) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        LineChart lineChart = (LineChart)chart;
        String chartVar = this.getChartVar(lineChart);
        writer.write("var yAxis = new YAHOO.widget.NumericAxis();\n");
        writer.write("var xAxis = new YAHOO.widget.CategoryAxis();\n");
        if (this.shouldRenderAttribute(lineChart.getMinY())) {
            writer.write("yAxis.minimum = " + lineChart.getMinY() + ";\n");
        }
        if (this.shouldRenderAttribute(lineChart.getMaxY())) {
            writer.write("yAxis.maximum = " + lineChart.getMaxY() + ";\n");
        }
        if (lineChart.getTitleX() != null) {
            writer.write("xAxis.title = '" + lineChart.getTitleX() + "';\n");
        }
        if (lineChart.getTitleY() != null) {
            writer.write("yAxis.title = '" + lineChart.getTitleY() + "';\n");
        }
        if (lineChart.getLabelFunctionX() != null) {
            writer.write("xAxis.labelFunction = '" + lineChart.getLabelFunctionX() + "';\n");
        }
        if (lineChart.getLabelFunctionY() != null) {
            writer.write("yAxis.labelFunction = '" + lineChart.getLabelFunctionY() + "';\n");
        }
        writer.write(chartVar + " = new YAHOO.widget.LineChart('" + clientId + "'," + this.getDataSourceVar(lineChart) + ",{");
        writer.write("xField:'" + xfieldName + "'");
        writer.write(",series:" + this.getSeriesDefVar(lineChart));
        writer.write(",expressInstall:'" + ResourceUtils.getResourceURL(facesContext, "/yui/assets/expressinstall.swf") + "'");
        if (lineChart.getWmode() != null) {
            writer.write(",wmode:'" + lineChart.getWmode() + "'");
        }
        if (lineChart.isLive()) {
            writer.write(",polling:" + lineChart.getRefreshInterval());
            writer.write(",request:PrimeFaces.widget.ChartUtils.createPollingParams('" + clientId + "')");
        }
        if (lineChart.getStyle() != null) {
            writer.write(",style:" + lineChart.getStyle() + "");
        }
        if (chart.getDataTipFunction() != null) {
            writer.write(",dataTipFunction:" + chart.getDataTipFunction());
        }
        writer.write(",xAxis:xAxis");
        writer.write(",yAxis:yAxis");
        writer.write("});\n");
        if (chart.getItemSelectListener() != null) {
            this.encodeItemSelectEvent(facesContext, chart);
        }
    }

    @Override
    public void encodePartially(FacesContext facesContext, UIComponent component) throws IOException {
        ((ServletResponse)facesContext.getExternalContext().getResponse()).setContentType("application/json");
        ResponseWriter writer = facesContext.getResponseWriter();
        LineChart chart = (LineChart)component;
        String xfieldName = this.getFieldName(chart.getValueExpression("xfield"));
        List<ChartSeries> series = this.getSeries(chart);
        writer.write("{");
        writer.write("\"LiveChartDataResponse\" : {\n");
        writer.write("\t\"Data\" : [\n");
        Collection value = (Collection)chart.getValue();
        Iterator iterator = value.iterator();
        while (iterator.hasNext()) {
            facesContext.getExternalContext().getRequestMap().put(chart.getVar(), iterator.next());
            String xfieldValue = chart.getValueExpression("xfield").getValue(facesContext.getELContext()).toString();
            writer.write("{\"" + xfieldName + "\":\"" + xfieldValue + "\"");
            for (ChartSeries axis : series) {
                ValueExpression ve = axis.getValueExpression("value");
                String fieldName = this.getFieldName(axis.getValueExpression("value"));
                writer.write(",\"" + fieldName + "\":" + ve.getValue(facesContext.getELContext()).toString());
            }
            writer.write("}");
            if (!iterator.hasNext()) continue;
            writer.write(",\n");
        }
        writer.write("\t]\n");
        writer.write("}\n");
        writer.write("}");
    }
}

