/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.dialog;

import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.el.ValueExpression;
import javax.el.MethodExpression;
import javax.faces.render.Renderer;
import java.io.IOException;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.resource.ResourceHolder;


public class Dialog extends UIPanel {


	public static final String COMPONENT_TYPE = "org.primefaces.component.Dialog";
	public static final String COMPONENT_FAMILY = "org.primefaces.component";
	private static final String DEFAULT_RENDERER = "org.primefaces.component.DialogRenderer";

	private java.lang.String _widgetVar;
	private java.lang.String _header;
	private java.lang.String _footer;
	private java.lang.Boolean _close;
	private java.lang.Boolean _draggable;
	private java.lang.Boolean _resizable;
	private java.lang.String _underlay;
	private java.lang.Boolean _modal;
	private java.lang.Boolean _visible;
	private java.lang.Boolean _constrainToViewport;
	private java.lang.Integer _x;
	private java.lang.Integer _y;
	private java.lang.Boolean _fixedCenter;
	private java.lang.String _width;
	private java.lang.String _height;
	private java.lang.String _effect;
	private java.lang.Double _effectDuration;
	private java.lang.Integer _zindex;
	private java.lang.Integer _minWidth;
	private java.lang.Integer _minHeight;
	private java.lang.String _style;
	private java.lang.String _styleClass;
	public Dialog() {
		setRendererType(DEFAULT_RENDERER);
		ResourceHolder resourceHolder = getResourceHolder();
		if(resourceHolder != null) {
			resourceHolder.addResource("/yui/assets/skins/sam/resize.css");
			resourceHolder.addResource("/yui/container/assets/skins/sam/container.css");
			resourceHolder.addResource("/yui/utilities/utilities.js");
			resourceHolder.addResource("/yui/resize/resize-min.js");
			resourceHolder.addResource("/yui/container/container-min.js");
			resourceHolder.addResource("/primefaces/core/core.js");
			resourceHolder.addResource("/primefaces/dialog/dialog.js");
		}
	}

	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public java.lang.String getWidgetVar() {
		if(_widgetVar != null )
			return _widgetVar;

		ValueExpression ve = getValueExpression("widgetVar");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setWidgetVar(java.lang.String _widgetVar) {
		this._widgetVar = _widgetVar;
	}

	public java.lang.String getHeader() {
		if(_header != null )
			return _header;

		ValueExpression ve = getValueExpression("header");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setHeader(java.lang.String _header) {
		this._header = _header;
	}

	public java.lang.String getFooter() {
		if(_footer != null )
			return _footer;

		ValueExpression ve = getValueExpression("footer");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setFooter(java.lang.String _footer) {
		this._footer = _footer;
	}

	public boolean isClose() {
		if(_close != null )
			return _close;

		ValueExpression ve = getValueExpression("close");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setClose(boolean _close) {
		this._close = _close;
	}

	public boolean isDraggable() {
		if(_draggable != null )
			return _draggable;

		ValueExpression ve = getValueExpression("draggable");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setDraggable(boolean _draggable) {
		this._draggable = _draggable;
	}

	public boolean isResizable() {
		if(_resizable != null )
			return _resizable;

		ValueExpression ve = getValueExpression("resizable");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setResizable(boolean _resizable) {
		this._resizable = _resizable;
	}

	public java.lang.String getUnderlay() {
		if(_underlay != null )
			return _underlay;

		ValueExpression ve = getValueExpression("underlay");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : "shadow";
	}
	public void setUnderlay(java.lang.String _underlay) {
		this._underlay = _underlay;
	}

	public boolean isModal() {
		if(_modal != null )
			return _modal;

		ValueExpression ve = getValueExpression("modal");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setModal(boolean _modal) {
		this._modal = _modal;
	}

	public boolean isVisible() {
		if(_visible != null )
			return _visible;

		ValueExpression ve = getValueExpression("visible");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setVisible(boolean _visible) {
		this._visible = _visible;
	}

	public boolean isConstrainToViewport() {
		if(_constrainToViewport != null )
			return _constrainToViewport;

		ValueExpression ve = getValueExpression("constrainToViewport");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setConstrainToViewport(boolean _constrainToViewport) {
		this._constrainToViewport = _constrainToViewport;
	}

	public int getX() {
		if(_x != null )
			return _x;

		ValueExpression ve = getValueExpression("x");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : -1;
	}
	public void setX(int _x) {
		this._x = _x;
	}

	public int getY() {
		if(_y != null )
			return _y;

		ValueExpression ve = getValueExpression("y");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : -1;
	}
	public void setY(int _y) {
		this._y = _y;
	}

	public boolean isFixedCenter() {
		if(_fixedCenter != null )
			return _fixedCenter;

		ValueExpression ve = getValueExpression("fixedCenter");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setFixedCenter(boolean _fixedCenter) {
		this._fixedCenter = _fixedCenter;
	}

	public java.lang.String getWidth() {
		if(_width != null )
			return _width;

		ValueExpression ve = getValueExpression("width");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setWidth(java.lang.String _width) {
		this._width = _width;
	}

	public java.lang.String getHeight() {
		if(_height != null )
			return _height;

		ValueExpression ve = getValueExpression("height");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setHeight(java.lang.String _height) {
		this._height = _height;
	}

	public java.lang.String getEffect() {
		if(_effect != null )
			return _effect;

		ValueExpression ve = getValueExpression("effect");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setEffect(java.lang.String _effect) {
		this._effect = _effect;
	}

	public double getEffectDuration() {
		if(_effectDuration != null )
			return _effectDuration;

		ValueExpression ve = getValueExpression("effectDuration");
		return ve != null ? (java.lang.Double) ve.getValue(getFacesContext().getELContext())  : 1.0;
	}
	public void setEffectDuration(double _effectDuration) {
		this._effectDuration = _effectDuration;
	}

	public int getZindex() {
		if(_zindex != null )
			return _zindex;

		ValueExpression ve = getValueExpression("zindex");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : -1;
	}
	public void setZindex(int _zindex) {
		this._zindex = _zindex;
	}

	public int getMinWidth() {
		if(_minWidth != null )
			return _minWidth;

		ValueExpression ve = getValueExpression("minWidth");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : Integer.MIN_VALUE;
	}
	public void setMinWidth(int _minWidth) {
		this._minWidth = _minWidth;
	}

	public int getMinHeight() {
		if(_minHeight != null )
			return _minHeight;

		ValueExpression ve = getValueExpression("minHeight");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : Integer.MIN_VALUE;
	}
	public void setMinHeight(int _minHeight) {
		this._minHeight = _minHeight;
	}

	public java.lang.String getStyle() {
		if(_style != null )
			return _style;

		ValueExpression ve = getValueExpression("style");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setStyle(java.lang.String _style) {
		this._style = _style;
	}

	public java.lang.String getStyleClass() {
		if(_styleClass != null )
			return _styleClass;

		ValueExpression ve = getValueExpression("styleClass");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setStyleClass(java.lang.String _styleClass) {
		this._styleClass = _styleClass;
	}


	protected FacesContext getFacesContext() {
		return FacesContext.getCurrentInstance();
	}
	public Object saveState(FacesContext context) {
		Object values[] = new Object[23];
		values[0] = super.saveState(context);
		values[1] = _widgetVar;
		values[2] = _header;
		values[3] = _footer;
		values[4] = _close;
		values[5] = _draggable;
		values[6] = _resizable;
		values[7] = _underlay;
		values[8] = _modal;
		values[9] = _visible;
		values[10] = _constrainToViewport;
		values[11] = _x;
		values[12] = _y;
		values[13] = _fixedCenter;
		values[14] = _width;
		values[15] = _height;
		values[16] = _effect;
		values[17] = _effectDuration;
		values[18] = _zindex;
		values[19] = _minWidth;
		values[20] = _minHeight;
		values[21] = _style;
		values[22] = _styleClass;
		return ((Object) values);
	}
	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		_widgetVar = (java.lang.String) values[1];
		_header = (java.lang.String) values[2];
		_footer = (java.lang.String) values[3];
		_close = (java.lang.Boolean) values[4];
		_draggable = (java.lang.Boolean) values[5];
		_resizable = (java.lang.Boolean) values[6];
		_underlay = (java.lang.String) values[7];
		_modal = (java.lang.Boolean) values[8];
		_visible = (java.lang.Boolean) values[9];
		_constrainToViewport = (java.lang.Boolean) values[10];
		_x = (java.lang.Integer) values[11];
		_y = (java.lang.Integer) values[12];
		_fixedCenter = (java.lang.Boolean) values[13];
		_width = (java.lang.String) values[14];
		_height = (java.lang.String) values[15];
		_effect = (java.lang.String) values[16];
		_effectDuration = (java.lang.Double) values[17];
		_zindex = (java.lang.Integer) values[18];
		_minWidth = (java.lang.Integer) values[19];
		_minHeight = (java.lang.Integer) values[20];
		_style = (java.lang.String) values[21];
		_styleClass = (java.lang.String) values[22];
	}

	protected ResourceHolder getResourceHolder() {
		FacesContext facesContext = getFacesContext();
		if(facesContext == null)
			return null;

		ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{primeFacesResourceHolder}", ResourceHolder.class);

		return (ResourceHolder) ve.getValue(facesContext.getELContext());
	}
}