/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.primefaces.model.ScheduleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleModel<T extends ScheduleEvent>
implements Serializable {
    private List<T> events;

    public ScheduleModel() {
        this.events = new ArrayList<T>();
    }

    public ScheduleModel(List<T> events) {
        this.events = events;
    }

    public void addEvent(T t) {
        t.setId(UUID.randomUUID().toString());
        this.events.add(t);
    }

    public boolean deleteEvent(T t) {
        return this.events.remove(t);
    }

    public List<T> getEvents() {
        return this.events;
    }

    public void setEvents(List<T> events) {
        this.events = events;
    }

    public T getEvent(String id) {
        for (ScheduleEvent t : this.events) {
            if (!t.getId().equals(id)) continue;
            return (T)t;
        }
        return null;
    }

    public void updateEvent(T event) {
        int index = -1;
        for (int i = 0; i < this.events.size(); ++i) {
            if (!((ScheduleEvent)this.events.get(i)).getId().equals(event.getId())) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.events.set(index, event);
        }
    }

    public int getEventCount() {
        return this.events.size();
    }

    public void fetchEvents(Date start, Date end) {
    }

    public boolean isLazy() {
        return false;
    }
}

