/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import java.util.List;
import javax.faces.model.DataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyDataModel<T>
extends DataModel
implements Serializable {
    private int rowIndex = -1;
    private int totalNumRows;
    private int pageSize;
    private List<T> list;

    public LazyDataModel() {
    }

    public LazyDataModel(int totalNumRows) {
        this.totalNumRows = totalNumRows;
    }

    public abstract List<T> fetchLazyData(int var1, int var2);

    public boolean isRowAvailable() {
        if (this.list == null) {
            return false;
        }
        int rowIndex = this.getRowIndex();
        return rowIndex >= 0 && rowIndex < this.list.size();
    }

    public int getRowCount() {
        return this.totalNumRows;
    }

    public Object getRowData() {
        if (this.list == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        int dataIndex = this.getRowIndex();
        return this.list.get(dataIndex);
    }

    public int getRowIndex() {
        return this.rowIndex % this.pageSize;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public Object getWrappedData() {
        return this.list;
    }

    public void setWrappedData(Object list) {
        this.list = (List)list;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

