/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.linkbutton;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.linkbutton.LinkButton;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class LinkButtonRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        LinkButton button = (LinkButton)component;
        this.encodeButtonScript(facesContext, button);
        this.encodeButtonMarkup(facesContext, button);
    }

    protected void encodeButtonMarkup(FacesContext facesContext, LinkButton button) throws IOException {
        String value;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = button.getClientId(facesContext);
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)"yui-button yui-link-button", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"first-child", null);
        writer.startElement("a", (UIComponent)button);
        writer.writeAttribute("href", (Object)this.getResourceURL(facesContext, button.getHref()), null);
        if (button.getStyle() != null) {
            writer.writeAttribute("style", (Object)button.getStyle(), null);
        }
        if (button.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)button.getStyleClass(), null);
        }
        if (button.getTarget() != null) {
            writer.writeAttribute("target", (Object)button.getTarget(), null);
        }
        if ((value = ComponentUtils.getStringValueToRender(facesContext, (UIComponent)button)) != null) {
            writer.write(value);
        }
        writer.endElement("a");
        writer.endElement("span");
        writer.endElement("span");
    }

    protected void encodeButtonScript(FacesContext facesContext, LinkButton button) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = button.getClientId(facesContext);
        String buttonVar = this.createUniqueWidgetVar(facesContext, (UIComponent)button);
        writer.startElement("script", (UIComponent)button);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady(\"" + clientId + "\", function() {\n");
        writer.write(buttonVar + " = new YAHOO.widget.Button(\"" + clientId + "\");");
        this.renderPassThruAttributes(facesContext, (UIComponent)button, buttonVar, HTML.BUTTON_EVENTS);
        writer.write("});");
        writer.endElement("script");
    }
}

