/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tabview;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tabview.Tab;
import org.primefaces.component.tabview.TabView;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.PartialRenderer;

public class TabViewRenderer
extends CoreRenderer
implements PartialRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TabView tabView = (TabView)component;
        this.encodeTabViewScript(facesContext, tabView);
        this.encodeTabViewMarkup(facesContext, tabView);
    }

    public void encodePartially(FacesContext facesContext, UIComponent component) throws IOException {
        TabView tabView = (TabView)component;
        String activeTabIndexParam = (String)facesContext.getExternalContext().getRequestParameterMap().get("activeTabIndex");
        int activeTabIndex = Integer.parseInt(activeTabIndexParam);
        Tab activeTab = (Tab)((Object)tabView.getChildren().get(activeTabIndex));
        this.renderChildren(facesContext, (UIComponent)activeTab);
    }

    private void encodeTabViewMarkup(FacesContext facesContext, TabView tabView) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = tabView.getClientId(facesContext);
        int activeTabIndex = this.getActiveTabIndex(facesContext, tabView, clientId);
        String activeTabIndexHolder = this.getActiveTabIndexHolder(clientId);
        writer.startElement("div", (UIComponent)tabView);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)"yui-navset", null);
        this.encodeTabHeaders(facesContext, tabView, activeTabIndex);
        this.encodeTabContents(facesContext, tabView, activeTabIndex);
        this.encodeActiveIndexHolder(facesContext, activeTabIndex, activeTabIndexHolder);
        writer.endElement("div");
    }

    private void encodeActiveIndexHolder(FacesContext facesContext, int activeTabIndex, String activeTabIndexHolder) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)activeTabIndexHolder, null);
        writer.writeAttribute("name", (Object)activeTabIndexHolder, null);
        writer.writeAttribute("value", (Object)activeTabIndex, null);
        writer.endElement("input");
    }

    private void encodeTabHeaders(FacesContext facesContext, TabView tabView, int activeTabIndex) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"yui-nav", null);
        for (int i = 0; i < tabView.getChildren().size(); ++i) {
            Tab tab = (Tab)((Object)tabView.getChildren().get(i));
            if (!tab.isRendered()) continue;
            writer.startElement("li", null);
            if (i == activeTabIndex) {
                writer.writeAttribute("class", (Object)"selected", null);
            }
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)("#" + tab.getClientId(facesContext)), null);
            writer.startElement("em", null);
            writer.write(tab.getTitle());
            writer.endElement("em");
            writer.endElement("a");
            writer.endElement("li");
        }
        writer.endElement("ul");
    }

    private void encodeTabContents(FacesContext facesContext, TabView tabView, int activeTabIndex) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"yui-content", null);
        for (int i = 0; i < tabView.getChildren().size(); ++i) {
            Tab tab = (Tab)((Object)tabView.getChildren().get(i));
            if (!tab.isRendered()) continue;
            writer.startElement("div", null);
            if (tabView.isAsyncToggling()) {
                if (i == activeTabIndex) {
                    this.renderChildren(facesContext, (UIComponent)tab);
                }
            } else {
                this.renderChildren(facesContext, (UIComponent)tab);
            }
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    private int getActiveTabIndex(FacesContext facesContext, TabView tabView, String clientId) {
        String activeTabIndexHiddenFieldId = this.getActiveTabIndexHolder(clientId);
        String activeTabIndex = (String)facesContext.getExternalContext().getRequestParameterMap().get(activeTabIndexHiddenFieldId);
        if (activeTabIndex != null && activeTabIndex != "") {
            tabView.setActiveIndex(Integer.parseInt(activeTabIndex));
        }
        return tabView.getActiveIndex();
    }

    private void encodeTabViewScript(FacesContext facesContext, TabView tabView) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = tabView.getClientId(facesContext);
        String tabViewVar = this.createUniqueWidgetVar(facesContext, (UIComponent)tabView);
        String activeTabIndexHolder = this.getActiveTabIndexHolder(clientId);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady(\"" + clientId + "\", function() {\n");
        writer.write(tabViewVar + " = new PrimeFaces.widget.TabView(\"" + clientId + "\",");
        writer.write("{");
        writer.write("clientId:\"" + clientId + "\"");
        writer.write(",activeTabIndexHolder:\"" + activeTabIndexHolder + "\"");
        writer.write(",orientation:\"" + tabView.getOrientation() + "\"");
        writer.write(",toggleMode:\"" + tabView.getToggleMode() + "\"");
        writer.write(",actionURL:\"" + this.getActionURL(facesContext) + "\"");
        writer.write(",cache:" + tabView.isCache() + "");
        writer.write(",contentTransition:" + tabView.isContentTransition());
        writer.write("});\n");
        writer.write("});\n");
        writer.endElement("script");
    }

    private String getActiveTabIndexHolder(String clientId) {
        return clientId + ":activeIndex";
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

