/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menubar;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menubar.Menubar;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.submenu.Submenu;
import org.primefaces.renderkit.CoreRenderer;

public class MenubarRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Menubar menubar = (Menubar)component;
        this.encodeMenuScript(facesContext, menubar);
        this.encodeMenuMarkup(facesContext, menubar);
    }

    private void encodeMenuScript(FacesContext facesContext, Menubar menubar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = menubar.getClientId(facesContext);
        String menubarVar = this.createUniqueWidgetVar(facesContext, (UIComponent)menubar);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(menubarVar + " = new YAHOO.widget.MenuBar('" + clientId + "',{");
        writer.write("autosubmenudisplay:" + menubar.isAutoSubmenuDisplay());
        if (!menubar.getEffect().equals("NONE")) {
            writer.write(",effect: {effect: YAHOO.widget.ContainerEffect." + menubar.getEffect());
            if (menubar.getEffectDuration() != 0.25) {
                writer.write(",duration:" + menubar.getEffectDuration() + "}");
            } else {
                writer.write(",duration: 0.25}");
            }
        }
        writer.write("})\n;");
        writer.write(menubarVar + ".render();\n");
        writer.write("});\n");
        writer.endElement("script");
    }

    private void encodeMenuMarkup(FacesContext facesContext, Menubar menubar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = menubar.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)"yuimenubar", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"bd", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"first-of-type", null);
        List children = menubar.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Submenu submenu = (Submenu)((Object)children.get(i));
            if (!submenu.isRendered()) continue;
            writer.startElement("li", null);
            if (i == 0) {
                writer.writeAttribute("class", (Object)"yuimenubaritem first-of-type", null);
            } else {
                writer.writeAttribute("class", (Object)"yuimenubaritem", null);
            }
            this.encodeSubmenu(facesContext, submenu);
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void encodeSubmenu(FacesContext facesContext, Submenu submenu) throws IOException {
        String labelClass;
        ResponseWriter writer = facesContext.getResponseWriter();
        String string = labelClass = submenu.getParent() instanceof Menubar ? "yuimenubaritemlabel" : "yuimenuitemlabel";
        if (submenu.getStyleClass() != null) {
            labelClass = labelClass + " " + submenu.getStyleClass();
        }
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)labelClass, null);
        if (submenu.getUrl() != null) {
            writer.writeAttribute("href", (Object)submenu.getUrl(), null);
        }
        if (submenu.getStyle() != null) {
            writer.writeAttribute("style", (Object)submenu.getStyle(), null);
        }
        if (submenu.getOnclick() != null) {
            writer.writeAttribute("onclick", (Object)submenu.getOnclick(), null);
        }
        if (submenu.getLabel() != null) {
            writer.write(submenu.getLabel());
        }
        writer.endElement("a");
        if (submenu.getChildCount() > 0) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"yuimenu", null);
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"bd", null);
            writer.startElement("ul", null);
            this.encodeSubmenuItems(facesContext, submenu);
            writer.endElement("ul");
            writer.endElement("div");
            writer.endElement("div");
        }
    }

    private void encodeSubmenuItems(FacesContext facesContext, Submenu submenu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (UIComponent child : submenu.getChildren()) {
            if (!child.isRendered()) continue;
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"yuimenuitem", null);
            if (child instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)child;
                this.encodeMenuItem(facesContext, menuItem);
            } else if (child instanceof Submenu) {
                Submenu childSubmenu = (Submenu)child;
                this.encodeSubmenu(facesContext, childSubmenu);
            }
            writer.endElement("li");
        }
    }

    private void encodeMenuItem(FacesContext facesContext, MenuItem menuItem) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String menuitemStyleClass = menuItem.getStyleClass() == null ? "yuimenuitemlabel" : "yuimenuitemlabel " + menuItem.getStyleClass();
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)menuitemStyleClass, null);
        writer.writeAttribute("href", (Object)menuItem.getUrl(), null);
        if (menuItem.getStyle() != null) {
            writer.writeAttribute("style", (Object)menuItem.getStyle(), null);
        }
        if (menuItem.getTarget() != null) {
            writer.writeAttribute("target", (Object)menuItem.getTarget(), null);
        }
        if (menuItem.getOnclick() != null) {
            writer.writeAttribute("onclick", (Object)menuItem.getOnclick(), null);
        }
        if (menuItem.getLabel() != null) {
            writer.write(menuItem.getLabel());
        }
        if (menuItem.getHelpText() != null) {
            writer.startElement("em", null);
            writer.writeAttribute("class", (Object)"helptext", null);
            writer.write(menuItem.getHelpText());
            writer.endElement("em");
        }
        writer.endElement("a");
    }
}

