/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.keyboard;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.keyboard.Keyboard;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class KeyboardRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Keyboard keyboard = (Keyboard)component;
        String clientId = keyboard.getClientId(facesContext);
        String submittedValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(clientId);
        keyboard.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Keyboard keyboard = (Keyboard)component;
        this.encodeScript(facesContext, keyboard);
        this.encodeMarkup(facesContext, keyboard);
    }

    private void encodeScript(FacesContext facesContext, Keyboard keyboard) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = keyboard.getClientId(facesContext);
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)keyboard);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(var + " = new PrimeFaces.widget.Keyboard('" + clientId + "', {");
        writer.write("showOn:'" + keyboard.getShowMode() + "'");
        writer.write(",showAnim:'" + keyboard.getEffect() + "'");
        if (keyboard.isButtonImageOnly()) {
            writer.write(",buttonImageOnly:true");
        }
        if (keyboard.getButtonImage() != null) {
            writer.write(",buttonImage:'" + this.getResourceURL(facesContext, keyboard.getButtonImage()) + "'");
        }
        if (keyboard.getEffectDuration() != null) {
            writer.write(",duration:'" + keyboard.getEffectDuration() + "'");
        }
        if (!keyboard.isKeypadOnly()) {
            writer.write(",keypadOnly:false");
            writer.write(",layoutName:'" + keyboard.getLayout() + "'");
            if (keyboard.getLayoutTemplate() != null) {
                writer.write(",layoutTemplate:'" + keyboard.getLayoutTemplate() + "'");
            }
        }
        if (keyboard.getStyleClass() != null) {
            writer.write(",keypadClass:'" + keyboard.getStyleClass() + "'");
        }
        if (keyboard.getPromptLabel() != null) {
            writer.write(",prompt:'" + keyboard.getPromptLabel() + "'");
        }
        if (keyboard.getBackspaceLabel() != null) {
            writer.write(",backText:'" + keyboard.getBackspaceLabel() + "'");
        }
        if (keyboard.getClearLabel() != null) {
            writer.write(",clearText:'" + keyboard.getClearLabel() + "'");
        }
        if (keyboard.getCloseLabel() != null) {
            writer.write(",closeText:'" + keyboard.getCloseLabel() + "'");
        }
        writer.write("});\n});\n");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, Keyboard keyboard) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = keyboard.getClientId(facesContext);
        String type = keyboard.isPassword() ? "password" : "text";
        writer.startElement("input", (UIComponent)keyboard);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)type, null);
        writer.writeAttribute("value", (Object)ComponentUtils.getStringValueToRender(facesContext, (UIComponent)keyboard), null);
        this.renderPassThruAttributes(facesContext, (UIComponent)keyboard, HTML.INPUT_TEXT_ATTRS);
        writer.endElement("input");
    }
}

