/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.component.export.Exporter;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLExporter
extends Exporter {
    @Override
    public void export(FacesContext facesContext, UIData table, String filename, int[] excludeColumns, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        PrintWriter writer = new PrintWriter((OutputStream)response.getOutputStream());
        List<UIColumn> columns = this.getColumnsToExport(table, excludeColumns);
        int rows = table.getRowCount();
        List<String> headers = this.getHeaderTexts(table);
        String var = table.getVar().toLowerCase();
        writer.write("<?xml version=\"1.0\"?>\n");
        writer.write("<" + table.getId() + ">\n");
        for (int i = 0; i < rows; ++i) {
            table.setRowIndex(i);
            writer.write("\t<" + var + ">\n");
            this.addColumnValues(writer, columns, headers);
            writer.write("\t</" + var + ">\n");
        }
        writer.write("</" + table.getId() + ">");
        table.setRowIndex(-1);
        response.setContentType("text/xml");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setHeader("Content-disposition", "attachment;filename=" + filename + ".xml");
        writer.flush();
        writer.close();
        response.getOutputStream().flush();
    }

    private void addColumnValues(PrintWriter writer, List<UIColumn> columns, List<String> headers) throws IOException {
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn column = columns.get(i);
            if (!column.isRendered()) continue;
            this.addColumnValue(writer, column.getChildren(), headers.get(i));
        }
    }

    private List<String> getHeaderTexts(UIData data) {
        ArrayList<String> headers = new ArrayList<String>();
        for (int i = 0; i < data.getChildCount(); ++i) {
            UIComponent child = (UIComponent)data.getChildren().get(i);
            if (!(child instanceof UIColumn) || !child.isRendered()) continue;
            UIComponent header = ((UIColumn)child).getHeader();
            if (header != null && header.isRendered()) {
                String value = ComponentUtils.getStringValueToRender(FacesContext.getCurrentInstance(), header);
                headers.add(value);
                continue;
            }
            headers.add("");
        }
        return headers;
    }

    private void addColumnValue(PrintWriter writer, List<UIComponent> components, String header) throws IOException {
        StringBuffer buffer = new StringBuffer();
        String tag = header.toLowerCase();
        writer.write("\t\t<" + tag + ">");
        for (UIComponent component : components) {
            if (!component.isRendered()) continue;
            String value = ComponentUtils.getStringValueToRender(FacesContext.getCurrentInstance(), component);
            buffer.append(value);
        }
        writer.write(buffer.toString());
        writer.write("</" + tag + ">\n");
    }
}

