/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.ExporterFactory;
import org.primefaces.util.ComponentUtils;

public class DataExporter
implements ActionListener,
StateHolder {
    private ValueExpression target;
    private ValueExpression type;
    private ValueExpression fileName;
    private ValueExpression excludeColumns;
    private MethodExpression preProcessor;
    private MethodExpression postProcessor;

    public DataExporter() {
    }

    public DataExporter(ValueExpression target, ValueExpression type, ValueExpression fileName, ValueExpression exludeColumns, MethodExpression preProcessor, MethodExpression postProcessor) {
        this.target = target;
        this.type = type;
        this.fileName = fileName;
        this.excludeColumns = exludeColumns;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
    }

    public void processAction(ActionEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        String tableId = (String)this.target.getValue(elContext);
        String exportAs = (String)this.type.getValue(elContext);
        String outputFileName = (String)this.fileName.getValue(elContext);
        int[] excludedColumnIndexes = null;
        if (this.excludeColumns != null) {
            excludedColumnIndexes = this.resolveExcludedColumnIndexes((String)this.excludeColumns.getValue(elContext));
        }
        try {
            Exporter exporter = ExporterFactory.getExporterForType(exportAs);
            UIData table = (UIData)ComponentUtils.findComponentById(facesContext, (UIComponent)facesContext.getViewRoot(), tableId);
            exporter.export(facesContext, table, outputFileName, excludedColumnIndexes, this.preProcessor, this.postProcessor);
            facesContext.responseComplete();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private int[] resolveExcludedColumnIndexes(String columnsToExclude) {
        String[] columnIndexesAsString = columnsToExclude.split(",");
        int[] indexes = new int[columnIndexesAsString.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = Integer.parseInt(columnIndexesAsString[i].trim());
        }
        return indexes;
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean value) {
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.target = (ValueExpression)values[0];
        this.type = (ValueExpression)values[1];
        this.fileName = (ValueExpression)values[2];
        this.excludeColumns = (ValueExpression)values[3];
        this.preProcessor = (MethodExpression)values[4];
        this.postProcessor = (MethodExpression)values[5];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.target, this.type, this.fileName, this.excludeColumns, this.preProcessor, this.postProcessor};
        return values;
    }
}

