/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.captcha;

import javax.el.ValueExpression;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import org.primefaces.component.captcha.CaptchaValidator;
import org.primefaces.resource.ResourceHolder;

public class Captcha
extends UIInput {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Captcha";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.CaptchaRenderer";
    private String _publicKey;
    private String _theme;
    private String _language;

    public Captcha() {
        this.setRendererType(DEFAULT_RENDERER);
        ResourceHolder resourceHolder = this.getResourceHolder();
        if (resourceHolder != null) {
            // empty if block
        }
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getPublicKey() {
        if (this._publicKey != null) {
            return this._publicKey;
        }
        ValueExpression ve = this.getValueExpression("publicKey");
        return ve != null ? (String)ve.getValue(this.getFacesContext().getELContext()) : null;
    }

    public void setPublicKey(String _publicKey) {
        this._publicKey = _publicKey;
    }

    public String getTheme() {
        if (this._theme != null) {
            return this._theme;
        }
        ValueExpression ve = this.getValueExpression("theme");
        return ve != null ? (String)ve.getValue(this.getFacesContext().getELContext()) : "red";
    }

    public void setTheme(String _theme) {
        this._theme = _theme;
    }

    public String getLanguage() {
        if (this._language != null) {
            return this._language;
        }
        ValueExpression ve = this.getValueExpression("language");
        return ve != null ? (String)ve.getValue(this.getFacesContext().getELContext()) : "en";
    }

    public void setLanguage(String _language) {
        this._language = _language;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._publicKey, this._theme, this._language};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._publicKey = (String)values[1];
        this._theme = (String)values[2];
        this._language = (String)values[3];
    }

    protected void validateValue(FacesContext facesContext, Object value) {
        if (!this.hasCaptchaValidator()) {
            this.addValidator(new CaptchaValidator());
        }
        super.validateValue(facesContext, value);
    }

    private boolean hasCaptchaValidator() {
        for (Validator validator : this.getValidators()) {
            if (!(validator instanceof CaptchaValidator)) continue;
            return true;
        }
        return false;
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected ResourceHolder getResourceHolder() {
        FacesContext facesContext = this.getFacesContext();
        if (facesContext == null) {
            return null;
        }
        ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{primeFacesResourceHolder}", ResourceHolder.class);
        return (ResourceHolder)ve.getValue(facesContext.getELContext());
    }
}

