/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.calendar;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.calendar.Calendar;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.resource.ResourceUtils;
import org.primefaces.util.ComponentUtils;

public class CalendarRenderer
extends CoreRenderer {
    private static String DEFAULT_POPUP_ICON = "/primefaces/calendar/calendar_icon.png";

    public void decode(FacesContext facesContext, UIComponent component) {
        Calendar calendar = (Calendar)component;
        String clientId = calendar.getClientId(facesContext);
        String submittedValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        calendar.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Calendar calendar = (Calendar)component;
        this.encodeScript(facesContext, calendar);
        this.encodeMarkup(facesContext, calendar);
    }

    private void encodeScript(FacesContext facesContext, Calendar calendar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = calendar.getClientId(facesContext);
        String calendarVar = this.createUniqueWidgetVar(facesContext, (UIComponent)calendar);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        if (this.isPopup(calendar)) {
            writer.write(calendarVar + "_popupOverlay = new YAHOO.widget.Overlay('" + clientId + "_popupContainer', {visible: false});\n");
            writer.write(calendarVar + "_popupOverlay.render();\n");
        }
        if (calendar.getPages() > 1) {
            writer.write(calendarVar + " = new YAHOO.widget.CalendarGroup('" + clientId + "','" + clientId + "_container', {PAGES:" + calendar.getPages() + "});\n");
        } else {
            writer.write(calendarVar + " = new YAHOO.widget.Calendar('" + clientId + "','" + clientId + "_container');\n");
        }
        this.encodeSelectionEvent(facesContext, calendar, calendarVar);
        writer.write("PrimeFaces.widget.CalendarUtils.applyLocale(" + calendarVar + ",'" + calendar.calculateLocale(facesContext).getLanguage() + "');\n");
        String valueAsString = this.getValueAsString(facesContext, calendar, "MM/dd/yyyy");
        String pagedate = this.getPageDate(valueAsString, calendar);
        String maxdate = this.getDateAsString(calendar, calendar.getMaxdate());
        String mindate = this.getDateAsString(calendar, calendar.getMindate());
        if (valueAsString != null) {
            writer.write(calendarVar + ".cfg.setProperty('selected','" + valueAsString + "');\n");
        }
        if (pagedate != null) {
            writer.write(calendarVar + ".cfg.setProperty('pagedate','" + pagedate + "');\n");
        }
        if (maxdate != null) {
            writer.write(calendarVar + ".cfg.setProperty('maxdate','" + maxdate + "');\n");
        }
        if (mindate != null) {
            writer.write(calendarVar + ".cfg.setProperty('mindate','" + mindate + "');\n");
        }
        if (calendar.isNavigator()) {
            writer.write(calendarVar + ".cfg.setProperty('navigator',true);\n");
        }
        if (calendar.getSelection().equals("multiple")) {
            writer.write(calendarVar + ".cfg.setProperty('multi_select',true);\n");
        }
        if (calendar.isClose()) {
            writer.write(calendarVar + ".cfg.setProperty('close', true);\n");
        }
        if (calendar.getTitle() != null) {
            writer.write(calendarVar + ".cfg.setProperty('title','" + calendar.getTitle() + "');\n");
        }
        if (!calendar.isShowWeekdays()) {
            writer.write(calendarVar + ".cfg.setProperty('show_weekdays', false);\n");
        }
        if (calendar.getMonthFormat() != null) {
            writer.write(calendarVar + ".cfg.setProperty('locale_months', '" + calendar.getMonthFormat() + "');\n");
        }
        if (calendar.getWeekdayFormat() != null) {
            writer.write(calendarVar + ".cfg.setProperty('locale_weekdays', '" + calendar.getWeekdayFormat() + "');\n");
        }
        if (calendar.getStartWeekday() != 0) {
            writer.write(calendarVar + ".cfg.setProperty('start_weekday', " + calendar.getStartWeekday() + ");\n");
        }
        if (calendar.isShowWeekHeader()) {
            writer.write(calendarVar + ".cfg.setProperty('show_week_header', true);\n");
        }
        if (calendar.isShowWeekFooter()) {
            writer.write(calendarVar + ".cfg.setProperty('show_week_footer', true);\n");
        }
        if (!this.isPopup(calendar)) {
            writer.write(calendarVar + ".render();\n");
        } else {
            writer.write("YAHOO.util.Event.addListener('" + clientId + "_popupButtonImage', 'click', function(e){" + calendarVar + ".render();" + calendarVar + ".show();" + calendarVar + "_popupOverlay.show();});");
        }
        writer.write("});\n");
        writer.endElement("script");
    }

    private void encodeSelectionEvent(FacesContext facesContext, Calendar calendar, String calendarVar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = calendar.getClientId(facesContext);
        String selectionEvent = ".subscribe(PrimeFaces.widget.CalendarUtils.selectEvent, {calendar:" + calendarVar + ",inputId:'" + clientId + "_input'";
        selectionEvent = calendar.getSelection().equals("multiple") ? selectionEvent + ", selection:'multiple'" : selectionEvent + ", selection:'single'";
        String delimiter = this.getPatternDelimeter(calendar);
        selectionEvent = selectionEvent + ", delimiter:'" + delimiter + "'";
        selectionEvent = selectionEvent + ", dayFieldIndex:" + this.getDateFieldPosition(calendar, delimiter, "d");
        selectionEvent = selectionEvent + ", monthFieldIndex:" + this.getDateFieldPosition(calendar, delimiter, "M");
        selectionEvent = selectionEvent + ", yearFieldIndex:" + this.getDateFieldPosition(calendar, delimiter, "y");
        selectionEvent = this.isPopup(calendar) ? selectionEvent + ", popupOverlay:" + calendarVar + "_popupOverlay}, true);\n" : selectionEvent + "}, true);\n";
        writer.write(calendarVar + ".selectEvent" + selectionEvent);
        writer.write(calendarVar + ".deselectEvent" + selectionEvent);
    }

    private void encodeMarkup(FacesContext facesContext, Calendar calendar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = calendar.getClientId(facesContext);
        writer.startElement("div", (UIComponent)calendar);
        writer.writeAttribute("id", (Object)clientId, null);
        this.encodeInputField(facesContext, calendar, clientId);
        if (this.isPopup(calendar)) {
            this.encodePopupButtonMarkup(facesContext, calendar);
            this.encodePopupContainer(facesContext, clientId);
        } else {
            this.encodeCalendarContainer(facesContext, clientId);
        }
        writer.endElement("div");
    }

    private void encodePopupContainer(FacesContext facesContext, String clientId) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_popupContainer"), null);
        this.encodeCalendarContainer(facesContext, clientId);
        writer.endElement("div");
    }

    private void encodeCalendarContainer(FacesContext facesContext, String clientId) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_container"), null);
        writer.endElement("div");
    }

    private void encodeInputField(FacesContext facesContext, Calendar calendar, String clientId) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String valueAsString = this.getValueAsString(facesContext, calendar, calendar.getPattern());
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(clientId + "_input"), null);
        writer.writeAttribute("name", (Object)(clientId + "_input"), null);
        if (this.isPopup(calendar)) {
            writer.writeAttribute("type", (Object)"text", null);
        } else {
            writer.writeAttribute("type", (Object)"hidden", null);
        }
        writer.writeAttribute("value", (Object)valueAsString, null);
        writer.writeAttribute("readonly", (Object)"true", null);
        writer.endElement("input");
    }

    private void encodePopupButtonMarkup(FacesContext facesContext, Calendar calendar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = calendar.getClientId(facesContext);
        String icon = calendar.getPopupIcon() != null ? this.getResourceURL(facesContext, calendar.getPopupIcon()) : ResourceUtils.getResourceURL(facesContext, DEFAULT_POPUP_ICON);
        writer.startElement("img", null);
        writer.writeAttribute("id", (Object)(clientId + "_popupButtonImage"), null);
        writer.writeAttribute("name", (Object)(clientId + "_popupButtonImage"), null);
        writer.writeAttribute("src", (Object)icon, null);
        writer.writeAttribute("style", (Object)"cursor:pointer;margin:0;padding:0;", null);
        writer.endElement("img");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object value) throws ConverterException {
        Calendar calendar = (Calendar)component;
        String submittedValue = (String)value;
        if (calendar.getConverter() != null) {
            return calendar.getConverter().getAsObject(facesContext, (UIComponent)calendar, submittedValue);
        }
        if (ComponentUtils.isValueBlank(submittedValue)) {
            return null;
        }
        Locale locale = calendar.calculateLocale(facesContext);
        SimpleDateFormat format = new SimpleDateFormat(calendar.getPattern(), locale);
        format.setTimeZone(calendar.calculateTimeZone());
        try {
            if (calendar.getSelection().equalsIgnoreCase("single")) {
                Date convertedValue = format.parse(submittedValue);
                calendar.setSubmittedValue(convertedValue);
                return convertedValue;
            }
            if (calendar.getSelection().equalsIgnoreCase("multiple")) {
                String[] datesAsString = submittedValue.split(",");
                Date[] dates = new Date[datesAsString.length];
                for (int i = 0; i < datesAsString.length; ++i) {
                    dates[i] = format.parse(datesAsString[i]);
                }
                return dates;
            }
            throw new IllegalArgumentException("Selection mode: " + calendar.getSelection() + " is not valid, use either 'single' or 'multiple'");
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    String getValueAsString(FacesContext facesContext, Calendar calendar, String pattern) {
        Object value = calendar.getValue();
        if (calendar.getConverter() != null) {
            return calendar.getConverter().getAsString(facesContext, (UIComponent)calendar, value);
        }
        if (value == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, calendar.calculateLocale(facesContext));
        dateFormat.setTimeZone(calendar.calculateTimeZone());
        if (calendar.getSelection().equalsIgnoreCase("single")) {
            return dateFormat.format(value);
        }
        if (calendar.getSelection().equalsIgnoreCase("multiple")) {
            Date[] dates = (Date[])calendar.getValue();
            String datesAsString = "";
            for (int i = 0; i < dates.length; ++i) {
                datesAsString = i == 0 ? dateFormat.format(dates[i]) : datesAsString + "," + dateFormat.format(dates[i]);
            }
            return datesAsString;
        }
        throw new IllegalArgumentException("Calendar '" + calendar.getClientId(facesContext) + "' has an invalid selection type. Must be either 'single' or 'multiple'");
    }

    boolean isPopup(Calendar calendar) {
        return calendar.getMode().equalsIgnoreCase("popup");
    }

    String getPageDate(String date, Calendar calendar) {
        Object pagedate = calendar.getPagedate();
        boolean multiple = calendar.getSelection().equalsIgnoreCase("multiple");
        if (pagedate != null) {
            if (pagedate instanceof String) {
                return (String)pagedate;
            }
            if (pagedate instanceof Date) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("MM/yyyy", calendar.calculateLocale(FacesContext.getCurrentInstance()));
                dateFormat.setTimeZone(calendar.calculateTimeZone());
                return dateFormat.format((Date)pagedate);
            }
            throw new FacesException("PageDate could be either String or java.util.Date");
        }
        if (date != null) {
            String selectedDate = multiple ? date.split(",")[0] : date;
            String[] tokens = selectedDate.split("/");
            return tokens[0].trim() + "/" + tokens[2].trim();
        }
        return null;
    }

    String getDateAsString(Calendar calendar, Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof String) {
            return (String)date;
        }
        if (date instanceof Date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy", calendar.calculateLocale(FacesContext.getCurrentInstance()));
            dateFormat.setTimeZone(calendar.calculateTimeZone());
            return dateFormat.format((Date)date);
        }
        throw new FacesException("Date could be either String or java.util.Date");
    }

    String getPatternDelimeter(Calendar calendar) {
        String pattern = calendar.getPattern();
        return pattern.split("[A-Za-z]+")[1];
    }

    int getDateFieldPosition(Calendar calendar, String delimiter, String fieldPrefix) {
        String pattern = calendar.getPattern();
        if (delimiter.equals(".")) {
            delimiter = "\\.";
        }
        String[] dateFields = pattern.split(delimiter);
        for (int i = 0; i < dateFields.length; ++i) {
            if (!dateFields[i].startsWith(fieldPrefix)) continue;
            return i + 1;
        }
        return -1;
    }
}

