/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.component.export.Exporter;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVExporter
extends Exporter {
    @Override
    public void export(FacesContext facesContext, UIData table, String filename, int[] excludeColumns, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        PrintWriter writer = new PrintWriter((OutputStream)response.getOutputStream());
        List<UIColumn> columns = this.getColumnsToExport(table, excludeColumns);
        int rows = table.getRowCount();
        this.addColumnHeaders(writer, columns);
        for (int i = 0; i < rows; ++i) {
            table.setRowIndex(i);
            this.addColumnValues(writer, columns);
            writer.write("\n");
        }
        table.setRowIndex(-1);
        response.setContentType("text/csv");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setHeader("Content-disposition", "attachment;filename=" + filename + ".csv");
        writer.flush();
        writer.close();
        response.getOutputStream().flush();
    }

    private void addColumnValues(PrintWriter writer, List<UIColumn> columns) throws IOException {
        Iterator<UIColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            UIColumn column = iterator.next();
            if (!column.isRendered()) continue;
            this.addColumnValue(writer, column.getChildren());
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
    }

    private void addColumnHeaders(PrintWriter writer, List<UIColumn> columns) throws IOException {
        Iterator<UIColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            UIColumn column = iterator.next();
            if (!column.isRendered()) continue;
            this.addColumnValue(writer, column.getHeader());
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("\n");
    }

    private void addColumnValue(PrintWriter writer, UIComponent component) throws IOException {
        String value = component == null ? "" : ComponentUtils.getStringValueToRender(FacesContext.getCurrentInstance(), component);
        writer.write("\"" + value + "\"");
    }

    private void addColumnValue(PrintWriter writer, List<UIComponent> components) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (UIComponent component : components) {
            if (!component.isRendered()) continue;
            String value = ComponentUtils.getStringValueToRender(FacesContext.getCurrentInstance(), component);
            buffer.append(value);
        }
        writer.write("\"" + buffer.toString() + "\"");
    }
}

