/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.series.ChartSeries;
import org.primefaces.event.ItemSelectEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.resource.ResourceUtils;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseChartRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        String clientId = component.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            int seriesIndex = Integer.parseInt((String)params.get("seriesIndex"));
            int itemIndex = Integer.parseInt((String)params.get("itemIndex"));
            component.queueEvent((FacesEvent)new ItemSelectEvent(component, itemIndex, seriesIndex));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UIChart chart = (UIChart)component;
        this.encodeResources(facesContext);
        this.encodeChartScript(facesContext, chart);
        this.encodeChartMarkup(facesContext, chart);
    }

    protected void encodeChartScript(FacesContext facesContext, UIChart chart) throws IOException {
    }

    protected List<ChartSeries> getSeries(UIChart chart) {
        List children = chart.getChildren();
        ArrayList<ChartSeries> series = new ArrayList<ChartSeries>();
        for (UIComponent component : children) {
            if (!(component instanceof ChartSeries) || !component.isRendered()) continue;
            series.add((ChartSeries)component);
        }
        return series;
    }

    protected String getChartVar(UIChart chart) {
        return this.createUniqueWidgetVar(FacesContext.getCurrentInstance(), (UIComponent)chart);
    }

    protected String getDataSourceVar(UIChart chart) {
        return this.getChartVar(chart) + "_dataSource";
    }

    protected String getLocalDataVar(UIChart chart) {
        return this.getChartVar(chart) + "_data";
    }

    protected String getSeriesDefVar(UIChart chart) {
        return this.getChartVar(chart) + "_seriesDef";
    }

    protected String getFieldName(ValueExpression fieldExpression) {
        String expressionString = fieldExpression.getExpressionString();
        String expressionContent = expressionString.substring(2, expressionString.length() - 1);
        int firstIndex = expressionContent.indexOf("[");
        if (firstIndex != -1) {
            int lastIndex = expressionContent.indexOf("]");
            return expressionContent.substring(firstIndex + 1, lastIndex);
        }
        String[] tokens = expressionContent.split("\\.");
        return tokens[tokens.length - 1];
    }

    protected void encodeResources(FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("YAHOO.widget.Chart.SWFURL = \"" + ResourceUtils.getResourceURL(facesContext, "/yui/charts/assets/charts.swf") + "\"");
        writer.endElement("script");
    }

    protected void encodeChartMarkup(FacesContext facesContext, UIChart chart) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)chart.getClientId(facesContext), null);
        writer.writeAttribute("style", (Object)("width:" + chart.getWidth() + ";height:" + chart.getHeight()), null);
        if (chart.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)chart.getStyleClass(), "styleClass");
        }
        writer.endElement("div");
    }

    protected void encodeItemSelectEvent(FacesContext facesContext, UIChart chart) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = chart.getClientId(facesContext);
        String formClientId = ComponentUtils.findParentForm(facesContext, (UIComponent)chart).getClientId(facesContext);
        writer.write(this.getChartVar(chart) + ".subscribe('itemClickEvent', PrimeFaces.widget.ChartUtils.itemSelectHandler, {clientId:'" + clientId + "'");
        writer.write(",url:'" + this.getActionURL(facesContext) + "'");
        writer.write(",formClientId:'" + formClientId + "'");
        writer.write(",update:'" + chart.getUpdate() + "'");
        if (chart.getOncomplete() != null) {
            writer.write(",oncomplete: function() {" + chart.getOncomplete() + ";}");
        }
        writer.write("})\n");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

