/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.ajaxstatus;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.ajaxstatus.AjaxStatus;
import org.primefaces.renderkit.CoreRenderer;

public class AjaxStatusRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AjaxStatus status = (AjaxStatus)component;
        this.encodeScript(context, status);
        this.encodeMarkup(context, status);
    }

    protected void encodeScript(FacesContext facesContext, AjaxStatus status) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = status.getClientId(facesContext);
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)status);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(var + " = new PrimeFaces.widget.AjaxStatus('" + clientId + "');\n");
        this.encodeCallback(facesContext, status, var, "ajaxSend", "onprestart", "prestart");
        this.encodeCallback(facesContext, status, var, "ajaxStart", "onstart", "start");
        this.encodeCallback(facesContext, status, var, "ajaxError", "onerror", "error");
        this.encodeCallback(facesContext, status, var, "ajaxSuccess", "onsuccess", "success");
        this.encodeCallback(facesContext, status, var, "ajaxComplete", "oncomplete", "complete");
        writer.write("});");
        writer.endElement("script");
    }

    private void encodeCallback(FacesContext facesContext, AjaxStatus status, String var, String event, String callback, String facetName) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = status.getClientId(facesContext);
        String fn = (String)status.getAttributes().get(callback);
        if (fn != null) {
            writer.write(var + ".bindCallback('" + event + "',function(){" + fn + "});\n");
        } else if (status.getFacet(facetName) != null) {
            writer.write(var + ".bindFacet('" + event + "', '" + clientId + "_" + facetName + "');\n");
        }
    }

    protected void encodeMarkup(FacesContext facesContext, AjaxStatus status) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = status.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (status.getStyle() != null) {
            writer.writeAttribute("style", (Object)status.getStyle(), "style");
        }
        if (status.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)status.getStyleClass(), "styleClass");
        }
        for (String facet : AjaxStatus.FACETS) {
            this.encodeStatusFacetMarkup(facesContext, status, facet);
        }
        writer.endElement("div");
    }

    private void encodeStatusFacetMarkup(FacesContext facesContext, AjaxStatus status, String facetName) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = status.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_" + facetName), null);
        writer.writeAttribute("style", (Object)"display:none", null);
        UIComponent facet = status.getFacet(facetName);
        if (facet != null) {
            this.renderChild(facesContext, facet);
        }
        writer.endElement("div");
    }
}

