/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application;

import com.sun.facelets.FaceletsUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.render.RenderKit;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.primefaces.component.api.AjaxComponent;
import org.primefaces.util.ApplicationUtils;
import org.primefaces.util.RendererUtils;

public class PrimeFacesPhaseListener
implements PhaseListener {
    private static final Logger logger = Logger.getLogger(PrimeFacesPhaseListener.class.getName());
    public static final ContextCallback RENDER_RESPONSE = new ContextCallback(){

        public void invokeContextCallback(FacesContext facesContext, UIComponent component) {
            try {
                component.encodeAll(facesContext);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };
    public static final ContextCallback RENDER_PARTIAL_RESPONSE = new ContextCallback(){

        public void invokeContextCallback(FacesContext facesContext, UIComponent component) {
            try {
                ((AjaxComponent)component).encodePartially(facesContext);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };

    public void afterPhase(PhaseEvent phaseEvent) {
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        FacesContext facesContext = phaseEvent.getFacesContext();
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String viewNamespace = ApplicationUtils.getViewNamespace(facesContext);
        boolean isAjaxRequest = params.containsKey("primefacesAjaxRequest");
        if (isAjaxRequest) {
            boolean isPPRRequest;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Processing PrimeFaces ajax request");
            }
            this.initPartialRenderView(facesContext);
            boolean bl = isPPRRequest = !params.containsKey("ajaxSource");
            if (isPPRRequest) {
                String updateIds = (String)params.get("update");
                String[] ids = null;
                if (updateIds != null) {
                    ids = updateIds.split(",");
                }
                ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
                response.setContentType("text/xml");
                ResponseWriter writer = facesContext.getResponseWriter();
                try {
                    writer.write("<partialResponse>");
                    if (ids != null) {
                        this.writeComponents(facesContext, ids, viewNamespace);
                    }
                    this.writeState(facesContext);
                    writer.write("</partialResponse>");
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            } else {
                String ajaxSource = (String)params.get("ajaxSource");
                boolean found = facesContext.getViewRoot().invokeOnComponent(facesContext, ajaxSource, RENDER_PARTIAL_RESPONSE);
                if (!found) {
                    logger.log(Level.WARNING, "Component \"{0}\" not found to be updated partially", ajaxSource);
                }
            }
            facesContext.responseComplete();
        }
    }

    private void writeState(FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write("<state>");
        RendererUtils.startCDATA(facesContext);
        StateManager stateManager = facesContext.getApplication().getStateManager();
        stateManager.writeState(facesContext, stateManager.saveView(facesContext));
        RendererUtils.endCDATA(facesContext);
        writer.write("</state>");
    }

    private void writeComponents(FacesContext facesContext, String[] ids, String namespace) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write("<components>");
        for (String id : ids) {
            String clientId = id.trim();
            if (!namespace.equals("")) {
                String viewrootClientId = facesContext.getViewRoot().getClientId(facesContext);
                clientId = viewrootClientId.indexOf(namespace) == -1 ? namespace + ":" + viewrootClientId + ":" + clientId : viewrootClientId + ":" + clientId;
            }
            writer.write("<component>");
            writer.write("<id>" + clientId + "</id>");
            writer.write("<output>");
            RendererUtils.startCDATA(facesContext);
            boolean found = facesContext.getViewRoot().invokeOnComponent(facesContext, clientId, RENDER_RESPONSE);
            if (!found) {
                logger.log(Level.WARNING, "Component \"{0}\" not found to be updated partially", clientId);
            }
            RendererUtils.endCDATA(facesContext);
            writer.write("</output>");
            writer.write("</component>");
        }
        writer.write("</components>");
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    private void initPartialRenderView(FacesContext facesContext) {
        this.initPartialResponseWriter(facesContext);
        if (FaceletsUtils.isFaceletsEnabled(facesContext)) {
            try {
                FaceletsUtils.initStateWriter(facesContext);
                FaceletsUtils.buildView(facesContext);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occured in initializing view with Facelets: {0}", e.getMessage());
                throw new FacesException((Throwable)e);
            }
        }
    }

    private void initPartialResponseWriter(FacesContext facesContext) {
        if (facesContext.getResponseWriter() != null) {
            return;
        }
        try {
            ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
            ServletRequest request = (ServletRequest)facesContext.getExternalContext().getRequest();
            RenderKit renderKit = facesContext.getRenderKit();
            ResponseWriter responseWriter = renderKit.createResponseWriter((Writer)response.getWriter(), null, request.getCharacterEncoding());
            facesContext.setResponseWriter(responseWriter);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

