/**
 * PowerDBJ
 * create date 2006/09/26
 * amonden
 */
package jp.co.powerbeans.eclipse.plugin.powerdbj.export.excel;

import java.io.Serializable;

import jp.co.powerbeans.powerql.ColumnProperty;
import jp.co.powerbeans.powerql.IndexProperty;
import jp.co.powerbeans.powerql.TableProperty;

/**
 * SheetTableProperty.
 * TableProperty クラスをラップし,sheetNameプロパティを追加したクラス
 * @author amonden
 * @create date 2006/09/26
 */
public class SheetTableProperty implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 5689409333936896114L;
  private TableProperty tableProperty;
  private String sheetName;
  
  
//  /**
//   * コンストラクタ
//   */
//  private SheetTableProperty() {
//    super();
//  }
  
  
  /**
   * コンストラクタ
   * @param property
   */
  public SheetTableProperty(TableProperty property) {
    this.tableProperty = property;
    
    // シート名はテーブル名とする
    if (this.tableProperty.getTableName().matches("^[a-zA-Z0-9_]+$") ) {
      this.sheetName = this.tableProperty.getTableName();
    } else {
      // もし半角英数_以外が含まれている場合は
      // オブジェクトインスタンスを利用
      this.sheetName = this.toString();
    }
  }


  /**
   * @return
   */
  public String getSheetName() {
    return sheetName;
  }
  /**
   * @param sheetName
   */
  public void setSheetName(String sheetName) {
    this.sheetName = sheetName;
  }


  /**
   * @return
   * @see jp.co.powerbeans.powerql.TableProperty#getColumnProperties()
   */
  public ColumnProperty[] getColumnProperties() {
    return tableProperty.getColumnProperties();
  }


  /**
   * @return
   * @see jp.co.powerbeans.powerql.TableProperty#getIndexProperties()
   */
  public IndexProperty[] getIndexProperties() {
    return tableProperty.getIndexProperties();
  }


  /**
   * @return
   * @see jp.co.powerbeans.powerql.TableProperty#getSchema()
   */
  public String getSchema() {
    return tableProperty.getSchema();
  }


  /**
   * @return
   * @see jp.co.powerbeans.powerql.TableProperty#getTableName()
   */
  public String getTableName() {
    return tableProperty.getTableName();
  }


  /**
   * @param columnProperties
   * @see jp.co.powerbeans.powerql.TableProperty#setColumnProperties(jp.co.powerbeans.powerql.ColumnProperty[])
   */
  public void setColumnProperties(ColumnProperty[] columnProperties) {
    tableProperty.setColumnProperties(columnProperties);
  }


  /**
   * @param indexProperties
   * @see jp.co.powerbeans.powerql.TableProperty#setIndexProperties(jp.co.powerbeans.powerql.IndexProperty[])
   */
  public void setIndexProperties(IndexProperty[] indexProperties) {
    tableProperty.setIndexProperties(indexProperties);
  }


  /**
   * @param schema
   * @see jp.co.powerbeans.powerql.TableProperty#setSchema(java.lang.String)
   */
  public void setSchema(String schema) {
    tableProperty.setSchema(schema);
  }


  /**
   * @param tableName
   * @see jp.co.powerbeans.powerql.TableProperty#setTableName(java.lang.String)
   */
  public void setTableName(String tableName) {
    tableProperty.setTableName(tableName);
  }


  /**
   * @return tableProperty
   */
  public TableProperty getTableProperty() {
    return tableProperty;
  }


  /**
   * @param tableProperty 設定する tableProperty
   */
  public void setTableProperty(TableProperty tableProperty) {
    this.tableProperty = tableProperty;
  }
  
  

}
