package jp.co.powerbeans.common;

import java.text.SimpleDateFormat;
import java.util.Date;

public final class ChkConv {

	/**
	 * 日付を yyyy/MM/dd 形式で返す
	 * @param date 日付
	 * @return 変換文字列
	 */
	public static String toString(Date date) {
		return date == null ? "" : new SimpleDateFormat("yyyy/MM/dd").format(date);
	}
	/**
	 * 日付を yyyy/M/d 形式で返す
	 * @param date 日付
	 * @return 変換文字列
	 */
	public static String toStringNoZero(Date date) {
		return date == null ? "" : new SimpleDateFormat("yyyy/M/d").format(date);
	}
}
