package jp.co.powerbeans.eclipse.plugin.powerdbj.wizards;

import java.sql.Driver;

import jp.co.powerbeans.common.classloader.PBClassLoadUtil;
import jp.co.powerbeans.common.swt.ChkConvSwt;
import jp.co.powerbeans.eclipse.common.PBFileUtil;
import jp.co.powerbeans.eclipse.plugin.powerdbj.Msg;
import jp.co.powerbeans.eclipse.plugin.powerdbj.db.DBSysManager;
import jp.co.powerbeans.eclipse.plugin.powerdbj.model.JdbcConfig;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

/**
 * PowerDBJWizard1SetDB.
 * JDBC jarファイル,JDBC Driverクラス, user, password を入力するウィザード画面.
 * 
 * @author amonden
 * @create date 2006/09/15
 */
public class PowerDBJWizard1SetDB extends PowerDBJWizardBase implements ModifyListener, SelectionListener, MouseListener {


	private ISelection selection;

	private Combo driverCombo;

	private Combo jarCombo;

	private Text userText;

	private Text passwordText;

	private Text urlText;

	private Button deleteButton;

	private Button borwseButton;

	private Table table;

	private static final String[] TABLE_COLS = {Msg.getJdbcJar(), Msg.getDriverClass(), Msg.getJdbcUrl(), Msg.getUser()};
	private static final String[] TABLE_MODEL_COLS = new String[]{"jarFilePath", "driverClass", "url", "user"};
	private static final int[] TABLE_COL_WIDTHS = {50,150, 100,100};

	/**
	 * Constructor for SampleNewWizardPage.
	 * @param dbinfo 
	 * 
	 * @param pageName
	 */
	public PowerDBJWizard1SetDB(ISelection selection, DBInfo dbinfo) {
		super("PowerDBJWizard1SetDB", dbinfo);
		setTitle(Msg.getWiz1Title());
		setDescription(Msg.getWiz1Description());
		this.selection = selection;
	}

	/**
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {

		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 9;
		
		// 1. input or select JDBC jar
		new Label(container, SWT.NULL).setText(Msg.getJdbcJar());
		this.jarCombo = createCombo(container);
		DBSysManager.findByAllToSwtComboBox(this.jarCombo, JdbcConfig.class, "jarFilePath");

		this.borwseButton = createButton(container, Msg.getBrowse(), this);
		
		// 2. input JDBC driver class
		createLabel(container, Msg.getDriverClass());
		this.driverCombo = createCombo(container, this);
		createLabel(container);
		
		// 3. url
		createLabel(container, Msg.getJdbcUrl());
		this.urlText = createText(container, this);
		createLabel(container);
		
		// 4. user
		createLabel(container, Msg.getUser());
		this.userText = createText(container, this);
		createLabel(container);

		// 5. password
		createLabel(container, Msg.getPassword());
		this.passwordText = createText(container, this);
		createLabel(container);
		
		// 6. ログイン履歴テーブルを追加
		createLabel(container, Msg.getJdbcConfigHistory());
		this.table = createTable(container, TABLE_COLS, TABLE_COL_WIDTHS);
		this.table.addMouseListener(this);

		// データも取得
		updateTable();

		this.deleteButton = createButton(container, Msg.getDelete(),this);
		

		initialize();
		dialogChanged();
		setControl(container);
	}

	/**
	 * Tests if the current workbench selection is a suitable container to use.
	 */

	private void initialize() {
		if (selection != null && selection.isEmpty() == false
				&& selection instanceof IStructuredSelection) {
			IStructuredSelection ssel = (IStructuredSelection) selection;
			if (ssel.size() > 1)
				return;
			Object obj = ssel.getFirstElement();
			if (obj instanceof IResource) {
				IContainer container;
				if (obj instanceof IContainer)
					container = (IContainer) obj;
				else
					container = ((IResource) obj).getParent();
			}
		}
	}

	/**
	 * Uses the standard container selection dialog to choose the new value for
	 * the container field.
	 */

	private void handleBrowse() {
	
		FileDialog dialog = new FileDialog(getShell());
		dialog.setFilterExtensions(new String[]{"*.jar","*.zip"});
		String path = dialog.open();
		if (path != null) {
			// 選択した場合
			
			// \ の場合は / に置換
			path = PBFileUtil.toUnixPath(path);
			// コンボボックスに格納
			this.jarCombo.removeAll();
			this.jarCombo.setText(path);
			
			// 1. Driverクラスを取得
			Class[] clss = PBClassLoadUtil.getClassesFromJar(path, Driver.class);
			if (clss.length == 0) {
				setErrorMessage(Msg.getErrCantGetDirverClass());
				this.driverCombo.setText("");
			} else {
				for (int i = 0; i < clss.length; i++) {
					this.driverCombo.add(clss[i].getName());
				}
				this.driverCombo.select(0);
			}
			dialogChanged();
		}
	}

	/**
	 * Ensures that both text fields are set.
	 */

	private void dialogChanged() {
		String jar =  PBFileUtil.toUnixPath(this.jarCombo.getText());
		String driver = this.driverCombo.getText();
		String url = this.urlText.getText();
		String user = this.userText.getText();
		String password = this.passwordText.getText();

		if (jar.length() == 0) {
			updateStatus(Msg.getInputJarFile());
			return;
		}
		if (driver.length() == 0) {
			updateStatus(Msg.getInputDriverClass());
			return;
		}
		if (url.length() == 0) {
			updateStatus(Msg.getInputJdbcUrl());
			return;
		}
		if (user.length() == 0) {
			updateStatus(Msg.getInputUser());
			return;
		}
		
		// DBInfoに格納
		JdbcConfig jdbcConfig = getDbinfo().getJdbcConfig();
		jdbcConfig.setJarFilePath(jar);
		jdbcConfig.setDriverClass(driver);
		jdbcConfig.setUrl(url);
		jdbcConfig.setUser(user);
		jdbcConfig.setPassword(password);
		
		updateStatus(null);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e) {
		dialogChanged();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
		if (e.getSource() == this.borwseButton) {
			handleBrowse();
		} else {
			deleteHistory();
		}
		
	}

	/**
	 * 選択した接続履歴を削除
	 */
	private void deleteHistory() {
		JdbcConfig jdbcConfig = (JdbcConfig) ChkConvSwt.getSelectObject(this.table);
		DBSysManager.removeByPrimaryKey(JdbcConfig.class, jdbcConfig.getJdbcConfigId());
		updateTable();
	}

	/**
	 * 
	 */
	private void updateTable() {
		this.table.removeAll();
		DBSysManager.findByToSwtTable(this.table, JdbcConfig.class, TABLE_MODEL_COLS, "");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.MouseListener#mouseDoubleClick(org.eclipse.swt.events.MouseEvent)
	 */
	public void mouseDoubleClick(MouseEvent e) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.MouseListener#mouseDown(org.eclipse.swt.events.MouseEvent)
	 */
	public void mouseDown(MouseEvent e) {
		if (e.getSource() == this.table) {
			JdbcConfig jdbcConfig = (JdbcConfig) ChkConvSwt.getSelectObject(this.table);
			this.jarCombo.setText(jdbcConfig.getJarFilePath());
			this.driverCombo.setText(jdbcConfig.getDriverClass());
			this.urlText.setText(jdbcConfig.getUrl());
			this.userText.setText(jdbcConfig.getUser());
			this.passwordText.setText(jdbcConfig.getPassword());
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.MouseListener#mouseUp(org.eclipse.swt.events.MouseEvent)
	 */
	public void mouseUp(MouseEvent e) {
	}
	public void setVisible(boolean visible) {
		super.setVisible(visible);
		if (visible) {
			updateTable();
		}
	}
}