/**
 * PowerDBJ
 * create date 2006/09/21
 * amonden
 */
package jp.co.powerbeans.eclipse.plugin.powerdbj.export.java;


import jp.co.powerbeans.docbuild.PBDocmentBuilderFactory;
import jp.co.powerbeans.docbuild.PBDocumentBuilder;
import jp.co.powerbeans.eclipse.common.PBEclipseUtil;
import jp.co.powerbeans.eclipse.plugin.powerdbj.Msg;
import jp.co.powerbeans.eclipse.plugin.powerdbj.db.DBManager;
import jp.co.powerbeans.eclipse.plugin.powerdbj.export.ExporterBase;
import jp.co.powerbeans.eclipse.plugin.powerdbj.model.JdbcConfig;
import jp.co.powerbeans.powerql.ColumnProperty;
import jp.co.powerbeans.powerql.TableProperty;

/**
 * HtmlExporterBase
 * @author amonden
 * @create date 2006/09/21
 */
public abstract class JavaExporterBase extends ExporterBase {

  protected static final String TEMPLATE_JAVA_DIR = PBEclipseUtil.getPluginsPath() + "/" 
  + Msg.getConfigCurrentDir() + "/template/java/";
  /* (non-Javadoc)
	 * @see jp.co.powerbeans.eclipse.plugin.powerdbj.logic.Exporter#export(jp.co.powerbeans.eclipse.plugin.powerdbj.model.JdbcConfig, jp.co.powerbeans.powerql.TableProperty[], java.lang.String)
	 */
	public String export(JdbcConfig jdbcConfig, TableProperty[] selectTables, String path, String template_file) {
		
		// 2. カラム,インデックス情報取得
		for (int i = 0; i < selectTables.length; i++) {
			TableProperty table = selectTables[i];
      ColumnProperty[] cps = DBManager.findSysColumnBySchemaTable(table.getSchema(), table.getTableName());
			table.setColumnProperties(cps);
      PBDocumentBuilder builder = createJavaDocBuilder(template_file, jdbcConfig.getCharset());
      
      // 3. 値格納
      ClassProperty cp = new ClassProperty(table);
      builder.assign("cls", cp);
      builder.assign("proplist", cp.getProperties());
      
      // 出力
      builder.output(path + "/" + cp.getClassName() + ".java");
		}
    
		return path;
	}


  /**
   * JAVA builderを作成
   * @param template テンプレートファイル相対パス
   * @param charset 文字コード
   * @return builder
   */
  protected PBDocumentBuilder createJavaDocBuilder(String template, String charset) {
    return createDocBuilder(PBDocmentBuilderFactory.JAVA, TEMPLATE_JAVA_DIR, template, charset);
  }

}
