/**
 * PowerDBJ
 * create date 2006/09/21
 * amonden
 */
package jp.co.powerbeans.eclipse.plugin.powerdbj.export.html;


import jp.co.powerbeans.docbuild.PBDocmentBuilderFactory;
import jp.co.powerbeans.docbuild.PBDocumentBuilder;
import jp.co.powerbeans.eclipse.common.PBEclipseUtil;
import jp.co.powerbeans.eclipse.plugin.powerdbj.Msg;
import jp.co.powerbeans.eclipse.plugin.powerdbj.db.DBManager;
import jp.co.powerbeans.eclipse.plugin.powerdbj.export.ExporterBase;
import jp.co.powerbeans.eclipse.plugin.powerdbj.model.JdbcConfig;
import jp.co.powerbeans.powerql.ColumnProperty;
import jp.co.powerbeans.powerql.IndexProperty;
import jp.co.powerbeans.powerql.TableProperty;

/**
 * HtmlExporterBase
 * @author amonden
 * @create date 2006/09/21
 */
public abstract class HtmlExporterBase extends ExporterBase {

  protected static final String TEMPLATE_HTML_DIR = PBEclipseUtil.getPluginsPath() + "/" 
  + Msg.getConfigCurrentDir() + "/template/html/";
  
  protected static final String CSS = "pbdoc.css";

	/**
	 * 
	 */
	protected static final String CHARSET = "Shift_JIS";
	

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.eclipse.plugin.powerdbj.logic.Exporter#export(jp.co.powerbeans.eclipse.plugin.powerdbj.model.JdbcConfig, jp.co.powerbeans.powerql.TableProperty[], java.lang.String)
	 */
	public String export(JdbcConfig jdbcConfig, TableProperty[] selectTables, String path, String template_file) {
		
		PBDocumentBuilder builder = createHtmlDocBuilder(template_file, CHARSET);
		
		// 0. css 設定
		builder.addIncludeFile(CSS);
		
		// 1. title
		setTitle(builder, Msg.getAllTableDefHtmlTitle());
		
		// 2. カラム,インデックス情報取得
		for (int i = 0; i < selectTables.length; i++) {
      
      // ログ
      progressNotifyByTableProperty(selectTables, i);
      
			ColumnProperty[] cps = DBManager.findSysColumnBySchemaTable(selectTables[i].getSchema(), selectTables[i].getTableName());
			selectTables[i].setColumnProperties(cps);
      
      IndexProperty[] ips = DBManager.findSysIndexByShemaTable(selectTables[i].getSchema(), selectTables[i].getTableName());
      selectTables[i].setIndexProperties(ips);
		}
    
		// 3. 値格納
		// table
		builder.assign("tables", selectTables);
		
		// 出力
		builder.output(path);
		return path;
	}


  /**
   * HTML builderを作成
   * @param template テンプレートファイル相対パス
   * @param charset 文字コード
   * @return builder
   */
  protected PBDocumentBuilder createHtmlDocBuilder(String template, String charset) {
    return createDocBuilder(PBDocmentBuilderFactory.HTML, TEMPLATE_HTML_DIR, template, charset);
  }

}
