package jp.co.powerbeans.eclipse.plugin.powerdbj.wizards;

import java.util.ArrayList;
import java.util.List;

import jp.co.powerbeans.common.classloader.PBClassLoadUtil;
import jp.co.powerbeans.common.swt.ChkConvSwt;
import jp.co.powerbeans.eclipse.plugin.powerdbj.Msg;
import jp.co.powerbeans.eclipse.plugin.powerdbj.db.DBManager;
import jp.co.powerbeans.eclipse.plugin.powerdbj.db.DBUtil;
import jp.co.powerbeans.eclipse.plugin.powerdbj.model.JdbcConfig;
import jp.co.powerbeans.powerql.TableProperty;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/**
 * PowerDBJWizard2SelectDB.
 * DBに接続し対象Schema,Tableを選択するウィザード画面
 * 
 * @author amonden
 * @create date 2006/09/15
 */
public class PowerDBJWizard2SelectDB extends PowerDBJWizardBase implements MouseListener, SelectionListener {


	private ISelection selection;
	private final JdbcConfig jdbcConfig;
	private Combo schemaCombo;
	private Table table;
	private Button rightButton;
	private Table selectTable;
	private Button leftButton;
	
	private static final String[] TABLE_COLS = {Msg.getSchema(), Msg.getTable()};
	private static final String[] TABLE_MODEL_COLS = new String[]{"schema", "tableName"};
	private static final int[] TABLE_COL_WIDTHS = {100,150};

	private static final String[] SELTABLE_COLS = {Msg.getSchema(), Msg.getTable()};
	private static final int[] SELTABLE_COL_WIDTHS = {100,150};

	/**
	 * Constructor for SampleNewWizardPage.
	 * @param dbinfo 
	 * 
	 * @param pageName
	 */
	public PowerDBJWizard2SelectDB(ISelection selection, DBInfo dbinfo) {
		super("PowerDBJWizard2SelectDB", dbinfo);
		this.jdbcConfig = dbinfo.getJdbcConfig();
		setTitle(Msg.getWiz2Title());
		setDescription(Msg.getWiz2Description());
		this.selection = selection;
	}

	/**
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {

		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 5;
		layout.verticalSpacing = 9;
		
		// 1. select Schema
		createLabel(container, Msg.getSchema());
		this.schemaCombo = createComboReadOnly(container);
		this.schemaCombo.addSelectionListener(this);
		createLabel(container);
		createLabel(container);
		createLabel(container);
		
		// 2. select Table
		createLabel(container);
		createLabel(container, Msg.getTable());
		createLabel(container);
		createLabel(container);
		createLabel(container, Msg.getExportTargetTable());
		
		
		createLabel(container);
		this.table = createTable(container, TABLE_COLS, TABLE_COL_WIDTHS);
		this.leftButton = createButton(container, Msg.getToLeft(), this);
		this.rightButton = createButton(container, Msg.getToRight(), this);
		this.selectTable = createTable(container, SELTABLE_COLS, SELTABLE_COL_WIDTHS);
		
		
		this.table.addMouseListener(this);

		
		initialize();
		dialogChanged();
		setControl(container);
	}

	/**
	 * データベースに接続しデータベースSchema一覧を取得する
	 */
	private void onActiveInit() {
    
		// 念のためjarファイルからクラスをロード
		Class drivercls = null;
		try {
			drivercls = PBClassLoadUtil.loadClassFromJar(this.jdbcConfig.getJarFilePath(), this.jdbcConfig.getDriverClass());
		} catch (ClassNotFoundException e) {
			updateStatus(Msg.getErrCantLoadDriverClass());
			return;
		}
		
		try {
			// 接続
			DBManager.connect(
					drivercls,
					this.jdbcConfig.getUrl(),
					this.jdbcConfig.getUser(),
					this.jdbcConfig.getPassword()
					);
			
			// スキーマ一覧取得
			this.schemaCombo.removeAll();
			this.schemaCombo.add("");
			DBManager.findSysAllSchemaToSwtComboBox(this.schemaCombo);
			
			// 接続が成功し、未登録のJDBCconfigなら追加
			insertOrUpdateJdbcConfig(this.jdbcConfig);
			
			// テーブル一覧取得
			updateTable();
			
		} catch (RuntimeException e) {
			updateStatus(Msg.getErrCantConnectDatabase());
		}
    
    // 2. 選択済みテーブルを表示
    this.selectTable.removeAll();
    // 復元すると予期しないパターンで登録される可能性があるため復元しない
//    if (getPreviousPage().getName().equals("PowerDBJWizard3SelectExportType")) {
//      // 戻った場合はデータを復元
//      DBUtil.modelsToSwtTable(this.selectTable, this.getDbinfo().getSelectTables(), new String[]{"schema","tableName"});
//    }
	}

	private void updateTable() {
		String schema = (this.schemaCombo.getSelectionIndex() >= 1) ? this.schemaCombo.getText() : "%";
		this.table.removeAll();
		DBManager.findSysTableBySchemaToSwtTable(this.table, TABLE_MODEL_COLS, schema);
	}

	/**
	 * Tests if the current workbench selection is a suitable container to use.
	 */

	private void initialize() {
		if (selection != null && selection.isEmpty() == false
				&& selection instanceof IStructuredSelection) {
			IStructuredSelection ssel = (IStructuredSelection) selection;
			if (ssel.size() > 1)
				return;
			Object obj = ssel.getFirstElement();
			if (obj instanceof IResource) {
				IContainer container;
				if (obj instanceof IContainer)
					container = (IContainer) obj;
				else
					container = ((IResource) obj).getParent();
			}
		}
	}


	/**
	 * Ensures that both text fields are set.
	 */

	private void dialogChanged() {
		if (this.selectTable.getItemCount() == 0) {
			updateStatus(Msg.getSelectExportTargetTable());
			return;
		}
		
		// 選択テーブルリストを格納
		setSelectTable();
		
		updateStatus(null);
	}

	
	/**
	 * 
	 */
	private void setSelectTable() {
		List list = new ArrayList();
		for (int i = 0; i < this.selectTable.getItemCount(); i++) {
			TableItem item = this.selectTable.getItem(i);
			TableProperty tp = new TableProperty();
			tp.setSchema(item.getText(0));
			tp.setTableName(item.getText(1));
			list.add(tp);
		}
		this.getDbinfo().setSelectTables((TableProperty[])list.toArray(new TableProperty[]{}));
	}

	public void setVisible(boolean visible) {
		super.setVisible(visible);
		
		if (visible) {
			onActiveInit();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.MouseListener#mouseDoubleClick(org.eclipse.swt.events.MouseEvent)
	 */
	public void mouseDoubleClick(MouseEvent e) {
		tableToSelectTable();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.MouseListener#mouseDown(org.eclipse.swt.events.MouseEvent)
	 */
	public void mouseDown(MouseEvent e) {
	}

	/**
	 * 右の選択テーブルで選択している行を削除
	 */
	private void selectTableToTable() {
    ChkConvSwt.addSelectItem(this.selectTable, this.table);
		ChkConvSwt.deleteSelectItem(this.selectTable);
		dialogChanged();
	}

	/**
	 * 左テーブルを右の選択テーブルに追加
	 */
	private void tableToSelectTable() {
		ChkConvSwt.addSelectItem(this.table, this.selectTable);
		ChkConvSwt.deleteSelectItem(this.table);
		dialogChanged();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.MouseListener#mouseUp(org.eclipse.swt.events.MouseEvent)
	 */
	public void mouseUp(MouseEvent e) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
		if (e.getSource() == this.schemaCombo) {
			updateTable();
		} else if (e.getSource() == this.rightButton) {
			tableToSelectTable();
		} else if (e.getSource() == this.leftButton) {
			selectTableToTable();
		}
	}
}