package jp.co.powerbeans.eclipse.plugin.charsetconv.swt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import jp.co.powerbeans.common.swt.CmdSelectionAdapter;
import jp.co.powerbeans.common.swt.PBSwt;
import jp.co.powerbeans.eclipse.plugin.charsetconv.CharsetConverter;
import jp.co.powerbeans.eclipse.plugin.charsetconv.Msg;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * 文字コード変換前の確認画面
 * @author amonden
 */
public class ConvBeforeCheckSwt extends PBSwt implements ModifyListener {


  private Combo selFileCombo;

  private Combo fromCharsetCombo;

  private Combo toCharsetCombo;

  private Text fromText;

  private StructuredSelection selection;

  private IFile[] files;

  private String[] fileNames;

  private Label fromCharsetErrorLabel;
//  private Label toCharsetErrorLabel;

  private Button[] okCancelButtons;
  
	static final int WINDOW_WIDTH = 900;
	static final int WINDOW_HEIGTH = 600;

	private static final String TITLE = Msg.getBeforeCheckTitle();

  public static final String[] CHARSETS;
  static {
    // 文字コード一覧取得
    Map map = Charset.availableCharsets();
    CHARSETS = new String[map.size()];
    int i = 0;
    for (Iterator it = map.keySet().iterator(); it.hasNext();i ++) {
      CHARSETS[i] = (String) it.next();
    }
  }
  
  public static final int BUTTON_WIDTH = 70;
  public static final int HORIZONTAL_SPACING = 3;
  public static final int MARGIN_WIDTH = 0;
  public static final int MARGIN_HEIGHT = 2;

	/**
   * コンストラクタ
	 * @param selection
	 */
	public ConvBeforeCheckSwt(StructuredSelection selection) {
		super(TITLE, WINDOW_WIDTH, WINDOW_HEIGTH, true);
    this.selection = selection;
    try {
      this.files = getFiles();
    } catch (CoreException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    this.fileNames = new String[files.length];
    for (int i = 0; i < fileNames.length; i++) {
      this.fileNames[i] = files[i].getFullPath().toString();
    }
    
		initialize();
	}	
	
	/**
	 * 画面初期化
	 */
	private void initialize() {
    
    // 1列目 全ファイルのコンボボックス
    {
      Composite comp = new Composite(this.sShell, SWT.NONE);
      GridLayout layout = new GridLayout(2, false);
      layout.horizontalSpacing = HORIZONTAL_SPACING;
      layout.marginWidth = MARGIN_WIDTH;
      layout.marginHeight = MARGIN_HEIGHT;
      comp.setLayout(layout);
      
      GridData gridData = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
      comp.setLayoutData(gridData);
      
      Label l = new Label(comp, SWT.FILL);
      l.setText(Msg.getPreviewFile());

      this.selFileCombo = new Combo(comp, SWT.FILL | SWT.READ_ONLY);
      this.selFileCombo.setVisibleItemCount(20);
      this.selFileCombo.addSelectionListener(new CmdSelectionAdapter(this, "changeFile"));
      for (int i = 0; i < fileNames.length; i++) {
        this.selFileCombo.add(fileNames[i]);
      }
      this.selFileCombo.select(0);
      registControl("selFileCombo", this.selFileCombo);
    }
    
    // 2列目移行
    {
      Composite comp = new Composite(this.sShell, SWT.FILL);
      GridLayout layout = new GridLayout(4, false);
      layout.horizontalSpacing = HORIZONTAL_SPACING;
      layout.marginWidth = MARGIN_WIDTH;
      layout.marginHeight = MARGIN_HEIGHT;
      comp.setLayout(layout);
      
      GridData gridData = new GridData(GridData.HORIZONTAL_ALIGN_END);
      comp.setLayoutData(gridData);
      
      // 2列目 文字コード選択コンボ
      Label l = new Label(comp, SWT.FILL);
      l.setText(Msg.getCharsetBeforeConvert());
      
      this.fromCharsetCombo = new Combo(comp, SWT.FILL);
      this.fromCharsetCombo.setVisibleItemCount(20);
      this.fromCharsetCombo.addSelectionListener(new CmdSelectionAdapter(this, "changeFile"));
      this.fromCharsetCombo.addModifyListener(this);
      for (int i = 0; i < CHARSETS.length; i++) {
        this.fromCharsetCombo.add(CHARSETS[i]);
      }
      registControl("fromCharsetCombo", this.fromCharsetCombo);
      this.fromCharsetCombo.setText(Charset.defaultCharset().name());
      
      Label l2 = new Label(comp, SWT.FILL);
      l2.setText(Msg.getCharsetAfterConvert());
      
      this.toCharsetCombo = new Combo(comp, SWT.FILL);
      this.toCharsetCombo.setVisibleItemCount(20);
      this.toCharsetCombo.addSelectionListener(new CmdSelectionAdapter(this, "changeFile"));
      this.toCharsetCombo.addModifyListener(this);
      for (int i = 0; i < CHARSETS.length; i++) {
        this.toCharsetCombo.add(CHARSETS[i]);
      }
      registControl("toCharsetCombo", this.toCharsetCombo);
      this.toCharsetCombo.setText(Charset.defaultCharset().name());
      
      // 3列目 ラベル
      Label l3 = new Label(comp, SWT.FILL);
      l3.setText(Msg.getPreviewFileBeforeConvert());
      this.fromCharsetErrorLabel = new Label(comp, SWT.FILL);
      new Label(comp, SWT.FILL);
      new Label(comp, SWT.FILL);

//      Label l4 = new Label(comp, SWT.FILL);
//      l4.setText("変換後ファイルプレビュー");
//      this.toCharsetErrorLabel = new Label(comp, SWT.FILL);

      // 4列目 プレビューテキストエリア
      this.fromText = new Text(comp, SWT.BORDER | SWT.MULTI | SWT.BORDER | SWT.H_SCROLL
          | SWT.V_SCROLL | SWT.READ_ONLY);
      GridData gridData4 = new GridData(GridData.FILL_BOTH);
      gridData4.horizontalSpan = 4;
      gridData4.widthHint = WINDOW_WIDTH - 36;
      gridData4.heightHint = (int) (WINDOW_HEIGTH * 0.66);
      this.fromText.setLayoutData(gridData4);

//      this.toText = new Text(comp, SWT.BORDER | SWT.MULTI | SWT.BORDER | SWT.H_SCROLL
//          | SWT.V_SCROLL);
//      this.toText.setLayoutData(gridData4);
    }

    // 5列目 OK,Cancel
    this.okCancelButtons = addOKCancel();
    
    updatePreview();
	}
  
  /**
   * selFileComboの選択が変更されたときに呼ばれるコールバックメソッド
   */
  public void cmdChangeFile() {
    updatePreview();
  }

	/**
   * プレビューテキストを更新
   */
  private void updatePreview() {
    
    if (this.fromCharsetCombo != null && this.toCharsetCombo != null &&
        this.fromText != null &&
        fromCharsetErrorLabel != null) {
    // 0. 文字コードチェック
    enableOkButton(checkCharset(this.fromCharsetCombo) && checkCharset(this.toCharsetCombo));
    
    // 1. 変換前更新
    updateTextArea(this.fromCharsetCombo, this.fromText);

// // 2. 変換後更新
// updateTextArea(this.toCharsetCombo, this.toText);
    }

  }

 

  /* (non-Javadoc)
   * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
   */
  public void modifyText(ModifyEvent e) {
    updatePreview();
  }
  
  /**
   * @param b
   */
  private void enableOkButton(boolean b) {
    this.okCancelButtons[0].setEnabled(b);
  }

  /**
   * @param combo
   * @param label
   */
  private boolean checkCharset(Combo combo) {
    return Charset.isSupported(combo.getText());
  }

  private void updateTextArea(Combo charCombo, Text text) {
    int sel_index = this.selFileCombo.getSelectionIndex();
    IFile file = this.files[sel_index];
    text.setText("");
    
    BufferedReader fin = null;
    try {
      fin = new BufferedReader(new InputStreamReader(file.getContents(), charCombo.getText()) );
      StringBuffer buf = new StringBuffer();
      
      char[] cbuf = new char[1024];
      int size = 0;
      while((size = fin.read(cbuf)) != -1) {
        buf.append(cbuf, 0, size);
      }
      
      text.setText(buf.toString());
      
    } catch (Exception e) {
      // e.printStackTrace();
    } finally {
      if(fin != null) {
        try {
          fin.close();
        } catch (IOException e) {
          e.printStackTrace();
        }
      }
    }
  }

  /**
   * selection の ファイルパスを文字列配列で取得
   * @return
	 * @throws CoreException 
   */
  private IFile[] getFiles() throws CoreException {
    Set<IResource> set = new HashSet<IResource>();
    
    for (Iterator it = this.selection.iterator(); it.hasNext();) {
      set.addAll(parseResouces(it.next()));
    }

    return (IFile[]) set.toArray(new IFile[set.size()]);
  }

  /**
   * @param obj
   * @return
   * @throws CoreException 
   */
  private Collection<IResource> parseResouces(Object obj) throws CoreException {
    Set<IResource> set = new HashSet<IResource>();
    if (obj instanceof IProject) {
      IProject project = (IProject) obj;
      IResource[] res = project.members();
      for (int i = 0; i < res.length; i++) {
        set.addAll(parseResouces(res[i]));
      }
    } else if (obj instanceof IFolder) {
      // フォルダ内のファイルを再帰的に追加
      IFolder folder = (IFolder) obj;
      IResource[] res = folder.members();
      for (int i = 0; i < res.length; i++) {
        set.addAll(parseResouces(res[i]));
      }
      
    } else if (obj instanceof IFile) {
      set.add((IFile)obj);
    }
    
    return set;
  }

  /* (non-Javadoc)
   * @see jp.co.powerbeans.common.swt.PBSwt#cmdOk()
   */
  @Override
  public void cmdOk() {
    // 変換実行
    CharsetConverter.convert(this.files, this.fromCharsetCombo.getText(), 
        this.toCharsetCombo.getText());
    
    super.cmdOk();
  }

}
