package jp.co.powerbeans.common.swt;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public abstract class PBSwt implements PBCmdDispatch, DisposeListener {

	/**
	 * メインShell
	 */
	protected org.eclipse.swt.widgets.Shell sShell;

	/**
	 * コントロール名-コントロール関連付けMap
	 */
	private Map<String, Object> controlMap;

	protected String resultCmd;

	private Image img;

	protected PBSwt(String title, int width, int height, boolean modal) {
		super();
		
		this.controlMap = new HashMap<String, Object>();
		this.resultCmd = CMD.NONE;
    createSShell(title, width, height, modal);
	}

//	/**
//	 * Shellを生成
//	 * 
//	 * @param title
//	 * @param width
//	 * @param height
//	 * @param parent_shell
//	 */
//	protected void createSShell(String title, int width, int height) {
//		createSShell(title, width, height, false);
//	}

	/**
	 * Shellを生成
	 * 
	 * @param title
	 * @param width
	 * @param height
	 * @param parent
	 */
	protected void createSShell(String title, int width, int height,
			boolean modal) {
		if (modal && Display.getCurrent() != null) {
			sShell = new org.eclipse.swt.widgets.Shell(Display.getCurrent()
					.getActiveShell(), SWT.CLOSE | SWT.PRIMARY_MODAL | SWT.RESIZE);
		} else {
			sShell = new org.eclipse.swt.widgets.Shell();
		}

		sShell.setText(title);
		sShell.setSize(new org.eclipse.swt.graphics.Point(width, height));

		setGridLayout(1);

		// set image
		try {
      ImageData imgData = new ImageData("image/icon.gif");
      img = new Image(sShell.getDisplay(), imgData); // ① Imageオブジェクトを生成
      sShell.setImage(img);
      this.sShell.addDisposeListener(this);
    } catch (RuntimeException e) {
      // ファイルが存在しない場合は無視
    }
	}
	
	public void widgetDisposed(DisposeEvent e) {
		this.img.dispose();
		this.sShell.dispose();
	}

	/**
	 * sShellにグリッドレイアウトを設定(一般的なレイアウト)
	 * 
	 * @param col
	 *            列数
	 */
	protected void setGridLayout(int col) {
		PBControlUtil.setGridLayout(this.sShell, col);
	}

	/**
	 * sShellを表示
	 * @param modal true モーダル表示(メッセージDispatch有り), false 非モーダル表示(メッセージDispatch無し)
	 * @return 処理コマンド
	 */
	public String show() {
		return show(true);
	}
	
	/**
	 * sShellを表示
	 * @param modal true モーダル表示(メッセージDispatch有り), false 非モーダル表示(メッセージDispatch無し)
	 * @return 処理コマンド
	 */
	public String show(boolean modal) {
		org.eclipse.swt.widgets.Display display = org.eclipse.swt.widgets.Display
				.getDefault();
		this.sShell.open();

		if (modal) {
			while (!this.sShell.isDisposed()) {
				if (!display.readAndDispatch())
					display.sleep();
			}
		}
		// アプリは終了しない
		// display.dispose();
		// 処理結果を返す
		return this.resultCmd;
	}

	/**
	 * コマンド対応メソッドを実行
	 * 
	 * @param cmd
	 *            コマンド
	 * @return true 実行, false 未実行
	 */
	public boolean dispatchCmd(String cmd, Object[] args) {
		if (cmd == null || cmd.length() <= 1) {
			return false;
		}
		
		String subname = cmd.substring(0, 1).toUpperCase() + cmd.substring(1);
		try {
			// 実行メソッドの引数を作成
			Class[] types = null;
			if (args != null) {
				types = new Class[args.length];
				for (int i = 0; i < args.length; i++) {
					types[i] = args[i].getClass();
				}
			}
			Method method = this.getClass().getMethod("cmd" + subname, types);
			method.invoke(this, null);
			return true;

		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

	/**
	 * 1階層メニューを作成して登録
	 * @param labels 表示ラベル
	 * @param cmds 実行コマンド(CMD.hoge)
	 */
	protected void create1LayerMenu(String[] labels, String[] cmds) {
		ChkConvSwt.assertEquals(labels.length, cmds.length);
		Menu menu = new Menu(this.sShell, SWT.BAR);
		this.sShell.setMenuBar(menu);

		for (int i = 0; i < labels.length; i++) {
			MenuItem menuItem0 = new MenuItem(menu, SWT.PUSH);
			menuItem0.setText(labels[i]);
			menuItem0.addSelectionListener(new CmdSelectionAdapter(this, cmds[i]));
		}
	}
	/**
	 * 2階層メニューを作成して登録
	 * @param labels1 1階層目表示ラベル
	 * @param labels2 2階層目表示ラベル
	 * @param cmds 2階層目実行コマンド(CMD.hoge)
	 */
	protected void create2LayerMenu(String[] labels1, String[][] labels2, String[][] cmds) {
		ChkConvSwt.assertEquals(labels1.length, labels2.length);
		ChkConvSwt.assertEquals(labels2.length, cmds.length);
		
		Menu menu = new Menu(this.sShell, SWT.BAR);
		this.sShell.setMenuBar(menu);

		for (int i = 0; i < labels1.length; i++) {
			MenuItem menuItem0 = new MenuItem(menu, SWT.CASCADE);
			menuItem0.setText(labels1[i]);
//			menuItem0.addSelectionListener(new CmdSelectionAdapter(this, cmds[i]));
			Menu pmenu = new Menu(menuItem0);
			menuItem0.setMenu(pmenu);				
			for (int j = 0; j < labels2[i].length; j++) {
				MenuItem subItem = new MenuItem(pmenu, SWT.PUSH);
				subItem.setText(labels2[i][j]);
				subItem.addSelectionListener(new CmdSelectionAdapter(this, cmds[i][j]));
			}
		}
	}

	/**
	 * Tableダブルクリック時のコマンドを登録
	 * @param table Table
	 * @param cmd コマンド
	 */
	protected void setCmdToTableOnDoubleClick(Table table, String cmd) {
		table.addMouseListener(new CmdDoubleClickMouseListener(this, cmd));
	}
	/**
	 * Tableダブルクリック時のコマンドを登録
	 * @param table Table
	 * @param cmd コマンド
	 */
	protected void setCmdToTableOnSingleClick(Table table, String cmd) {
		table.addMouseListener(new CmdSingleClickMouseListener(this, cmd));
	}
	

	/**
	 * 部品を複数(たて1列)配置できるCompositeを生成
	 * 
	 * @return composite
	 */
	protected Composite createNRow1ColComposit() {
		return PBControlUtil.createNRow1ColComposit(this.sShell);
	}

	/**
	 * 部品を複数(たて2列)配置できるCompositeを生成
	 * 
	 * @return composite
	 */
	protected Composite createNRow2ColComposit() {
		return PBControlUtil.createNRow2ColComposit(this.sShell);
	}

	/**
	 * sShellにテキストボックスを追加
	 * @param name 項目名
	 * @return テキストボックス
	 */
	protected Text addTextBox(String name) {
		Text text =  PBControlUtil.addTextBox(this.sShell);
		registControl(name, text);
		return text;
	}


  /**
   * sShellに縦横埋めテキストボックスを追加
   * @param name 項目名
   * @return テキストボックス
   */
  protected Text addTextBoxFillBoth(String name) {
    Text text = PBControlUtil.addTextBox(this.sShell, GridData.FILL_BOTH);
    registControl(name, text);
    return text;
  }

  /**
   * sShellに縦横埋めテキストエリアを追加
   * @param name 項目名
   * @return テキストボックス（複数行）
   */
  protected Text addMultiTextBoxFillBoth(String name) {
    return addMultiTextBoxFillBoth(name, 1);
  }
  
  /**
   * sShellに縦横埋めテキストエリアを追加
   * @param name 項目名
   * @return テキストボックス（複数行）
   */
  protected Text addMultiTextBoxFillBoth(String name, int colspan) {
    Text text = PBControlUtil.addTextBox(this.sShell, SWT.MULTI | SWT.BORDER | SWT.H_SCROLL
        | SWT.V_SCROLL, GridData.FILL_BOTH, colspan);
    registControl(name, text);
    return text;
  }

	/**
	 * sShellにラベルを追加
	 * @param label ラベル
	 */
	protected Label addLabel(String label) {
    return addLabel(label, SWT.TOP);
//    return addLabel(label, SWT.RIGHT);
	}
	/**
	 * sShellにラベルを追加
	 * @param label ラベル
	 */
	protected Label addLabel() {
		return addLabel("");
	}
	
	/**
	 * sShellにラベルを追加
	 * @param label ラベル
	 */
	protected Label addLabel(String label, int hstyle) {
		return PBControlUtil.createLabel(this.sShell, label, hstyle);
	}
	
  
  /**
   * sShellにラベルを追加
   * @param label ラベル
   */
  protected Label addLabelColspan(String label, int colspan) {
    return PBControlUtil.createLabel(this.sShell, label, SWT.BEGINNING, colspan);
  }
  
	/**
	 * sShellにラベルを追加
	 * @param label ラベル
	 */
	protected Label addLabel_left(String label) {
		return addLabel(label, SWT.LEFT);
	}	
	/**
	 * sShellにラベルを追加
	 * @param label ラベル
	 */
	protected Label addLabel_right(String label) {
		return addLabel(label, SWT.RIGHT);
	}
	
	/**
	 * sShellにラベルを追加
	 * @param label ラベル
	 */
	protected Label addLabel_hvcenter(String label) {
		return PBControlUtil.createLabel(this.sShell, label, SWT.CENTER, SWT.CENTER);
	}

	/**
	 * 文字列幅のボタンを追加
	 * @param label ラベル
	 * @param cmd 実行コマンド
	 * @return ボタン
	 */
	protected Button addSimpleButton(Composite comp, String label, String cmd) {
		Button button = PBControlUtil.addSimpleButton(comp, label);
		button.addSelectionListener(new CmdSelectionAdapter(this, cmd));
		return button;
	}

	/**
	 * 文字列幅のボタンを追加
	 * @param comp 
	 * @param label ラベル
	 * @param string 
	 * @return ボタン
	 */
	protected Button addSimpleButton(String label, String string) {
		return addSimpleButton(this.sShell, label, "");
	}

	/**
	 * 文字列幅,左寄りのボタンを追加
	 * @param label ラベル
	 * @param cmd コマンド
	 * @return ボタン
	 */
	protected Button addSimpleButton_Left(String label, String cmd) {
		return addSimpleButton(label, cmd);
	}

	/**
	 * 文字列幅,中央寄りのボタンを追加
	 * @param label ラベル
	 * @param cmd コマンド
	 * @return ボタン
	 */
	protected Button addSimpleButton_Center(String label) {
		Button button = addSimpleButton(this.sShell, label, "");
		((GridData) button.getLayoutData()).horizontalAlignment = GridData.CENTER;
		return button;
	}

	/**
	 * OKボタンを追加. 
	 * クリックすると cmdOk() メソッドが実行される
	 * @param comp 
	 * @return ボタン
	 */
	protected Button addOKButton(Composite comp) {
		return addSimpleButton(comp, "OK(&O)", CMD.OK);
	}

	/**
	 * Cancelボタンを追加. 
	 * クリックすると cmdCancel() メソッドが実行される.
	 * @param comp 
	 * @return ボタン
	 */
	protected Button addCancelButton(Composite comp) {
		return addSimpleButton(comp, "Cancel(&C)", CMD.CANCEL);
	}
	
	/**
	 * OKボタンの通常処理
	 */
	public void cmdOk() {
		this.resultCmd = CMD.OK;
		this.sShell.close();
	}

	/**
	 * Cancelボタンの通常処理
	 */
	public void cmdCancel() {
		this.resultCmd = CMD.CANCEL;
		this.sShell.close();
	}

	/**
	 * ラジオボタンを追加 
	 * @param name
	 * @param labels
	 * @param vals
	 * @return
	 */
	protected Button[] addRadioButtons(String name, String[] labels, int[] vals) {
		Button[] bnts = PBControlUtil.addRadioButtons(this.sShell, labels, vals);
		registControl(name, bnts);
		return bnts;
	}
	
	/**
	 * JavaBeanの各プロパティ値をSWTコントロールに格納
	 * 
	 * @param obj
	 *            コピー元Bean値
	 */
	protected void copyModelToControl(Object obj) {
		if (obj == null) {
			return;
		}
		try {
			Class<? extends Object> c = obj.getClass();
			BeanInfo info = Introspector.getBeanInfo(c);
			PropertyDescriptor[] properties = info.getPropertyDescriptors();

			for (int i = 0; i < properties.length; i++) {
				PropertyDescriptor p = properties[i];
				String name = p.getName();
				if ("class".equals(name) || p.getReadMethod() == null) {
					continue;
				}
				Method r_method = p.getReadMethod();
				Object val = r_method.invoke(obj, null);
				if (val == null) {
					continue;
				}
				String valstr = formatString(val);

				// 格納先Control取得
				Field to_field = getFieldSafe(name);
				if (to_field == null) {
					continue;
				}
				
				ControlData cd = ControlDataFactory.createInstance(getControl(name));
				cd.setText(valstr);

			}
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IntrospectionException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 引数のvalをデータ型毎に適した表示文字列を作成する
	 * @param val
	 * @return
	 */
	private String formatString(Object val) {
		if (val instanceof Date) {
			// yyyy/mm/dd 型で取得
			return new SimpleDateFormat("yyyy/MM/dd").format(val); 
		} else {
			return val.toString();
		}
	}

	private Field getFieldSafe(String name) {
		try {
			return this.getClass().getDeclaredField(name);
		} catch (NoSuchFieldException e) {
			// ありえる
		}
		return null;
	}

	protected Object copyControlToMode(Class c) {
		Object obj = null;
		try {
			BeanInfo info = Introspector.getBeanInfo(c);
			PropertyDescriptor[] properties = info.getPropertyDescriptors();
			obj = c.newInstance();

			for (int i = 0; i < properties.length; i++) {
				PropertyDescriptor p = properties[i];
				String name = p.getName();
				try {
					if ("class".equals(name) || p.getWriteMethod() == null) {
						continue;
					}

					// 値取得元Control取得
					Field to_field = getFieldSafe(name);
					if (to_field == null) {
						continue;
					}

					ControlData cd = ControlDataFactory.createInstance(getControl(name));
					String valstr = cd.getText();
					Object val = valstr;
					
					if (val == null) {
						continue;
					}

					// 値を格納
					if (p.getPropertyType() == Date.class) {
						val = ChkConvSwt.getDate(val.toString());
					}
					BeanUtils.setProperty(obj, name, val);
				} catch (ChkConvSwtRuntimeException e) {
					// エラー発生時のControlをフォーカス
					getControl(name)[0].setFocus();
					throw e;
				}
			}
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IntrospectionException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		}
		return obj;
	}
	
	/**
	 * コントロール名とコントロールをコントロールMapに登録する
	 * @param name コントロール名(プロパティ名)
	 * @param ctrl コントロール
	 */
	protected void registControl(String name, Control ctrl) {
		if (name != null && name.length() > 0) {
			this.controlMap.put(name, ctrl);
		}
	}	/**
	 * コントロール名とコントロールをコントロールMapに登録する
	 * @param name コントロール名(プロパティ名)
	 * @param ctrl コントロール
	 */
	private void registControl(String name, Control[] ctrl) {
		if (name != null && name.length() > 0) {
			this.controlMap.put(name, ctrl);
		}
	}

	/**
	 * コントロール名から生成済みコントロールを取得する.
	 * @param name コントロール名
	 * @return コントロール
	 */
	private Control[] getControl(String name) {
		
		Object obj = this.controlMap.get(name);
		if (obj == null) {
			// Log.warn("getControl(" + name + ") is null. ");
			return null;
		}
		else if (obj.getClass().isArray()) {
			// 配列の場合(ラジオボタンなど）選択値を値として返す
			return (Control[]) obj;
		} else {
			return new Control[]{(Control) obj};
		}
	}
	
	private Combo createReadOnlyComboBox() {
		return createComboBox(SWT.READ_ONLY, 1);
	}
  private Combo createReadOnlyComboBox(int colspan) {
    return createComboBox(SWT.READ_ONLY, colspan);
  }
	
	private Combo createEditableComboBox() {
		return createComboBox(SWT.NULL, 1);
	}
	
	private Combo createComboBox(int style, int colspan) {
		return PBControlUtil.createComboBox(this.sShell, style, colspan);
	}
	
//	protected Combo addComboBoxByModel(Class model_cls, String col, String cmd) {
//		return addComboBoxByModel(null, model_cls, col, cmd);
//	}

//	protected Combo addComboBoxByModel(String name, Class model_cls, String col, String cmd) {
//		Combo combo = createReadOnlyComboBox();
//		DBManager.findByAllToSwtComboBox(combo, model_cls, col);
//		combo.addSelectionListener(new CmdSelectionAdapter(this, cmd));
//		registControl(name, combo);
//		return combo;
//	}

  protected Combo addComboBox(String name, String[] labels) {
    return addComboBox(name, labels, 1);
  }

	protected Combo addComboBox(String name, String[] labels, int colspan) {
		Combo combo = createReadOnlyComboBox(colspan);
		for (int i = 0; i < labels.length; i++) {
			combo.add(labels[i]);
		}
		registControl(name, combo);
		return combo;
	}
  protected Combo addComboBox(String name, String[] labels, int colspan, String cmd) {
    Combo combo = addComboBox(name, labels, colspan);
    // ここにcmdのリスナーを追加
    combo.addSelectionListener(new CmdSelectionAdapter(this, cmd));
    return combo;
  }

	protected Combo addComboBoxEditable(String name, String[] labels) {
		Combo combo = createEditableComboBox();
		for (int i = 0; i < labels.length; i++) {
			combo.add(labels[i]);
		}
		registControl(name, combo);
		return combo;
	}

	protected void selectTop(Combo combo) {
		if (combo != null && combo.getItemCount() > 0) {
			combo.select(0);
		}
	}

	/**
	 * ラジオボタンを選択する
	 * @param button 
	 */
	protected void selectItem(Button button) {
		button.setSelection(true);
	}

	protected Table addSimpleTable(String[] cols, int[] wids) {
		return PBControlUtil.createSimpleTable(this.sShell, cols, wids);
	}

	protected Table addMiniTable(String[] cols, int[] wids) {
		Table table = PBControlUtil.createSimpleTable(this.sShell, cols, wids);
		setMinimumHeight(table, 100);
		return table;
	}

	protected void setHorizontalSpan(Control c, int colspan) {
		GridData grid = (GridData) c.getLayoutData();
		grid.horizontalSpan = colspan;
	}
	
	protected void setVerticalSpan(Control c, int colspan) {
		GridData grid = (GridData) c.getLayoutData();
		grid.verticalSpan = colspan;
	}

	protected void setSpan(Control c, int colspan, int rowspan) {
		GridData grid = (GridData) c.getLayoutData();
		grid.horizontalSpan = colspan;
		grid.verticalSpan = rowspan;
	}

	protected void setWidth(Control c, int width) {
		GridData grid = (GridData) c.getLayoutData();
		grid.widthHint = width;
	}

	protected void setHeight(Control c, int heigth) {
		GridData grid = (GridData) c.getLayoutData();
		grid.heightHint = heigth;
	}
	protected void setMinimumWidth(Control c, int width) {
		GridData grid = (GridData) c.getLayoutData();
		grid.minimumWidth = width;
	}

	protected void setMinimumHeight(Control c, int heigth) {
		GridData grid = (GridData) c.getLayoutData();
		grid.minimumHeight = heigth;
		c.setLayoutData(grid);
	}

	protected void addTableRow(Table table, String[] data) {
		PBControlUtil.addRow(table, data);
	}

	protected void insertTableRowTop(Table table, String[] data) {
		PBControlUtil.insertRowTop(table, data);
	}

	/**
	 * @return resultCmd を戻します。
	 */
	public String getResultCmd() {
		return resultCmd;
	}

	protected void addLabels(int num, int col_width) {
		for(int i = 0; i < num; i++) {
			setWidth(addLabel_left(""), col_width);
		}
	}
  protected Composite createRightAlignmentComposite() {
    Composite c = new Composite(this.sShell, SWT.NONE);
    GridLayout layout = new GridLayout(2, false);
//    layout.horizontalSpacing = GridData.H. FILL_SPACING;
    c.setLayout(layout);
    GridData data = new GridData(GridData.HORIZONTAL_ALIGN_END);
    data.horizontalSpan = 2;
    c.setLayoutData(data);
    return c;
}

  /**
   * OKボタンとキャンセルボタンを追加する.
   * GridLayoutの最終行に独自Compositeで追加
   */
  protected Button[] addOKCancel() {
    Composite comp = createRightAlignmentComposite();
    Button[] buttons = new Button[2];
    buttons[0] = addOKButton(comp);
    buttons[1] = addCancelButton(comp);
    return buttons;
  }

}
