package jp.co.powerbeans.common.swt;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public final class ControlDataFactory {
	private static final Map<Class<?>, Class<?>> controlTypeMap;
	static {
		controlTypeMap = new HashMap<Class<?>, Class<?>>();
		controlTypeMap.put(Text.class, PBTextControlData.class);
		controlTypeMap.put(Combo.class, PBComboControlData.class);
		controlTypeMap.put(Button.class, PBButtonControlData.class);
	}

	public static ControlData createInstance(Control[] control) {
		try {
			Class type = control[0].getClass();
			Class cdclass = (Class) controlTypeMap.get(type);
			if (ControlData.class.isAssignableFrom(cdclass)) {
				Constructor ct = cdclass.getConstructor(new Class[]{Control[].class});
				return (ControlData) ct.newInstance(new Object[]{control});
			}
			throw new RuntimeException(type.getName() + " is not implements ControlData.");
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

}
