package jp.co.powerbeans.common.swt;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;



/**
 * メニュー、ボタン選択時の汎用イベントハンドラ
 * @author amonden
 */
public class CmdSelectionAdapter extends SelectionAdapter {

	private String cmd;
	private PBCmdDispatch composit;
	private Object[] args;

	public CmdSelectionAdapter(PBCmdDispatch composit, String cmd) {
		this.cmd = cmd;
		this.composit = composit;
	}

	public CmdSelectionAdapter(PBComposite composit, String cmd, Object[] args) 
	{
		this.cmd = cmd;
		this.composit = composit;
		this.args = args;
	}

	public void widgetSelected(SelectionEvent e) {
		this.composit.dispatchCmd(this.cmd, args);
	}
}