package jp.co.powerbeans.common.swt;


import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public final class ChkConvSwt {

	private ChkConvSwt() {
		super();
	}

	/**
	 * tableの選択行を返す
	 * @param table
	 * @return
	 */
	public static int getSelectIndex(Table table) {
		return assertSelect(table);
	}

	/**
	 * tableの選択行のID(１列目)を返す
	 * @param table
	 * @return
	 */
	public static int getSelectId(Table table) {
		return getSelectId(table, getSelectIndex(table));
	}
	
	/**
	 * tableのrowindex行のID(１列目)を返す
	 * @param table
	 * @param rowindex
	 * @return
	 */
	public static int getSelectId(Table table, int rowindex) {
		assertSelect(table);
		TableItem item = table.getItem(rowindex);
		try {
			return Integer.parseInt(item.getText(0));
		} catch (NumberFormatException e) {
//			MsgSwt.dispatchException(e);
			return 0;
		}
	}

	/**
	 * tableの選択行のID(1列目)のリストを返す
	 * @param table
	 * @return IDリスト
	 */
	public static int[] getSelectIds(Table table) {
		assertSelect(table);
		int[] indexs = table.getSelectionIndices();
		int[] ids = new int[indexs.length];
		for (int i = 0; i < indexs.length; i++) {
			ids[i] = getSelectId(table, indexs[i]);
		}
		return ids;
	}
	
	public static Object getSelectObject(Table table) {
		int sel = assertSelect(table);
		Object obj = table.getData();
		if (obj == null || !obj.getClass().isArray()) {
			return null;
		}
		if (sel >= Array.getLength(obj)) {
			return null;
		}
		return Array.get(obj, sel);
	}

	private static int assertSelect(Table table) {
		int sel = table.getSelectionIndex();
		if (sel == -1) {
//			MsgSwt.warnSelTable1Row();
			throw new ChkConvSwtRuntimeException("no select table row.");
		}
		return sel;
	}

	public static Object getSelectObject(Combo combo) {
		int sel = asssertSelect(combo);
		Object obj = combo.getData();
		if (obj == null || !obj.getClass().isArray()) {
			return null;
		}
		return Array.get(obj, sel);
	}
	public static String getSelectObjectPK(Combo combo) {
		Object obj = getSelectObject(combo);
		
		if (obj == null) {
			return "";
		}
		
		// クラス名を取得
		Class cls = obj.getClass();
		// PKプロパティ名を作成
		String clsorg = cls.getName().substring(cls.getName().lastIndexOf(".") + 1);
		String propname = clsorg.substring(0, 1).toLowerCase() + 
			clsorg.substring(1) + "Id";
		
		// 値を取得
		try {
			return BeanUtils.getProperty(obj, propname);
		} catch (Exception e) {
			throw new ChkConvSwtRuntimeException(e, "can't find pk field {" + propname + "} in " + cls.getName() + ".");
		}
	}

	private static int asssertSelect(Combo combo) {
		int sel = combo.getSelectionIndex();
		if (sel == -1) {
//			MsgSwt.warnSelCombo();
			throw new ChkConvSwtRuntimeException("no select combobox.");
		}
		return sel;
	}

	public static Date getDate(String src) {
		try {
			if (src == null || src.length() == 0) {
				return null;
			}
			return new SimpleDateFormat("yyyy/MM/dd").parse(src);
		} catch (ParseException e) {
			// フォーマット不正
//			MsgSwt.warnInvalidDate();
			throw new ChkConvSwtRuntimeException("invalid date format.");
		}
	}

	public static void assertEquals(int length, int length2) {
		if (length != length2) {
			throw new ChkConvSwtRuntimeException("not equals size " + length + " : " + length2);
		}
	}
	
	public static void addSelectItem(Table from_table, Table to_table) {
		int[] selids = from_table.getSelectionIndices();
		
		SELIDS:for (int i = 0; i < selids.length; i++) {
			TableItem fitem = from_table.getItem(selids[i]);
			
			// fitem と同じ値が to_table に存在する場合は追加しない
			GET_ITEM_CONT:for (int j = 0; j < to_table.getItemCount(); j++) {
				for (int k = 0; k < from_table.getColumnCount(); k++) {
					if (!fitem.getText(k).equals(to_table.getItem(j).getText(k))) {
						break GET_ITEM_CONT;
					}
				}
				// すべて一致したので追加しない
				continue SELIDS;
			}
			
	        TableItem titem = new TableItem(to_table, SWT.NULL);
	        
	        String[] strs = new String[from_table.getColumnCount()];
	        for (int j = 0; j < strs.length; j++) {
				strs[j] = fitem.getText(j);
			}
	        
	        titem.setText(strs);
		}
	}
	
	public static void deleteSelectItem(Table table) {
		while(table.getSelectionCount() > 0) {
			table.remove(table.getSelectionIndex());
		}
	}

}
