package jp.co.powerbeans.eclipse.plugin.powerdbj.wizards;

import jp.co.powerbeans.eclipse.common.PBFileUtil;
import jp.co.powerbeans.eclipse.plugin.powerdbj.Msg;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * PowerDBJWizard3SelectExportType.
 * 出力するタイプを選択し出力する画面
 * 
 * @author amonden
 * @create date 2006/09/15
 */
public class PowerDBJWizard3SelectExportType extends PowerDBJWizardBase implements SelectionListener, ModifyListener {


	private static final String[] EXPORT_TYPES =  {
    Msg.getExportType1Name(),
    Msg.getExportType2Name(),
    Msg.getExportType3Name(),
    Msg.getExportType4Name(),
    Msg.getExportType5Name(),
  };
  
  private static final String[] EXPORT_TYPES_EXP =  {
    Msg.getExportType1Exp(),
    Msg.getExportType2Exp(),
    Msg.getExportType3Exp(),
    Msg.getExportType4Exp(),
    Msg.getExportType5Exp(),
  };
  
  
//  private static final String[] EXPORT_TYPES =  {
//    "HTML Table define        (allTableDef.html),*.html",
//    "HTML Table def&contents  (allTableDefCont.html),*.html",
//    "Excel Table define       (allTableDef.xls),*.xls",
//    "JAVA Table Model         (TableModel.java),*.java",
//    "JAVA DAO                 (PowerQLDAO.java,PowerQLDAOImpl.java),*.java",
//  };
  
  private static final boolean[] BROWSE_SINGLEFILE =  {
    true, true, true, false, false
  };
	private ISelection selection;
	private Combo exportTypeCombo;
	private Text outputDirText;
	private Button borwseButton;

  private Label expLabel;
	
	/**
	 * Constructor for SampleNewWizardPage.
	 * @param dbinfo 
	 * 
	 * @param pageName
	 */
	public PowerDBJWizard3SelectExportType(ISelection selection, DBInfo dbinfo, boolean last_page) {
		super("PowerDBJWizard3SelectExportType", dbinfo, last_page);
		setTitle(Msg.getWiz3Title());
		setDescription(Msg.getWiz3Description());
		this.selection = selection;
	}

	/**
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {

		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 9;
		
		// 1. select export type
		createLabel(container, Msg.getSelectExportType());
		this.exportTypeCombo = createComboReadOnly(container,EXPORT_TYPES);
		this.exportTypeCombo.select(0);
		this.exportTypeCombo.addSelectionListener(this);
		createLabel(container);

		// 2. output path
		new Label(container, SWT.NULL).setText(Msg.getOutputDir());
		this.outputDirText = createText(container, this);
		this.borwseButton = createButton(container, Msg.getBrowse(), this);
    
    // 3. 説明
    this.expLabel = createLabelHSpan(container, 3);
		
		initialize();
		dialogChanged();
		setControl(container);
	}

	/**
	 * Tests if the current workbench selection is a suitable container to use.
	 */

	private void initialize() {
		if (selection != null && selection.isEmpty() == false
				&& selection instanceof IStructuredSelection) {
			IStructuredSelection ssel = (IStructuredSelection) selection;
			if (ssel.size() > 1)
				return;
			Object obj = ssel.getFirstElement();
			if (obj instanceof IResource) {
				IContainer container;
				if (obj instanceof IContainer)
					container = (IContainer) obj;
				else
					container = ((IResource) obj).getParent();
			}
		}
	}

	/**
	 * Ensures that both text fields are set.
	 */

	private void dialogChanged() {
		if (this.outputDirText.getText().length() == 0) {
			updateStatus(Msg.getInputOutputDirectory());
			return;
		}

		// 入力値を格納
		this.getDbinfo().setFinish(true);
		this.getDbinfo().setOutputPath(this.outputDirText.getText());
		updateStatus(null);
	}

	public void setVisible(boolean visible) {
		super.setVisible(visible);
		
		if (visible) {
      onChangeTypeCombo();
		}
	}
	
	/**
	 * Uses the standard container selection dialog to choose the new value for
	 * the container field.
	 */

	private void handleBrowse() {
    
    String path = null;
    
    if (BROWSE_SINGLEFILE[this.exportTypeCombo.getSelectionIndex()]) {
      // ファイル選択
  		FileDialog dialog = new FileDialog(getShell());
      
      // exportTypeCombo の選択肢より拡張子を取得
      String ext = this.exportTypeCombo.getText().split("\\(")[1].replace(")", "");
  		dialog.setFilterExtensions(new String[]{ext});
      
  		path = dialog.open();
    } else {
      DirectoryDialog dialog = new DirectoryDialog(getShell());
      path = dialog.open();
    }
    
		if (path != null) {
			// 選択した場合
			
			// \ の場合は / に置換
			path = PBFileUtil.toUnixPath(path);
			// コンボボックスに格納
			this.outputDirText.setText(path);
			
			dialogChanged();
		}
	}


	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
		if (e.getSource() == this.borwseButton) {
			handleBrowse();
		} else {
			onChangeTypeCombo();
		}
	}

  /**
   * エクスポートタイプコンボ変更時処理
   */
  private void onChangeTypeCombo() {
    // Export Type 選択値を格納
    getDbinfo().setExportType(this.exportTypeCombo.getSelectionIndex());
    getDbinfo().setExportTypeName(this.exportTypeCombo.getText());
    
    // 説明文更新
    this.expLabel.setText(EXPORT_TYPES_EXP[this.exportTypeCombo.getSelectionIndex()]);
  }

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e) {
		dialogChanged();
	}

}