/**
 * PowerDBJ
 * create date 2006/09/21
 * amonden
 */
package jp.co.powerbeans.eclipse.plugin.powerdbj.export.excel;


import jp.co.powerbeans.docbuild.PBDocmentBuilderFactory;
import jp.co.powerbeans.docbuild.PBDocumentBuilder;
import jp.co.powerbeans.docbuild.excel.ExcelBuilder;
import jp.co.powerbeans.eclipse.common.MsgSwt;
import jp.co.powerbeans.eclipse.common.PBEclipseUtil;
import jp.co.powerbeans.eclipse.plugin.powerdbj.Msg;
import jp.co.powerbeans.eclipse.plugin.powerdbj.db.DBManager;
import jp.co.powerbeans.eclipse.plugin.powerdbj.export.ExporterBase;
import jp.co.powerbeans.eclipse.plugin.powerdbj.model.JdbcConfig;
import jp.co.powerbeans.powerql.ColumnProperty;
import jp.co.powerbeans.powerql.IndexProperty;
import jp.co.powerbeans.powerql.TableProperty;

/**
 * TableDefHtmlExporter
 * @author amonden
 * @create date 2006/09/21
 */
public abstract class ExcelExporterBase extends ExporterBase {

  protected static final String TEMPLATE_EXCEL_DIR = PBEclipseUtil.getPluginsPath() + "/" 
  + Msg.getConfigCurrentDir() + "/template/excel/";

  /* (non-Javadoc)
   * @see jp.co.powerbeans.eclipse.plugin.powerdbj.export.Exporter#export(jp.co.powerbeans.eclipse.plugin.powerdbj.model.JdbcConfig, jp.co.powerbeans.powerql.TableProperty[], java.lang.String)
   */
  public String export(JdbcConfig jdbcConfig, TableProperty[] selectTables, String path, String template) {

    PBDocumentBuilder builder = createExcelDocBuilder(template, "UTF-8");

    // 1. カラム,インデックス情報取得
    // sheetName プロパティを持つBeanでselectTablesをラップする
    SheetTableProperty[] stp = new SheetTableProperty[selectTables.length];
    for (int i = 0; i < selectTables.length; i++) {
      ColumnProperty[] cps = DBManager.findSysColumnBySchemaTable(selectTables[i].getSchema(), selectTables[i].getTableName());
      selectTables[i].setColumnProperties(cps);
      
      IndexProperty[] ips = DBManager.findSysIndexByShemaTable(selectTables[i].getSchema(), selectTables[i].getTableName());
      selectTables[i].setIndexProperties(ips);
      
      stp[i] = new SheetTableProperty(selectTables[i]);
    }
    
    // 3. 値格納
    // 1. title
    setTitle(builder, Msg.getAllTableDefExcelTitle());
    // table
    builder.assign(ExcelBuilder.PAR_SHEET_LIST, stp);
    
    // 出力
    builder.output(path);
    return path;
  }

  /**
   * Excel builderを作成
   * @param template テンプレートファイル相対パス
   * @param charset 文字コード
   * @return builder
   */
  protected PBDocumentBuilder createExcelDocBuilder(String template, String charset) {
    return createDocBuilder(PBDocmentBuilderFactory.EXCEL, TEMPLATE_EXCEL_DIR, template, charset);
  }
	


}
