<?php
/*
 * blogプラグイン v2.0
 */

/*add below to <lang>.lng
///////////////////////////////////////
// blog2.inc.php
$_plugin_blog2_error_nomessage = '本文がありません。';
$_plugin_blog2_error_nosubject = 'タイトルがありません。';
$_plugin_blog2_error_nocategory = 'カテゴリがありません。';
$_plugin_blog2_error_nodate = '日付がありません。';
$_plugin_blog2_error_continue = '継続元のページが存在しません。';
$_plugin_blog2_error_dateformat = '日付の書式が違います。';
$_plugin_blog2_error_date = '存在しない日付になっています。';
$_plugin_blog2_error_less = '記入項目が満たされてません。';
$_plugin_blog2_error_password = 'パスワードが違います。';
$_plugin_blog2_error_exist = 'ページがすでに存在します。Subjectを変更してください。';
$_plugin_blog2_mes_category = 'Category';
$_plugin_blog2_mes_continue_on = 'continue on';
$_plugin_blog2_mes_continue_from = 'continue form';
$_plugin_blog2_input_subject = 'subject';
$_plugin_blog2_input_category = 'category';
$_plugin_blog2_input_continue = 'continue from';
$_plugin_blog2_button_submit = 'submit';
$_plugin_blog2_button_category = 'カテゴリーに追加';
$_plugin_blog2_input_date = 'date';
$_plugin_blog2_input_password = 'password';
*/

define('PLUGIN_BLOG2_CATEGORY_PREFIX','日記/Category');
define('PLUGIN_BLOG2_PREFIX','日記');
define('PLUGIN_BLOG2_SUBJECT_COLS',70);
define('PLUGIN_BLOG2_CATEGORY_COLS',70);
define('PLUGIN_BLOG2_MESSAGE_COLS',80);
define('PLUGIN_BLOG2_MESSAGE_ROWS',15);
define('PLUGIN_BLOG2_SHIFTTIME', 0*60*60);	//日付の境目となる時間。０時０分０秒からの経過秒数。
define('PLUGIN_BLOG2_SELECTDATE', false);	//trueのとき日付指定ができる。falseだと投稿時の時計を使う。
define('PLUGIN_BLOG2_TIMESTAMP', true);	//trueのとき記事の最後にタイムスタンプを残す。
define('PLUGIN_BLOG2_FREEZE', false);	//trueのとき記事ページを凍結する（カテゴリページ、日付ページはこの設定にかかわらず凍結されます。
define('PLUGIN_BLOG2_COOKIE', true);	//trueのときクッキーを使ってパスワードを保存する
define('PLUGIN_BLOG2_PASSWORD', $GLOBALS['adminpass']);	//入力用パスワード



/**
 * ブロック型プラグインの呼び出し用関数。
 */
function plugin_blog2_convert()
{
	return plugin_blog2_getform();
}



/**
 * URL指定型プラグインの呼び出し用関数。
 * 記事投稿時に呼び出される。
 */
function plugin_blog2_action()
{
	global $post;
	global $_plugin_blog2_error_less, $_plugin_blog2_error_exist;
	
	
	$ret = plugin_blog2_checkpostdata();
	if($ret != ''){
		$body = $ret . plugin_blog2_getform(
			trim($post['subject']),
			trim($post['category']),
			trim($post['message']),
			trim($post['continue']),
			PLUGIN_BLOG2_SELECTDATE ? trim($post['date']) : '',
			$post['password']
		);
		return array('msg'=>$_plugin_blog2_error_less, 'body'=>$body);
	}
	
	
	$continue = trim($post['continue']);
	$subject = trim($post['subject']);
	$message = trim($post['message']);
	$cate = explode('|', $post['category']);
	foreach($cate as $c){
		$c = trim($c);
		if($c != ''){
			$categories[] = $c;
		}
	}
	$categories = array_unique($categories);
	
	$date = get_date('Y-m-d');
	$time = get_date('H:i:s');
	$_date = get_date('Y-m-d', UTIME - PLUGIN_BLOG2_SHIFTTIME);
	if($date != $_date){
		$date = $_date;
		$_time = explode(':', $time);
		$_time[0] += 24;
		$time = join(':', $_time);
	}
	if(PLUGIN_BLOG2_SELECTDATE == true){
		$date = $post['date'];
	}
	
	$pagename = rtrim(PLUGIN_BLOG2_PREFIX, '/') . '/' . $date. '/' . $subject;
	
	//すでに存在するページに書くのはNG
	if(is_page($pagename)){
		$body = "<p>$_plugin_blog2_error_exist</p>" . plugin_blog2_getform(
			trim($post['subject']),
			trim($post['category']),
			trim($post['message']),
			trim($post['continue']),
			PLUGIN_BLOG2_SELECTDATE ? trim($post['date']) : '',
			$post['password']
		);
		return array('msg'=>$_plugin_blog2_error_exist, 'body'=>$body);
	}
	
	
	plugin_blog2_write($subject, $message, $categories, $date, $time, $continue);
	plugin_blog2_setcategory($categories, $date, $subject, $pagename);
	if($continue != ''){
		plugin_blog2_setcontinuepath($continue, $pagename, $subject);
	}
	
	if(PLUGIN_BLOG2_COOKIE == true){
		setcookie('plugin_blog2', $post['password'], time()+30*24*60*60);
	}
}



/**
 * 投稿記事の保存。
 * @param	string	$subject	タイトル
 * @param	string	$message	済み本文
 * @param	array(string)	$categories	カテゴリ
 * @param	string	$date	日付
 * @param	string	$time	投稿時間
 * @param	string	$continue	続き元ページ。ない場合は空文字列。
 */
function plugin_blog2_write($subject, $message, $categories, $date, $time, $continue)
{
	global $_plugin_blog2_mes_continue_from, $_plugin_blog2_mes_category;
	
	$blogname = rtrim(PLUGIN_BLOG2_PREFIX, '/');
	$datepagename = $blogname . '/' . $date;
	$pagename = $datepagename . '/' . $subject;
	$timestamp = PLUGIN_BLOG2_SELECTDATE ? "$date $time" : $time;
	
	if(preg_match('|^.+?/.+/(.+)$|', $continue, $matches)){
		$continue_from = "LEFT:$_plugin_blog2_mes_continue_from: &#x5b;[[$matches[1]>$continue]]&#x5d;\n";
	}
	else{
		$continue_from = '';
	}
	
	$catlist = '';
	foreach($categories as $c){
		$catlist .= "&#x5b;[[$c>" . rtrim(PLUGIN_BLOG2_CATEGORY_PREFIX, '/') . "/$c]]&#x5d;";
	}
	
	$freeze = PLUGIN_BLOG2_FREEZE ? "#freeze\n" : '';
	
	$body  = $freeze;
	$body .= "#blog2navi()\n";
	$body .= "*$subject\n";
	$body .= $continue_from;
	$body .= "\n";
	$body .= $message . "\n";
	$body .= "\n";
	$body .= "RIGHT:$_plugin_blog2_mes_category: $catlist" . (PLUGIN_BLOG2_TIMESTAMP ? " - $timestamp\n" : "\n");
	$body .= "----\n";
	$body .= "RIGHT:&blog2trackback();\n";
	$body .= "#comment(above)\n";
	$body .= "#blog2navi()\n";
	page_write($pagename, $body);
	
	$old = join('', get_source($datepagename));
	$old = preg_replace("/^#freeze\n/", '', $old);
	if($old == ''){
		$old = "#blog2navi()\n\n\n#blog2viewer()\n#blog2navi()";
	}
	$old = preg_replace('/#blog2navi\(\)\n\n/', "#blog2navi()\n\n//-[[$subject>$pagename]]\n", $old);
	page_write($datepagename, "#freeze\n" . $old, true);
}



/**
 * 「続き」の元記事に続き先のリンクをはる。
 * @param	string	$from	続き元ページ名
 * @param	string	$to_pagename	続き先ページ名
 * @param	string	$to_subject	続き先タイトル
 */
function plugin_blog2_setcontinuepath($from, $to_pagename, $to_subject)
{
	global $_plugin_blog2_mes_continue_on;
	global $_plugin_blog2_mes_category;
	
	$pattern = "/(\nRIGHT:" . preg_quote($_plugin_blog2_mes_category, '/') . ":.*\n----\n)/";
	$replace = "\nRIGHT:$_plugin_blog2_mes_continue_on: &#x5b;[[$to_subject>$to_pagename]]&#x5d;$1";
	$source = join('', get_source($from));
	$body = preg_replace($pattern, $replace, $source);
	page_write($from, $body, true);
}



/**
 * カテゴリに登録する。
 * @param	array(string)	$categories
 * @param	string	$date
 * @param	string	$subject
 * @param	string	$pagename
 */
function plugin_blog2_setcategory($categories, $date, $subject, $pagename)
{
	foreach($categories as $c){
		$list = "-($date)&nbsp;&nbsp;[[$subject>$pagename]]\n";
		$cpage = rtrim(PLUGIN_BLOG2_CATEGORY_PREFIX, '/') . '/' . $c;
		$old = join('', get_source($cpage));
		$old = preg_replace("/^#freeze\n/", '', $old);
		page_write($cpage, "#freeze\n" . $list . $old, true);
	}
}



/**
 * POSTされたデータのチェック。
 * @return	string	問題が無ければ空文字列を返す。あればエラーメッセージを返す。
 */
function plugin_blog2_checkpostdata()
{
	global $post;
	global $_plugin_blog2_error_nomessage, $_plugin_blog2_error_nosubject, $_plugin_blog2_error_nocategory, $_plugin_blog2_error_continue;
	global $_plugin_blog2_error_nodate, $_plugin_blog2_error_dateformat, $_plugin_blog2_error_date;
	global $_plugin_blog2_error_password;
	
	$error = '';
	
	//本文とタイトルの入力チェック
	$checklist = array('message', 'subject');
	foreach($checklist as $v){
		if(!isset($post[$v]) || trim($post[$v]) == ''){
			$mesvn = '_plugin_blog2_error_no' . $v;
			$error .= '<p>' . $$mesvn . '</p>';
		}
	}
	
	//カテゴリの入力チェック
	if(!isset($post['category']) || !preg_match("/[^\s\t\n\r\x0b|]/", $post['category'])){
		$error .= '<p>' . $_plugin_blog2_error_nocategory . '</p>';
	}
	
	//「続き」の元記事のチェック
	if(!isset($post['continue']) || (trim($post['continue']) != '' && !is_page(trim($post['continue'])))){
		$error .= '<p>' . $_plugin_blog2_error_continue . '</p>';
	}
	
	//入力された日付のチェック
	if(PLUGIN_BLOG2_SELECTDATE == true){
		if(!isset($post['date']) || trim($post['date']) == ''){
			$error .= '<p>' . $_plugin_blog2_error_nodate . '</p>';
		}
		else{
			$date = str_replace('/', '-', trim($post['date']));
			if(preg_match('/^(\d{4})-(\d{1,2})-(\d{1,2})$/', $date, $matches) == 0){
				$error .= '<p>' . $_plugin_blog2_error_dateformat . '</p>';
			}
			else{
				if(plugin_blog2_checkdata($matches[1], $matches[2], $matches[3]) == false){
					$error .= '<p>' . $_plugin_blog2_error_date . '</p>';
				}
				else{
					$post['date'] = sprintf('%4d-%02d-%02d', $matches[1], $matches[2], $matches[3]);
				}
			}
		}
	}
	
	//パスワードのチェック
    $pass = isset($post['password']) ? $post['password'] : NULL;
    if ($pass === NULL || !pkwk_login($pass)) {
	//if(!isset($post['password']) || md5($post['password']) != PLUGIN_BLOG2_PASSWORD){
		$error .= '<p>' . $_plugin_blog2_error_password . '</p>';
		if($post['password'] == ''){	//空文字列送信の時クッキー削除
			setcookie('plugin_blog2', '', -3600);
		}
	}
	
	
	return $error;
}


/**
 * 正しい日付かどうかを調べる。
 * @return	bool	正しい日付ならtrueを、そうでなければfalseを返す。
 */
function plugin_blog2_checkdata($y, $m, $d)
{
	$misoka = array(0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
	if(($y%4 == 0) && (($y%100) != 0 || ($y%400) == 0)){
		$misoka[2] = 29;
	}
	
	if((1 <= $m && $m <= 12) && (1 <= $d && $d <= $misoka[(int)$m])){
		return true;
	}
	else{
		return false;
	}
}



/**
 * 投稿フォームを取得する。
 * @return	string	HTML形式の文字列
 */
function plugin_blog2_getform($subject = '', $category = '', $message = '', $continue = '', $date = '', $password = '')
{
	global $script;
	global $_plugin_blog2_input_subject, $_plugin_blog2_input_category;
	global $_plugin_blog2_button_submit;
	global $_plugin_blog2_button_category;
	global $_plugin_blog2_input_continue;
	global $_plugin_blog2_input_date;
	global $_plugin_blog2_input_password;
	
	$subject_cols = PLUGIN_BLOG2_SUBJECT_COLS;
	$cat_cols = PLUGIN_BLOG2_CATEGORY_COLS;
	$blog_cols = PLUGIN_BLOG2_MESSAGE_COLS;
	$blog_rows = PLUGIN_BLOG2_MESSAGE_ROWS;
	
	
	//カテゴリ選択ボタンの準備
	$existpages = get_existpages();
	$prefix = rtrim(PLUGIN_BLOG2_CATEGORY_PREFIX, '/') . '/';
	$pl = strlen($prefix);
	foreach($existpages as $p){
		if(strpos($p, $prefix) === 0){
			$categories[] = substr($p, $pl);
		}
	}
	natcasesort($categories);
	
	$categorybutton = $_plugin_blog2_button_category;
	$supercategory = '';
	foreach($categories as $c){
		$l = strpos($c, '/');
		if($l === false){
			$l = strlen($c);
		}
		$sc = substr($c, 0, $l);
		if($sc != $supercategory){
			$categorybutton .= '<br />';
			$supercategory = $sc;
		}
		$categorybutton .= '<input type="button" value="' . $c
		                 . '" onclick="category.value += \'|' . $c . '\'" /> ';
	}
	
	
	//日付入力フォームの準備
	if(PLUGIN_BLOG2_SELECTDATE == false){
		$inputdate = '';
	}
	else{
		if($date == ''){
			$date = get_date('Y-m-d');
		}
		$inputdate = $_plugin_blog2_input_date . ': <input type="text" name="date" size="12" value="' . $date . '" /><br />';
	}
	
	
	//クッキーの準備
	if($password == ''){
		if(isset($_COOKIE['plugin_blog2'])){
			if(get_magic_quotes_gpc() == 1 || get_magic_quotes_runtime() == 1){
				$password = stripslashes($_COOKIE['plugin_blog2']);
			}
			else{
				$password = $_COOKIE['plugin_blog2'];
			}
		}
	}
	
	
	return <<<EOD
<form action="$script" method="post">
	<div>
		<input type="hidden" name="plugin" value="blog2" />
		$_plugin_blog2_input_continue <input type="text" name="continue" size="$subject_cols" value="$continue" /><br />
		<textarea name="message" cols="$blog_cols" rows="$blog_rows">$message</textarea><br />
		$inputdate
		$_plugin_blog2_input_subject: <input type="text" name="subject" size="$subject_cols" value="$subject" /><br />
		$_plugin_blog2_input_category: <input type="text" name="category" size="$cat_cols" value="$category" /><br />
		$_plugin_blog2_input_password: <input type="password" name="password" size="12" value="$password" /><br />
		<input type="submit" value="$_plugin_blog2_button_submit" /><br />
		<br />
		$categorybutton
	</div>
</form>
EOD;
}

?>