<?php
/**
 * blog2navi v1.0
 */

/*add below to <lang>.lng
///////////////////////////////////////
// blog2navi.inc.php
$_plugin_blog2navi_error_notblog2page = 'error: blog2で生成したページのみで有効です。';
$_plugin_blog2navi_mes_prev = '前へ';
$_plugin_blog2navi_mes_next = '次へ';
$_plugin_blog2navi_mes_home = '目次';
*/



/**
 * ブロック型プラグインの呼び出し用関数。
 */
function plugin_blog2navi_convert()
{
	global $vars, $script;
	global $_plugin_blog2navi_error_notblog2page;
	global $_plugin_blog2navi_mes_prev, $_plugin_blog2navi_mes_next, $_plugin_blog2navi_mes_home;
	
	$page = $vars['page'];
	$home = substr($page, 0, strpos($page, '/'));
	$datelist =& Blog2Navi_DateList::getinstance($home);
	$collist =& Blog2Navi_ColumnList::getinstance($datelist);
	if($datelist->isdatepage($page)){
		$prev = $datelist->getprev($page);
		$next = $datelist->getnext($page);
	}
	else if($collist->iscolumnpage($page)){
		$prev = $collist->getprev($page);
		$next = $collist->getnext($page);
	}
	else{
		return '<div class="blog2navi">' . $_plugin_blog2navi_error_notblog2page . "</div>\n";
	}
	
	$str[] = '<div class="blog2navi">';
	if($prev != null){
		$str[] = '[' . make_pagelink($prev, $_plugin_blog2navi_mes_prev) . ']';
	}
	else{
		$str[] = "[$_plugin_blog2navi_mes_prev]";
	}
	if($next != null){
		$str[] = '[' . make_pagelink($next, $_plugin_blog2navi_mes_next) . ']';
	}
	else{
		$str[] = "[$_plugin_blog2navi_mes_next]";
	}
	$str[] = '[' . make_pagelink($home, $_plugin_blog2navi_mes_home) . ']';
	$str[] = '</div>';
	return join("\n", $str);
}



class Blog2Navi_DateList
{
	var $date = array();
	var $home;
	
	
	function &getinstance($home)
	{
		static $ins = array();
		if(!isset($ins[$home])){
			$ins[$home] = new Blog2Navi_DateList($home);
		}
		return $ins[$home];
	}
	
	
	function Blog2Navi_DateList($home)
	{
		$this->home = $home;
		
		$pattern = '|^' . preg_quote($home, '/') . '/\d{4}-\d{2}-\d{2}$|';
		$existpages = get_existpages();
		foreach($existpages as $p){
			if(preg_match($pattern, $p)){
				$this->date[] = $p;
			}
		}
		sort($this->date);
	}
	
	
	function isdatepage($str)
	{
		return in_array($str, $this->date);
	}
	
	
	function getprev($datepage)
	{
		$p = array_search($datepage, $this->date);
		if($p === false){
			return false;
		}
		
		if($p != 0){
			return $this->date[$p-1];
		}
		else{
			return null;
		}
	}
	
	
	function getnext($datepage)
	{
		$p = array_search($datepage, $this->date);
		if($p === false){
			return false;
		}
		
		if($p != count($this->date)-1){
			return $this->date[$p+1];
		}
		else{
			return null;
		}
	}
	
	
	function getlast()
	{
		if($this->date == array()){
			return null;
		}
		return $this->date[count($this->date)-1];
	}
	
	
	function gethome()
	{
		return $this->home;
	}
}



class Blog2Navi_ColumnList
{
	var $datelist;
	var $date_col = array();
	var $col_date = array();
	
	var $pattern;
	
	
	function &getinstance(&$datelist)
	{
		static $ins = array();
		if(!isset($ins[$datelist->gethome()])){
			$ins[$datelist->gethome()] = new Blog2Navi_ColumnList($datelist);
		}
		return $ins[$datelist->gethome()];
	}
	
	
	function Blog2Navi_ColumnList(&$datelist)
	{
		$this->datelist =& $datelist;
		$this->pattern = '|^(' . preg_quote($datelist->gethome(), '|') . '/\d{4}-\d{2}-\d{2})/.+$|';
	}
	
	
	function iscolumnpage($str)
	{
		if(!preg_match($this->pattern, $str, $m) || !$this->datelist->isdatepage($m[1])){
			return false;
		}
		
		if(!isset($this->date_col[$m[1]])){
			$this->read($m[1]);
		}
		return isset($this->col_date[$str]);
	}
	
	
	function read($datepage)
	{
		$source = get_source($datepage);
		$this->date_col[$datepage] = array();
		foreach($source as $s){
			if(substr($s, 0, 3) == '//-'){
				preg_match('/\[\[.*>(.*)\]\]/', $s, $m);
				$this->date_col[$datepage][] = $m[1];
				$this->col_date[$m[1]] = $datepage;
			}
		}
		$this->date_col[$datepage] = array_reverse($this->date_col[$datepage]);
	}
	
	
	function getprev($columnpage)
	{
		if(!$this->iscolumnpage($columnpage)){
			return false;
		}
		
		$date = $this->col_date[$columnpage];
		$p = array_search($columnpage, $this->date_col[$date]);
		if($p != 0){
			return $this->date_col[$date][$p-1];
		}
		else{
			$date = $this->datelist->getprev($date);
			if($date == null){
				return null;
			}
			if(!isset($this->date_col[$date])){
				$this->read($date);
			}
			return $this->date_col[$date][count($this->date_col[$date])-1];
		}
	}
	
	
	function getnext($columnpage)
	{
		if(!$this->iscolumnpage($columnpage)){
			return false;
		}
		
		$date = $this->col_date[$columnpage];
		$p = array_search($columnpage, $this->date_col[$date]);
		if($p != count($this->date_col[$date])-1){
			return $this->date_col[$date][$p+1];
		}
		else{
			$date = $this->datelist->getnext($date);
			if($date == null){
				return null;
			}
			if(!isset($this->date_col[$date])){
				$this->read($date);
			}
			return $this->date_col[$date][0];
		}
	}
	
	
	function getlast()
	{
		$date = $this->datelist->getlast();
		if($date == null){
			return null;
		}
		
		if(!isset($this->date_col[$date])){
			$this->read($date);
		}
		return $this->date_col[$date][count($this->date_col[$date])-1];
	}
	
	
	function getlist($datepage)
	{
		if(!$this->datelist->isdatepage($datepage)){
			return false;
		}
		
		if(!isset($this->date_col[$datepage])){
			$this->read($datepage);
		}
		return $this->date_col[$datepage];
	}
}
?>