/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.util;

import org.postgresforest.constant.ConstStr;

import net.jcip.annotations.*;

/**
 * PostgreSQLへの接続URL・ID/PASSを保持するクラス
 */
@Immutable
public class PgUrl {
    private final String ipport;
    private final String url;
    private final String dbname;
    
    /**
     * PgUrlクラスのコンストラクタ<br>
     * 基本的にこのコンストラクタでは引数値のチェックは行っていない
     * @param ipport
     * @param dbname
     */
    public PgUrl(final String ipport, final String dbname) {
        this.ipport = ipport;
        this.dbname = dbname;
        this.url = ConstStr.PG_URL_PREFIX.toString() + ipport + "/" + dbname;
    }
    
    /** このインスタンスが保持しているIP:PORT/DB名に接続するための接続文字列を返却する */
    public String getUrl() {
        return url;
    }
    
    /** このインスタンスが保持しているIP:PORTのみの部分文字列を返却する */
    public String getIpPort() {
        return ipport;
    }
    
    /** このインスタンスが保持しているDB名のみの文字列を返却する */
    public String getDbname() {
        return dbname;
    }
    
}
