/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.util;

import java.util.concurrent.*;
import java.util.concurrent.atomic.*;

public final class ForestThreadFactory implements ThreadFactory {
    
    private final String threadNamePrefix;
    
    private final AtomicInteger created = new AtomicInteger();
    
    public ForestThreadFactory(final ForestUrl forestUrl, final String suffix) {
        
        final StringBuilder sb = new StringBuilder();
        sb.append("ForestJDBC-[");
        sb.append(forestUrl.toString());
        sb.append("]-");
        sb.append(suffix);
        sb.append("-");
        threadNamePrefix = sb.toString();
    }
    
    public Thread newThread(Runnable runnable) {
        final int threadNumber = created.getAndIncrement();
        final String threadName = threadNamePrefix + threadNumber;
        final Thread retThread = new Thread(runnable, threadName);
        retThread.setDaemon(true);
        return retThread;
    }
}
