/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.util;

import java.util.List;
import java.util.Map;

import org.postgresforest.constant.UdbValidity;
import org.postgresforest.exception.ForestResourceDisposedException;
import org.postgresforest.mng.MngInfo;

public interface ForestJdbcInfo {
    
    /**
     * 呼び出した時点でのユーザデーターべースの整合性情報を集約し、
     * サーバIDをインデックスとしたリスト形式で返却する関数。
     * @return サーバIDをインデックスとした現在のユーザDBの状態を表すリスト
     * @throws ForestResourceDisposedException このコネクションが既に閉じられている場合
     */
    public List<UdbValidity> getValidityList() throws ForestResourceDisposedException;
    
    /**
     * Forest全体の動作を決定するコンフィグレーションのスナップショットを返す関数
     * @return 現在のグローバルコンフィグレーション
     * @throws ForestResourceDisposedException このコネクションが既に閉じられている場合
     */
    public MngInfo.GlobalConfig getForestGlobalConfig() throws ForestResourceDisposedException;
    
    /**
     * Forestの各コネクション単位での動作を決定するコンフィグレーションのスナップショットを返す関数
     * @return コンフィグレーションのIDをキーとした、コネクションごとのコンフィグレーションのマップ
     * @throws ForestResourceDisposedException このコネクションが既に閉じられている場合
     */
    public Map<String, MngInfo.LocalConfig> getConnectionConfigMap() throws ForestResourceDisposedException;
    
    // カレントコネクション数
    // 現在の管理情報参照数
    // 管理情報インスタンスの継続時刻
}
