/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.constant;

import java.util.IllegalFormatException;

public enum LogStr {
    
    // SEVERE
    // 両管理DBへのコネクション生成に失敗した
    SEVERE_MNGINFO_SUPPLYCON_BOTHFAIL("Can't create any connection to Forest management database"),
    // 管理情報を読み込む際、両系共情報読み出し・情報検証に何らかの問題が発生した
    SEVERE_MNGINFO_READDB_BOTHFAIL("Can't read any management information from database."),
    // 問題が発生したため縮退した serverid = 
    SEVERE_BROKEN_SERVER("A fatal error occured. The access to this server is restrained. serverid = %d"),
    // 管理情報定期更新タスクが何らかの問題で失敗
    SEVERE_MNGINFO_REFRESH_FAIL("Can't reload Forest management information from database."),
    // 管理DBへのコネクション生成で致命的なエラーが発生した serverid = 
    SEVERE_MNGINFO_SUPPLYCON_ERROR("A fatal error occured in creating connection to Forest management database. serverid = %d"),
    // 管理DBからの管理情報読み出し・情報検証中に致命的なエラーが発生した serverid = 
    SEVERE_MNGINFO_READDB_ERROR("A fatal error occured in reading management information from database. serverid = %d"),
    // 管理情報のステータスが変更された
    SEVERE_MNGINFO_STATUS_CHANGED("Forest udb_validity status changed. %s -> %s"),
    // 管理情報読み込みスレッドの異常終了（スレッド内で想定外のエラーが起きたため）
    SEVERE_MNGINFO_REFRESH_THREAD_UBNORMAL_STOP("Management information refresh thread ubnormally finished because of unknown error"),
    
    // WARNING
    // 制限時間内に管理DBへのコネクション生成が完了しなかった serverid = 
    WARN_MNGINFO_SUPPLYCON_CANCEL("Can't create connection to Forest management database. (timeout) serverid = %d"),
    // 管理DBへのコネクション生成で何らかの問題が発生した serverid = 
    WARN_MNGINFO_SUPPLYCON_EXCEPTION("Can't create connection to Forest management database. (an exception occured) serverid = %d"),
    // 管理DBからの情報読み出しが制限時間内に完了しなかった serverid = 
    WARN_MNGINFO_READDB_CANCEL("Can't read management information from database. (timeout) serverid = %d"),
    // 管理DBからの情報読み出し・情報検証時に何らかの問題が発生した serverid = 
    WARN_MNGINFO_READDB_EXCEPTION("Can't read management information from database. (an exception occured) serverid = %d"),
    // 管理DBのステータス遷移が異常だったため無視している
    WARN_MNGINFO_ILLEGAL_STATE_CHANGE("An abnormal status change occurred. Ignore new status and use previous status. Previous status (on memory) : %s, Ignore status (on ManagementDB) : %s"),
    // 管理情報定期更新タスク内でOutOfMemoryが発生した
    INFO_MNGINFO_REFRESH_OUTOFMEMORY("Out of memory occured when update management information."),
    
    // INFO
    // 管理情報の初期化成功
    INFO_MNGINFO_INIT_SUCCESS("Management information was initialized Successfully."),
    // 管理情報定期更新スレッドの開始
    INFO_MNGINFO_REFRESH_THREAD_START("Management information refresh task started."),
    // 管理情報定期更新スレッドの正常終了
    INFO_MNGINFO_REFRESH_THREAD_STOP("Management information refresh thread finished."),
    // 管理情報定期更新開始
    INFO_MNGINFO_REFRESH_TASK_START("Management information refresh task started."),
    // 管理情報定期更新正常終了 現在のステータス: 
    INFO_MNGINFO_REFRESH_TASK_END("Management information refresh task finished. Current Status : %s"),
    // 管理情報定期更新タスクで管理情報の更新を試みたが、他スレッドでの管理情報更新タイミングと競合が発生した
    INFO_MNGINFO_REFRESH_CONFLICT("Can't update management information. (update conflicted) Retry update information.");
    
    private final String value;
    
    private LogStr(final String value) {
        this.value = value;
    }
    
    public String toString() {
        return value;
    }
    
    public String toString(Object... args) {
        try {
            return String.format(value, args);
        } catch (IllegalFormatException e) {
            // Forestで用意しているログ文字列と、それを使う箇所での引数の与え方が異常な場合に
            // ここに至るため、何らかの例外を上げる必要があるが、ログ出力用関数の異常使用で
            // Forestを止めるわけにはいかないので、とりあえずそれとわかる形で出力する
            final StringBuilder sb = new StringBuilder();
            sb.append(value);
            for (final Object obj : args) {
                sb.append(", ");
                sb.append(obj.toString());
            }
            return sb.toString();
        }
    }
}
