/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.constant;

public enum ErrorStr {
    
    // メソッドのサポート
    // このAPIはまだ実装していない
    NOT_IMPLEMENTED("This API is not implemented yet."),
    // このAPIはサポートしない（一部を除き現在JDBC1のAPIのみサポートしている）
    NOT_SUPPORTED("This API is not supported."),
    
    // 接続文字列に関する問題
    // JDBCの接続文字列が jdbc:postgresforest://IP1:PORT1,IP2:PORT2/DB[?OPT1=VAL1[;OPT2=VAL2]...] の形になっていない
    INVALID_FORESTURL("Invalid JDBC URL is appointed.(required form is 'jdbc:postgresforest://IP1:PORT1,IP2:PORT2/DB[?OPT1=VAL1[;OPT2=VAL2]...]')"),
    // IPアドレスに無効な文字列が含まれている
    INVALID_IPADDR("An IP address is invalid."),
    // PORT番号に無効な文字列が含まれてい
    INVALID_PORT("A port number is invalid."),
    // DB名に無効な文字列が含まれている
    INVALID_DBNAME("DB name is invalid."),
    // OPTIONの形式が無効
    INVALID_OPTION("Option is invalid."),
    // 同じIP:PORTが指定されている
    SAME_ADDRESS("Can't set same addresses."),
    
    // 管理情報ロード時のエラー
    // 両系の管理情報データベースにコネクションを作成できなかった
    MNGDB_CONNECT_FAILED("Can't create any connection to Forest management database."),
    // 両系の管理情報データベースから情報を取得できなかった
    MNGDB_READ_FAILED("Can't get any information from Forest management database."),
    
    // 管理情報初回ロード時のエラー
    // 管理情報データベースへの初回アクセス時、両系共にコネクションを生成できなかった
    MNGINIT_CONNECT_FAILED("Can't create any connection to Forest management database. (When management database is initialized.)"),
    // 管理情報データベースへの初回アクセス時、両系共に管理情報を取得できなかった
    MNGINIT_LOAD_INFO_FAILED("Can't get any information from Forest management database. (When management database is initialized.)"),
    // 両系の管理情報データベースから取得した情報を合成する際にserver_infoに差異がある
    MNGINIT_SYNTH_INFO_FAILED("Can't synthesis server_info. server_info tables are not same."),
    //指定した接続文字列と管理情報データベースから取得した接続先が異なる
    MNGINIT_URL_DIFFERENT("JDBC connection url and udb_url (server_info table) are not same."),
    // 管理情報の初期化最中にスレッドへのインタラプションが発生した
    MNGINIT_INTERRUPT("Failed to initialize management information. (An interrupt occured.)"),
    
    // 管理情報生成時のエラー
    // 管理情報データベース:server_info:serveridの値が異常
    MNGDB_SERVERID_INVALID("Table 'server_info' (column 'serverid') is invalid."),
    // 管理情報データベース:server_info:udb_urlが異常
    MNGDB_UDBURL_INVALID("Table 'server_info' (column 'udb_url') is invalid."),
    // 管理情報データベース:server_info:udb_validityの値が異常
    MNGDB_UDBVALIDITY_INVALID("Table 'server_info' (column 'udb_validity') is invalid."),
    // 管理情報データベース:global_configにデータが存在しない
    MNGDB_GCONFIG_INVALID("Table 'global_config' is empty."),
    // 管理情報データベース:local_configに指定されたconfigidのコンフィグレーションが存在しない
    MNGDB_LOCALCONFIG_NOTFOUND("local_config configuration does not exist."),
    
    // 既にこのコネクションは、closeが呼ばれたか、回復不能なエラーによって閉じられている
    CONNECTION_CLOSED("Connection is already closed. ('close' api was called or an error occured.)"),
    // このJDBCオブジェクトは既に使用できない
    RESOURCE_CLOSED("Connection is already closed. ('close' api was called or an error occured.)"),
    // スレッドに割り込みが発生したため、操作に失敗した
    THREAD_INTERRUPTED("Failed to execute api. (an interrupt occured.)"),
    
    
    // プログラムの異常
    // 本来入るはずのない引数を指定されている（プログラムのミス）
    ILLEGAL_ARGUMENT("Illegal argument. (maybe it's a bug...)"),
    // 本来発生するはずがない例外を取得している（プログラムでのチェックミス）
    ILLEGAL_EXCEPTION("Illegal exception occured. (maybe it's a bug...)"),
    // 本来到達するはずがない箇所に到達している（プログラムのロジックミス）
    ILLEGAL_STATEMENT("Illegal statement. (maybe it's a bug...)"),
    
    // 管理DBのServerInfoテーブルのレコード数が異常
    MNGDB_SERVERINFO_ILLEGALRECORD("server_info table must have 2 record."),
    
    // PGからのエラー
    NOEFFECTIVE_RESULT("Could not receive an effective result from PostgreSQL."),
    
    // その他のエラー
    // InputStreamの複製のために読み込み最中にIOExceptionが発生した
    STREAM_DUPLICATE_FAILED("IOException occured while duplicate InputStream."),
    // 更新可能なcurcorは利用できない
    NOT_SUPPORTED_UPDATEABLE_CURSOR("Updatable cursor is not supported."), 
    // fetchされる前にresultが参照された
    CALLED_BEFORE_FETCH("Could not be call before fetching a result.");
    
    private final String value;
    
    private ErrorStr(final String value) {
        this.value = value;
    }
    
    public String toString() {
        return value;
    }
}
