/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.constant;

public enum ConstStr {
    
    // ドライバ名関係
    DRIVER_NAME("PostgresForest Driver"),
    DRIVER_VERSION("PostgresForest 5.1.0"),
    
    // 接続文字列関係
    PG_URL_PREFIX("jdbc:postgresql://"),
    FOREST_URL_PREFIX("jdbc:postgresforest://"),
    FOREST_URL_CONFIGID("configid"),
    FOREST_URL_DEFAULT_CONFIGID("DEFAULT"),
    // 管理情報のデータベース名
    MNGDB_SUFFIX("_pghainfo"),
    // 管理情報のテーブル名
    MNGDB_TBL_SERVERINFO("server_info"),
    MNGDB_TBL_GLOBALCONFIG("global_config"),
    MNGDB_TBL_LOCALCONFIG("local_config"),
    MNGDB_TBL_BROKENLOG("broken_log_detail"),
    // 管理情報テーブル内のカラム名
    MNGDB_COL_SERVERINFO_ID("serverid"),
    MNGDB_COL_SERVERINFO_UDBURL("udb_url"),
    MNGDB_COL_SERVERINFO_VALID("udb_validity"),
    MNGDB_COL_GCONF_KEY("key"),
    MNGDB_COL_GCONF_VALUE("value"),
    MNGDB_COL_LCONF_CONFIGID("configid"),
    MNGDB_COL_LCONF_KEY("key"),
    MNGDB_COL_LCONF_VALUE("value"),
    MNGDB_COL_BROKENLOG_SERVERID("serverid"),
    MNGDB_COL_BROKENLOG_TIME("time"),
    MNGDB_COL_BROKENLOG_CLIENT("client"),
    MNGDB_COL_BROKENLOG_APITASK("api_task"),
    MNGDB_COL_BROKENLOG_ERRMSG("err_msg"),
    MNGDB_COL_BROKENLOG_ERRTYPE("err_type"),
    MNGDB_COL_BROKENLOG_ERRSTATE("err_state"),
    MNGDB_COL_BROKENLOG_ERRQUERY("err_query"),
    MNGDB_COL_BROKENLOG_ERRSTACK("err_stack"),
    MNGDB_COL_BROKENLOG_APPTHREAD("app_thread"),
    MNGDB_COL_BROKENLOG_APPSTACK("app_stack"),
    // GlobalConfigテーブルのキー
    MNGDB_KEY_GCONF_MNGREADDURATION("mngdb_read_duration"),
    MNGDB_KEY_GCONF_MNGCONCREATETO("mngcon_create_timeout"),
    MNGDB_KEY_GCONF_MNGQUERYEXECTO("mngquery_exec_timeout"),
    MNGDB_KEY_GCONF_MNGMAXBURSTERROR("mngdb_max_burst_error"),
    MNGDB_KEY_GCONF_BROKENPREFIX("broken_error_prefix"),
    MNGDB_KEY_GCONF_LOGLEVEL("log_level"),
    MNGDB_KEY_GCONF_LOGFORMATTERNAME("log_formatter_name"),
    MNGDB_KEY_GCONF_LOGCONSOLEENABLE("log_console_enable"),
    MNGDB_KEY_GCONF_LOGFILEENABLE("log_file_enable"),
    MNGDB_KEY_GCONF_LOGFILENAME("log_file_name"),
    MNGDB_KEY_GCONF_LOGFILESIZE("log_file_size_mb"),
    MNGDB_KEY_GCONF_LOGFILEROTATE("log_file_rotate_count"),
    // localConfigテーブルのキー
    MNGDB_KEY_LCONF_APIEXECTO("api_exec_timeout"),
    MNGDB_KEY_LCONF_FASTAPIRETURN("fast_api_return_on_db_fail"),
    // GlobalConfigテーブルのデフォルト値
    MNGDB_DEF_GCONF_BROKENPREFIX("08,53,57P,3D"),
    MNGDB_DEF_GCONF_LOGFILENAME("/var/log/forest/forest.log.%u-%g"),
    ;
    
    private final String value;
    
    private ConstStr(final String value) {
        this.value = value;
    }
    
    public String toString() {
        return value;
    }
    
}
