/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.constant;

public enum ConstInt {
    
    // 管理情報初回読み込み時設定
    MNGINIT_CONNECT_TIMEOUT(10),
    MNGINIT_QUERYEXEC_TIMEOUT(10),
    
    // global_configテーブルのデフォルト値
    MNGDB_DEF_GCONF_READDURATION(30),
    MNGDB_DEF_GCONF_MNGCONCREATETO(10),
    MNGDB_DEF_GCONF_MNGQUERYEXECTO(10),
    MNGDB_DEF_GCONF_MNGMAXBURSTERROR(2),
    MNGDB_DEF_GCONF_LOGLEVEL(2), // ( = Level.WARNING )
    MNGDB_DEF_GCONF_LOGCONSOLEENABLE(1),
    MNGDB_DEF_GCONF_LOGFILEENABLE(0),
    MNGDB_DEF_GCONF_LOGFILESIZE(0),
    MNGDB_DEF_GCONF_LOGFILEROTATE(1),
    MNGDB_DEF_LCONF_APIEXECTO(600),
    MNGDB_DEF_LCONF_FASTAPIRETURN(1);
    
    
    private final int value;
    
    private ConstInt(final int value) {
        this.value = value;
    }
    
    public int getInt() {
        return value;
    }
    
    public boolean getBool() {
        if (value < 0 || 1 < value) { 
            throw new IllegalStateException();
        }
        return (value == 1);
    }
}
