/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.apibase;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.*;
import java.util.Calendar;
import java.util.Map;

import org.postgresforest.exception.ForestTaskNotExecutedException;
import org.postgresforest.util.ForestTask;

public final class ResultSetTask {
    
    public static final class Absolute_Int extends ForestTask<Boolean>{
        private final ResultSet res;
        private final int row;
        public Absolute_Int(final int serverid, final ResultSet res, int row) {
            super(serverid);
            this.res = res;
            this.row = row;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.absolute(row));
        }
    }
    
    public static final class AfterLast extends ForestTask<Void>{
        private final ResultSet res;
        public AfterLast(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Void call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            res.afterLast();
            return null;
        }
    }
    
    public static final class BeforeFirst extends ForestTask<Void>{
        private final ResultSet res;
        public BeforeFirst(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Void call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            res.beforeFirst();
            return null;
        }
    }
    
    public static final class First extends ForestTask<Boolean>{
        private final ResultSet res;
        public First(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.first());
        }
    }
    
    public static final class GetArray_Int extends ForestTask<Array> {
        private final ResultSet res;
        private final int columnIndex;
        public GetArray_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Array call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getArray(columnIndex);
        }
    }
    
    public static final class GetArray_Str extends ForestTask<Array> {
        private final ResultSet res;
        private final String columnLabel;
        public GetArray_Str(final int serverid, final ResultSet res, String columnLabel) {
            super(serverid);
            this.res = res;
            this.columnLabel = columnLabel;
        }
        public Array call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getArray(columnLabel);
        }
    }
    
    public static final class GetString_Str extends ForestTask<String> {
        private final ResultSet res;
        private final String columnName;
        public GetString_Str(final int serverid, final ResultSet res, String columnName) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getString(columnName);
        }
    }
    
    public static final class GetString_Int extends ForestTask<String> {
        private final ResultSet res;
        private final int columnIndex;
        public GetString_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getString(columnIndex);
        }
    }
    
    public static final class GetInt_Str extends ForestTask<Integer> {
        private final ResultSet res;
        private final String columnName;
        public GetInt_Str(final int serverid, final ResultSet res, String columnName) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getInt(columnName));
        }
    }
    
    public static final class GetInt_Int extends ForestTask<Integer> {
        private final ResultSet res;
        private final int columnIndex;
        public GetInt_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getInt(columnIndex));
        }
    }
    
    public static final class GetAsciiStream_Int extends ForestTask<InputStream> {
        private final ResultSet res;
        private final int arg0;
        public GetAsciiStream_Int(final int serverid, final ResultSet res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public InputStream call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getAsciiStream(arg0);
        }
    }
    
    public static final class GetAsciiStream_Str extends ForestTask<InputStream> {
        private final ResultSet res;
        private final String arg0;
        public GetAsciiStream_Str(final int serverid, final ResultSet res, String arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public InputStream call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getAsciiStream(arg0);
        }
    }
    
    public static final class GetBigDecimal_Int extends ForestTask<BigDecimal> {
        private final ResultSet res;
        private final int columnIndex;
        public GetBigDecimal_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public BigDecimal call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBigDecimal(columnIndex);
        }
    }
    
    public static final class GetBigDecimal_Str extends ForestTask<BigDecimal> {
        private final ResultSet res;
        private final String columnLabel;
        public GetBigDecimal_Str(final int serverid, final ResultSet res, String columnLabel) {
            super(serverid);
            this.res = res;
            this.columnLabel = columnLabel;
        }
        public BigDecimal call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBigDecimal(columnLabel);
        }
    }
    
    public static final class GetBigDecimal_IntInt extends ForestTask<BigDecimal> {
        private final ResultSet res;
        private final int arg0;
        private final int arg1;
        public GetBigDecimal_IntInt(final int serverid, final ResultSet res, int arg0, int arg1) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        @SuppressWarnings("deprecation")
        public BigDecimal call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBigDecimal(arg0, arg1);
        }
    }
    
    public static final class GetBigDecimal_StrInt extends ForestTask<BigDecimal> {
        private final ResultSet res;
        private final String arg0;
        private final int arg1;
        public GetBigDecimal_StrInt(final int serverid, final ResultSet res, String arg0, int arg1) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        @SuppressWarnings("deprecation")
        public BigDecimal call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBigDecimal(arg0, arg1);
        }
    }
    
    public static final class GetBinaryStream_Int extends ForestTask<InputStream> {
        private final ResultSet res;
        private final int arg0;
        public GetBinaryStream_Int(final int serverid, final ResultSet res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public InputStream call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBinaryStream(arg0);
        }
    }
    
    public static final class GetBinaryStream_Str extends ForestTask<InputStream> {
        private final ResultSet res;
        private final String arg0;
        public GetBinaryStream_Str(final int serverid, final ResultSet res, String arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public InputStream call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBinaryStream(arg0);
        }
    }
    
    public static final class GetBlob_Int extends ForestTask<Blob> {
        private final ResultSet res;
        private final int columnIndex;
        public GetBlob_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Blob call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBlob(columnIndex);
        }
    }
    
    public static final class GetBlob_Str extends ForestTask<Blob> {
        private final ResultSet res;
        private final String columnLabel;
        public GetBlob_Str(final int serverid, final ResultSet res, String columnLabel) {
            super(serverid);
            this.res = res;
            this.columnLabel = columnLabel;
        }
        public Blob call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBlob(columnLabel);
        }
    }
    
    public static final class GetBoolean_Int extends ForestTask<Boolean> {
        private final ResultSet res;
        private final int columnIndex;
        public GetBoolean_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.getBoolean(columnIndex));
        }
    }
    
    public static final class GetBoolean_Str extends ForestTask<Boolean> {
        private final ResultSet res;
        private final String columnName;
        public GetBoolean_Str(final int serverid, final ResultSet res, String columnName) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.getBoolean(columnName));
        }
    }
    
    public static final class GetByte_Int extends ForestTask<Byte> {
        private final ResultSet res;
        private final int columnIndex;
        public GetByte_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Byte call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Byte.valueOf(res.getByte(columnIndex));
        }
    }
    
    public static final class GetByte_Str extends ForestTask<Byte> {
        private final ResultSet res;
        private final String columnName;
        public GetByte_Str(final int serverid, final ResultSet res, String columnName) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
        }
        public Byte call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Byte.valueOf(res.getByte(columnName));
        }
    }
    
    public static final class GetBytes_Int extends ForestTask<byte[]> {
        private final ResultSet res;
        private final int columnIndex;
        public GetBytes_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public byte[] call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBytes(columnIndex);
        }
    }
    
    public static final class GetBytes_Str extends ForestTask<byte[]> {
        private final ResultSet res;
        private final String columnName;
        public GetBytes_Str(final int serverid, final ResultSet res, String columnName) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
        }
        public byte[] call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBytes(columnName);
        }
    }
    
    public static final class GetCharacterStream_Int extends ForestTask<Reader> {
        private final ResultSet res;
        private final int columnIndex;
        public GetCharacterStream_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Reader call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getCharacterStream(columnIndex);
        }
    }
    
    public static final class GetCharacterStream_Str extends ForestTask<Reader> {
        private final ResultSet res;
        private final String columnLabel;
        public GetCharacterStream_Str(final int serverid, final ResultSet res, String columnLabel) {
            super(serverid);
            this.res = res;
            this.columnLabel = columnLabel;
        }
        public Reader call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getCharacterStream(columnLabel);
        }
    }
    
    public static final class GetClob_Int extends ForestTask<Clob> {
        private final ResultSet res;
        private final int columnIndex;
        public GetClob_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Clob call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getClob(columnIndex);
        }
    }
    
    public static final class GetClob_Str extends ForestTask<Clob> {
        private final ResultSet res;
        private final String columnLabel;
        public GetClob_Str(final int serverid, final ResultSet res, String columnLabel) {
            super(serverid);
            this.res = res;
            this.columnLabel = columnLabel;
        }
        public Clob call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getClob(columnLabel);
        }
    }
    
    public static final class GetDate_Int extends ForestTask<Date> {
        private final ResultSet res;
        private final int columnIndex;
        public GetDate_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Date call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getDate(columnIndex);
        }
    }
    
    public static final class GetDate_Str extends ForestTask<Date> {
        private final ResultSet res;
        private final String columnName;
        public GetDate_Str(final int serverid, final ResultSet res, String columnName) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
        }
        public Date call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getDate(columnName);
        }
    }
    
    public static final class GetDate_IntCal extends ForestTask<Date> {
        private final ResultSet res;
        private final int columnIndex;
        private final Calendar cal;
        public GetDate_IntCal(final int serverid, final ResultSet res, int columnIndex, Calendar cal) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
            this.cal = cal;
        }
        public Date call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getDate(columnIndex, cal);
        }
    }
    
    public static final class GetDate_StrCal extends ForestTask<Date> {
        private final ResultSet res;
        private final String columnName;
        private final Calendar cal;
        public GetDate_StrCal(final int serverid, final ResultSet res, String columnName, Calendar cal) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
            this.cal = cal;
        }
        public Date call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getDate(columnName, cal);
        }
    }
    
    public static final class GetDouble_Int extends ForestTask<Double> {
        private final ResultSet res;
        private final int columnIndex;
        public GetDouble_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Double call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Double.valueOf(res.getDouble(columnIndex));
        }
    }
    
    public static final class GetDouble_Str extends ForestTask<Double> {
        private final ResultSet res;
        private final String columnName;
        public GetDouble_Str(final int serverid, final ResultSet res, String columnName) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
        }
        public Double call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Double.valueOf(res.getDouble(columnName));
        }
    }
    
    public static final class GetFetchDirection extends ForestTask<Integer> {
        private final ResultSet res;
        public GetFetchDirection(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getFetchDirection());
        }
    }
    
    public static final class GetFetchSize extends ForestTask<Integer> {
        private final ResultSet res;
        public GetFetchSize(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getFetchSize());
        }
    }
    
    public static final class GetFloat_Int extends ForestTask<Float> {
        private final ResultSet res;
        private final int columnIndex;
        public GetFloat_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Float call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Float.valueOf(res.getFloat(columnIndex));
        }
    }
    
    public static final class GetFloat_Str extends ForestTask<Float> {
        private final ResultSet res;
        private final String columnName;
        public GetFloat_Str(final int serverid, final ResultSet res, String columnName) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
        }
        public Float call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Float.valueOf(res.getFloat(columnName));
        }
    }
    
    public static final class GetLong_Int extends ForestTask<Long> {
        private final ResultSet res;
        private final int columnIndex;
        public GetLong_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Long call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Long.valueOf(res.getLong(columnIndex));
        }
    }
    
    public static final class GetLong_Str extends ForestTask<Long> {
        private final ResultSet res;
        private final String columnName;
        public GetLong_Str(final int serverid, final ResultSet res, String columnName) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
        }
        public Long call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Long.valueOf(res.getLong(columnName));
        }
    }
    
    public static final class GetMetaData extends ForestTask<ResultSetMetaData> {
        private final ResultSet res;
        public GetMetaData(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public ResultSetMetaData call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getMetaData();
        }
    }
    
    public static final class GetObject_Int extends ForestTask<Object> {
        private final ResultSet res;
        private final int columnIndex;
        public GetObject_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Object call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getObject(columnIndex);
        }
    }
    
    public static final class GetObject_Str extends ForestTask<Object> {
        private final ResultSet res;
        private final String columnName;
        public GetObject_Str(final int serverid, final ResultSet res, String columnName) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
        }
        public Object call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getObject(columnName);
        }
    }
    
    public static final class GetObject_IntMap extends ForestTask<Object> {
        private final ResultSet res;
        private final int columnIndex;
        private final Map<String, Class<?>> map;
        public GetObject_IntMap(final int serverid, final ResultSet res, int columnIndex, Map<String, Class<?>> map) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
            this.map = map;
        }
        public Object call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getObject(columnIndex, map);
        }
    }
    
    public static final class GetObject_StrMap extends ForestTask<Object> {
        private final ResultSet res;
        private final String columnLabel;
        private final Map<String, Class<?>> map;
        public GetObject_StrMap(final int serverid, final ResultSet res, String columnLabel, Map<String, Class<?>> map) {
            super(serverid);
            this.res = res;
            this.columnLabel = columnLabel;
            this.map = map;
        }
        public Object call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getObject(columnLabel, map);
        }
    }
    
    public static final class GetRef_Int extends ForestTask<Ref> {
        private final ResultSet res;
        private final int columnIndex;
        public GetRef_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Ref call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getRef(columnIndex);
        }
    }
    
    public static final class GetRef_Str extends ForestTask<Ref> {
        private final ResultSet res;
        private final String columnLabel;
        public GetRef_Str(final int serverid, final ResultSet res, String columnLabel) {
            super(serverid);
            this.res = res;
            this.columnLabel = columnLabel;
        }
        public Ref call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getRef(columnLabel);
        }
    }
    
    public static final class GetRow extends ForestTask<Integer> {
        private final ResultSet res;
        public GetRow(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getRow();
        }
    }
    
    public static final class GetShort_Int extends ForestTask<Short> {
        private final ResultSet res;
        private final int columnIndex;
        public GetShort_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Short call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Short.valueOf(res.getShort(columnIndex));
        }
    }
    
    public static final class GetShort_Str extends ForestTask<Short> {
        private final ResultSet res;
        private final String columnName;
        public GetShort_Str(final int serverid, final ResultSet res, String columnName) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
        }
        public Short call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Short.valueOf(res.getShort(columnName));
        }
    }
    
    public static final class GetTime_Int extends ForestTask<Time> {
        private final ResultSet res;
        private final int columnIndex;
        public GetTime_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Time call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getTime(columnIndex);
        }
    }
    
    public static final class GetTime_Str extends ForestTask<Time> {
        private final ResultSet res;
        private final String columnName;
        public GetTime_Str(final int serverid, final ResultSet res, String columnName) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
        }
        public Time call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getTime(columnName);
        }
    }
    
    public static final class GetTime_IntCal extends ForestTask<Time> {
        private final ResultSet res;
        private final int columnIndex;
        private final Calendar cal;
        public GetTime_IntCal(final int serverid, final ResultSet res, int columnIndex, Calendar cal) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
            this.cal = cal;
        }
        public Time call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getTime(columnIndex, cal);
        }
    }
    
    public static final class GetTime_StrCal extends ForestTask<Time> {
        private final ResultSet res;
        private final String columnLabel;
        private final Calendar cal;
        public GetTime_StrCal(final int serverid, final ResultSet res, String columnLabel, Calendar cal) {
            super(serverid);
            this.res = res;
            this.columnLabel = columnLabel;
            this.cal = cal;
        }
        public Time call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getTime(columnLabel, cal);
        }
    }
    
    public static final class GetTimestamp_Int extends ForestTask<Timestamp> {
        private final ResultSet res;
        private final int columnIndex;
        public GetTimestamp_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Timestamp call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getTimestamp(columnIndex);
        }
    }
    
    public static final class GetTimestamp_Str extends ForestTask<Timestamp> {
        private final ResultSet res;
        private final String columnName;
        public GetTimestamp_Str(final int serverid, final ResultSet res, String columnName) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
        }
        public Timestamp call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getTimestamp(columnName);
        }
    }
    
    public static final class GetTimestamp_IntCal extends ForestTask<Timestamp> {
        private final ResultSet res;
        private final int columnIndex;
        private final Calendar cal;
        public GetTimestamp_IntCal(final int serverid, final ResultSet res, int columnIndex, Calendar cal) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
            this.cal = cal;
        }
        public Timestamp call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getTimestamp(columnIndex, cal);
        }
    }
    
    public static final class GetTimestamp_StrCal extends ForestTask<Timestamp> {
        private final ResultSet res;
        private final String columnLabel;
        private final Calendar cal;
        public GetTimestamp_StrCal(final int serverid, final ResultSet res, String columnLabel, Calendar cal) {
            super(serverid);
            this.res = res;
            this.columnLabel= columnLabel;
            this.cal = cal;
        }
        public Timestamp call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getTimestamp(columnLabel, cal);
        }
    }
    
    public static final class GetType extends ForestTask<Integer> {
        private final ResultSet res;
        public GetType(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getType();
        }
    }
    
    public static final class GetUnicodeStream_Int extends ForestTask<InputStream> {
        private final ResultSet res;
        private final int columnIndex;
        public GetUnicodeStream_Int(final int serverid, final ResultSet res, int columnIndex) {
            super(serverid);
            this.res = res;
            this.columnIndex = columnIndex;
        }
        @SuppressWarnings("deprecation")
        public InputStream call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getUnicodeStream(columnIndex);
        }
    }
    
    public static final class GetUnicodeStream_Str extends ForestTask<InputStream> {
        private final ResultSet res;
        private final String columnName;
        public GetUnicodeStream_Str(final int serverid, final ResultSet res, String columnName) {
            super(serverid);
            this.res = res;
            this.columnName = columnName;
        }
        @SuppressWarnings("deprecation")
        public InputStream call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getUnicodeStream(columnName);
        }
    }
    
    
    public static final class Next extends ForestTask<Boolean> {
        private final ResultSet res;
        public Next(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.next());
        }
        
    }
    
    public static final class ClearWarning extends ForestTask<Void> {
        private final ResultSet res;
        public ClearWarning(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Void call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            res.clearWarnings();
            return null;
        }
        
    }
    
    public static final class Close extends ForestTask<Void> {
        private final ResultSet res;
        public Close(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Void call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            res.close();
            return null;
        }
        
    }
    
    public static final class FindColumn extends ForestTask<Integer> {
        private final ResultSet res;
        private final String arg0;
        public FindColumn(final int serverid, final ResultSet res, String arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.findColumn(arg0));
        }
    }
    
    public static final class GetCursorName extends ForestTask<String> {
        private final ResultSet res;
        public GetCursorName(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getCursorName();
        }
    }
    
    public static final class GetWarnings extends ForestTask<SQLWarning> {
        private final ResultSet res;
        public GetWarnings(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public SQLWarning call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getWarnings();
        }
    }
    
    public static final class WasNull extends ForestTask<Boolean> {
        private final ResultSet res;
        public WasNull(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.wasNull());
        }
    }
    
    public static final class IsAfterLast extends ForestTask<Boolean> {
        private final ResultSet res;
        public IsAfterLast(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isAfterLast());
        }
    }
    
    public static final class IsBeforeFirst extends ForestTask<Boolean> {
        private final ResultSet res;
        public IsBeforeFirst(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isBeforeFirst());
        }
    }
    
    public static final class IsFirst extends ForestTask<Boolean> {
        private final ResultSet res;
        public IsFirst(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isFirst());
        }
    }
    
    public static final class IsLast extends ForestTask<Boolean> {
        private final ResultSet res;
        public IsLast(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isLast());
        }
    }
    
    public static final class Last extends ForestTask<Boolean> {
        private final ResultSet res;
        public Last(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.last());
        }
    }
    
    public static final class Previous extends ForestTask<Boolean> {
        private final ResultSet res;
        public Previous(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.previous());
        }
    }
    
    public static final class RefreshRow extends ForestTask<Void> {
        private final ResultSet res;
        public RefreshRow(final int serverid, final ResultSet res) {
            super(serverid);
            this.res = res;
        }
        public Void call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            res.refreshRow();
            return null;
        }
    }
    
    public static final class Relative extends ForestTask<Boolean> {
        private final ResultSet res;
        private final int rows;
        public Relative(final int serverid, final ResultSet res, int rows) {
            super(serverid);
            this.res = res;
            this.rows = rows;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.relative(rows));
        }
    }
    
    public static final class SetFetchDirection extends ForestTask<Void> {
        private final ResultSet res;
        private final int direction;
        public SetFetchDirection(final int serverid, final ResultSet res, int direction) {
            super(serverid);
            this.res = res;
            this.direction = direction;
        }
        public Void call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            res.setFetchDirection(direction);
            return null;
        }
    }
    
    public static final class SetFetchSize extends ForestTask<Void> {
        private final ResultSet res;
        private final int rows;
        public SetFetchSize(final int serverid, final ResultSet res, int rows) {
            super(serverid);
            this.res = res;
            this.rows = rows;
        }
        public Void call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            res.setFetchSize(rows);
            return null;
        }
    }
    
}
