/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.apibase;

import java.sql.ResultSetMetaData;

import org.postgresforest.exception.ForestTaskNotExecutedException;
import org.postgresforest.util.ForestTask;

/**
 * PostgreSQLのJDBCドライバに対してResultSetMetaDataクラスのAPIを実行するための
 * Callableタスクのインプリを集約したクラス。このクラス自体は、メンバや
 * メソッドを持たない（内部クラスを持つのみ）
 * 
 * 各タスクは、コンストラクタで与えられたJDBCリソースについて、nullか否かを
 * 必ずチェックする必要がある。nullの場合、その系は縮退していることを意味し、
 * call内で即座に「ForestTaskNotExecutedException」をスローする。
 */
public final class ResultSetMetaDataTask {
    
    public static final class GetCatalogName extends ForestTask<String> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetCatalogName(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getCatalogName(arg0);
        }
    }
    
    public static final class GetColumnCount extends ForestTask<Integer> {
        private final ResultSetMetaData res;
        public GetColumnCount(final int serverid, ResultSetMetaData res) {
            super(serverid);
            this.res = res;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getColumnCount());
        }
    }
    
    public static final class GetColumnDisplaySize extends ForestTask<Integer> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetColumnDisplaySize(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getColumnDisplaySize(arg0));
        }
    }
    
    public static final class GetColumnLabel extends ForestTask<String> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetColumnLabel(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getColumnLabel(arg0);
        }
    }
    
    public static final class GetColumnName extends ForestTask<String> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetColumnName(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getColumnName(arg0);
        }
    }
    
    public static final class GetColumnType extends ForestTask<Integer> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetColumnType(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getColumnType(arg0));
        }
    }
    
    public static final class GetColumnTypeName extends ForestTask<String> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetColumnTypeName(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getColumnTypeName(arg0);
        }
    }
    
    public static final class GetPrecision extends ForestTask<Integer> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetPrecision(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getPrecision(arg0));
        }
    }
    
    public static final class GetScale extends ForestTask<Integer> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetScale(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getScale(arg0));
        }
    }
    
    public static final class GetSchemaName extends ForestTask<String> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetSchemaName(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getSchemaName(arg0);
        }
    }
    
    public static final class GetTableName extends ForestTask<String> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetTableName(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getTableName(arg0);
        }
    }
    
    public static final class IsAutoIncrement extends ForestTask<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsAutoIncrement(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isAutoIncrement(arg0));
        }
    }
    
    public static final class IsCaseSensitive extends ForestTask<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsCaseSensitive(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isCaseSensitive(arg0));
        }
    }
    
    public static final class IsCurrency extends ForestTask<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsCurrency(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isCurrency(arg0));
        }
    }
    
    public static final class IsDefinitelyWritable extends ForestTask<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsDefinitelyWritable(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isDefinitelyWritable(arg0));
        }
    }
    
    public static final class IsNullable extends ForestTask<Integer> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsNullable(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.isNullable(arg0));
        }
    }
    
    public static final class IsReadOnly extends ForestTask<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsReadOnly(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isReadOnly(arg0));
        }
    }
    
    public static final class IsSearchable extends ForestTask<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsSearchable(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isSearchable(arg0));
        }
    }
    
    public static final class IsSigned extends ForestTask<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsSigned(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isSigned(arg0));
        }
    }
    
    public static final class IsWritable extends ForestTask<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsWritable(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isWritable(arg0));
        }
    }
    
    public static final class GetColumnClassName_Int extends ForestTask<String> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetColumnClassName_Int(final int serverid, ResultSetMetaData res, int arg0) {
            super(serverid);
            this.res = res;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getColumnClassName(arg0);
        }
    }
    
}
