/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.apibase;

import java.sql.Ref;

import org.postgresforest.exception.ForestTaskNotExecutedException;
import org.postgresforest.util.ForestTask;

/**
 * PostgreSQLのJDBCドライバに対してRefクラスのAPIを実行するための
 * Callableタスクのインプリを集約したクラス。このクラス自体は、メンバや
 * メソッドを持たない（内部クラスを持つのみ）
 * 
 * 各タスクは、コンストラクタで与えられたJDBCリソースについて、nullか否かを
 * 必ずチェックする必要がある。nullの場合、その系は縮退していることを意味し、
 * call内で即座に「ForestTaskNotExecutedException」をスローする。
 */
public class RefTask {
    
    public static final class GetBaseTypeName extends ForestTask<String> {
        private final Ref ref;
        public GetBaseTypeName(int serverid, Ref ref) {
            super(serverid);
            this.ref = ref;
        }
        public String call() throws Exception {
            if (ref == null) {
                throw new ForestTaskNotExecutedException();
            }
            return ref.getBaseTypeName();
        }
    }
    
}
