/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.apibase;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.*;
import java.util.Calendar;

import org.postgresforest.exception.ForestTaskNotExecutedException;
import org.postgresforest.util.ForestTask;

public final class PreparedStatementTask {
    
    public static final class AddBatch extends ForestTask<Void> {
        private final PreparedStatement pstmt;
        public AddBatch(final int serverid, final PreparedStatement stmt) {
            super(serverid);
            this.pstmt = stmt;
        }
        public Void call() throws Exception {
            if (pstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            pstmt.addBatch();
            return null;
        }
    }
    
    public static final class Execute extends ForestTask<Boolean> {
        private final PreparedStatement pstmt;
        public Execute(final int serverid, final PreparedStatement stmt) {
            super(serverid);
            this.pstmt = stmt;
        }
        public Boolean call() throws Exception {
            if (pstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(pstmt.execute());
        }
    }
    
    public static final class ExecuteUpdate extends ForestTask<Integer> {
        private final PreparedStatement pstmt;
        public ExecuteUpdate(final int serverid, final PreparedStatement stmt) {
            super(serverid);
            this.pstmt = stmt;
        }
        public Integer call() throws Exception {
            if (pstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(pstmt.executeUpdate());
        }
    }
    
    public static final class ExecuteQuery extends ForestTask<ResultSet> {
        private final PreparedStatement pstmt;
        public ExecuteQuery(final int serverid, final PreparedStatement stmt) {
            super(serverid);
            this.pstmt = stmt;
        }
        public ResultSet call() throws Exception {
            if (pstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return pstmt.executeQuery();
        }
    }
    
    public static final class ClearParameters extends ForestTask<Void> {
        private final PreparedStatement stmt;
        public ClearParameters(final int serverid, final PreparedStatement stmt) {
            super(serverid);
            this.stmt = stmt;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.clearParameters();
            return null;
        }
    }
    
    public static final class GetMetadata extends ForestTask<ResultSetMetaData> {
        private final PreparedStatement stmt;
        public GetMetadata(final int serverid, final PreparedStatement stmt) {
            super(serverid);
            this.stmt = stmt;
        }
        public ResultSetMetaData call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return stmt.getMetaData();
        }
    }
    
    public static final class SetAsciiStream extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final InputStream arg1;
        private final int arg2;
        public SetAsciiStream(final int serverid, final PreparedStatement stmt, int arg0, InputStream arg1, int arg2) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setAsciiStream(arg0, arg1, arg2);
            return null;
        }
    }
    
    public static final class SetArray extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int parameterIndex;
        private final Array x;
        public SetArray(final int serverid, final PreparedStatement stmt, int parameterIndex, Array x) {
            super(serverid);
            this.stmt = stmt;
            this.parameterIndex = parameterIndex;
            this.x = x;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setArray(parameterIndex, x);
            return null;
        }
    }
    
    public static final class SetBigDecimal extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final BigDecimal arg1;
        public SetBigDecimal(final int serverid, final PreparedStatement stmt, int arg0, BigDecimal arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setBigDecimal(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetBinaryStream extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final InputStream arg1;
        private final int arg2;
        public SetBinaryStream(final int serverid, final PreparedStatement stmt, int arg0, InputStream arg1, int arg2) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setBinaryStream(arg0, arg1, arg2);
            return null;
        }
    }
    
    public static final class SetBlob extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int parameterIndex;
        private final Blob x;
        public SetBlob(final int serverid, final PreparedStatement stmt, int parameterIndex, Blob x) {
            super(serverid);
            this.stmt = stmt;
            this.parameterIndex = parameterIndex;
            this.x = x;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setBlob(parameterIndex, x);
            return null;
        }
    }
    
    public static final class SetBoolean extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final boolean arg1;
        public SetBoolean(final int serverid, final PreparedStatement stmt, int arg0, boolean arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setBoolean(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetByte extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final byte arg1;
        public SetByte(final int serverid, final PreparedStatement stmt, int arg0, byte arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setByte(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetBytes extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final byte[] arg1;
        public SetBytes(final int serverid, final PreparedStatement stmt, int arg0, byte[] arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = (arg1 != null) ? arg1.clone() : null;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setBytes(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetCharacterStream extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int parameterIndex;
        private final Reader reader;
        private final int length;
        public SetCharacterStream(final int serverid, final PreparedStatement stmt, int parameterIndex, Reader reader, int length) {
            super(serverid);
            this.stmt = stmt;
            this.parameterIndex = parameterIndex;
            this.reader = reader;
            this.length = length;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setCharacterStream(parameterIndex, reader, length);
            return null;
        }
    }
    
    public static final class SetClob extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int parameterIndex;
        private final Clob x;
        public SetClob(final int serverid, final PreparedStatement stmt, int parameterIndex, Clob x) {
            super(serverid);
            this.stmt = stmt;
            this.parameterIndex = parameterIndex;
            this.x = x;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setClob(parameterIndex, x);
            return null;
        }
    }
    
    public static final class SetDate_IntDate extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final java.sql.Date arg1;
        public SetDate_IntDate(final int serverid, final PreparedStatement stmt, int arg0, java.sql.Date arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setDate(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetDate_IntDateCal extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int parameterIndex;
        private final java.sql.Date x;
        private final Calendar cal;
        public SetDate_IntDateCal(final int serverid, final PreparedStatement stmt, int parameterIndex, Date x, Calendar cal) {
            super(serverid);
            this.stmt = stmt;
            this.parameterIndex = parameterIndex;
            this.x = x;
            this.cal = cal;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setDate(parameterIndex, x, cal);
            return null;
        }
    }
    
    public static final class SetDouble extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final double arg1;
        public SetDouble(final int serverid, final PreparedStatement stmt, int arg0, double arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setDouble(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetFloat extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final float arg1;
        public SetFloat(final int serverid, final PreparedStatement stmt, int arg0, float arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setFloat(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetInt extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final int arg1;
        public SetInt(final int serverid, final PreparedStatement stmt, int arg0, int arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setInt(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetLong extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final long arg1;
        public SetLong(final int serverid, final PreparedStatement stmt, int arg0, long arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setLong(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetNull_IntInt extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final int arg1;
        public SetNull_IntInt(final int serverid, final PreparedStatement stmt, int arg0, int arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setNull(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetNull_IntIntStr extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int parameterIndex;
        private final int sqlType;
        private final String typeName;
        public SetNull_IntIntStr(final int serverid, final PreparedStatement stmt, int parameterIndex, int sqlType, String typeName) {
            super(serverid);
            this.stmt = stmt;
            this.parameterIndex = parameterIndex;
            this.sqlType = sqlType;
            this.typeName = typeName;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setNull(parameterIndex, sqlType, typeName);
            return null;
        }
    }
    
    public static final class SetObject_IntObj extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final Object arg1;
        public SetObject_IntObj(final int serverid, final PreparedStatement stmt, int arg0, Object arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setObject(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetObject_IntObjInt extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final Object arg1;
        private final int arg2;
        public SetObject_IntObjInt(final int serverid, final PreparedStatement stmt, int arg0, Object arg1, int arg2) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setObject(arg0, arg1, arg2);
            return null;
        }
    }
    
    public static final class SetRef extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int parameterIndex;
        private final Ref x;
        public SetRef(final int serverid, final PreparedStatement stmt, int parameterIndex, Ref x) {
            super(serverid);
            this.stmt = stmt;
            this.parameterIndex = parameterIndex;
            this.x = x;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setRef(parameterIndex, x);
            return null;
        }
    }
    
    public static final class SetShort extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final short arg1;
        public SetShort(final int serverid, final PreparedStatement stmt, int arg0, short arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setShort(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetString extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final String arg1;
        public SetString(final int serverid, final PreparedStatement stmt, int arg0, String arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setString(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetTime_IntTime extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final Time arg1;
        public SetTime_IntTime(final int serverid, final PreparedStatement stmt, int arg0, Time arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setTime(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetTime_IntTimeCal extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int parameterIndex;
        private final Time x;
        private final Calendar cal;
        public SetTime_IntTimeCal(final int serverid, final PreparedStatement stmt, int parameterIndex, Time x, Calendar cal) {
            super(serverid);
            this.stmt = stmt;
            this.parameterIndex = parameterIndex;
            this.x = x;
            this.cal = cal;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setTime(parameterIndex, x, cal);
            return null;
        }
    }
    
    public static final class SetTimestamp_IntTime extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final Timestamp arg1;
        public SetTimestamp_IntTime(final int serverid, final PreparedStatement stmt, int arg0, Timestamp arg1) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setTimestamp(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetTimestamp_IntTimeCal extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int parameterIndex;
        private final Timestamp x;
        private final Calendar cal;
        public SetTimestamp_IntTimeCal(final int serverid, final PreparedStatement stmt, int parameterIndex, Timestamp x, Calendar cal) {
            super(serverid);
            this.stmt = stmt;
            this.parameterIndex = parameterIndex;
            this.x = x;
            this.cal = cal;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setTimestamp(parameterIndex, x, cal);
            return null;
        }
    }
    
    public static final class SetUnicodeStream extends ForestTask<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final InputStream arg1;
        private final int arg2;
        public SetUnicodeStream(final int serverid, final PreparedStatement stmt, int arg0, InputStream arg1, int arg2) {
            super(serverid);
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        @SuppressWarnings("deprecation")
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setUnicodeStream(arg0, arg1, arg2);
            return null;
        }
    }
    
}
