/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.apibase;

import java.sql.*;
import java.util.*;

import org.postgresforest.exception.ForestTaskNotExecutedException;
import org.postgresforest.util.ForestTask;
import org.postgresforest.util.PgUrl;


public final class DriverTask {
    
    public static final class Connect extends ForestTask<Connection> {
        private final PgUrl pgUrl;
        private final Properties options;
        public Connect(final int serverid, final PgUrl pgUrl, final Properties options) {
            super(serverid);
            this.pgUrl = pgUrl;
            this.options = options;
        }
        public Connection call() throws Exception {
            if (pgUrl == null || options == null) {
                throw new ForestTaskNotExecutedException();
            }
            java.sql.Driver driver = new org.postgresql.Driver();
            return driver.connect(pgUrl.getUrl(), options);
        }
        
    }
}
