/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.apibase;

import java.sql.*;

import org.postgresforest.exception.*;
import org.postgresforest.util.ForestTask;

public final class DatabaseMetaDataTask {
    
    public static final class AllProceduresAreCallable extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public AllProceduresAreCallable(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.allProceduresAreCallable());
        }
    }
    
    public static final class AllTablesAreSelectable extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public AllTablesAreSelectable(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.allTablesAreSelectable());
        }
    }
    
    public static final class DataDefinitionCausesTransactionCommit extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public DataDefinitionCausesTransactionCommit(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.dataDefinitionCausesTransactionCommit());
        }
    }
    
    public static final class DataDefinitionIgnoredInTransactions extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public DataDefinitionIgnoredInTransactions(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.dataDefinitionIgnoredInTransactions());
        }
    }
    
    public static final class DoesMaxRowSizeIncludeBlobs extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public DoesMaxRowSizeIncludeBlobs(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.doesMaxRowSizeIncludeBlobs());
        }
    }
    
    public static final class GetBestRowIdentifier extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        private final int arg3;
        private boolean arg4;
        public GetBestRowIdentifier(final int serverid, final DatabaseMetaData dbmd, String arg0, String arg1, String arg2, int arg3, boolean arg4) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getBestRowIdentifier(arg0, arg1, arg2, arg3, arg4);
        }
    }
    
    public static final class GetCatalogs extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        public GetCatalogs(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getCatalogs();
        }
    }
    
    public static final class GetCatalogTerm extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetCatalogTerm(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getCatalogTerm();
        }
    }
    
    public static final class GetColumnPrivileges extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        private final String arg3;
        public GetColumnPrivileges(final int serverid, final DatabaseMetaData dbmd, String arg0, String arg1, String arg2, String arg3) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getColumnPrivileges(arg0, arg1, arg2, arg3);
        }
    }
    
    public static final class GetColumns extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        private final String arg3;
        public GetColumns(final int serverid, final DatabaseMetaData dbmd, String arg0, String arg1, String arg2, String arg3) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getColumns(arg0, arg1, arg2, arg3);
        }
    }
    
    public static final class GetCrossReference extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        private final String arg3;
        private final String arg4;
        private final String arg5;
        
        public GetCrossReference(final int serverid, final DatabaseMetaData dbmd, String arg0, String arg1, String arg2, String arg3, String arg4, String arg5) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
            this.arg5 = arg5;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getCrossReference(arg0, arg1, arg2, arg3, arg4, arg5);
        }
    }
    
    public static final class GetDatabaseProductName extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetDatabaseProductName(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getDatabaseProductName();
        }
    }
    
    public static final class GetDatabaseProductVersion extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetDatabaseProductVersion(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getDatabaseProductVersion();
        }
    }
    
    public static final class GetDefaultTransactionIsolation extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetDefaultTransactionIsolation(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getDefaultTransactionIsolation());
        }
    }
    
    public static final class GetDriverName extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetDriverName(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getDriverName();
        }
    }
    
    public static final class GetDriverVersion extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetDriverVersion(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getDriverVersion();
        }
    }
    
    public static final class GetExportedKeys extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        
        public GetExportedKeys(final int serverid, final DatabaseMetaData dbmd, String arg0, String arg1, String arg2) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getExportedKeys(arg0, arg1, arg2);
        }
    }
    
    public static final class GetExtraNameCharacters extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetExtraNameCharacters(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getExtraNameCharacters();
        }
    }
    
    public static final class GetIdentifierQuoteString extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetIdentifierQuoteString(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getIdentifierQuoteString();
        }
    }
    
    public static final class GetImportedKeys extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        
        public GetImportedKeys(final int serverid, final DatabaseMetaData dbmd, String arg0, String arg1, String arg2) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getImportedKeys(arg0, arg1, arg2);
        }
    }
    
    public static final class GetIndexInfo extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        private final boolean arg3;
        private final boolean arg4;
        
        public GetIndexInfo(final int serverid, final DatabaseMetaData dbmd, String arg0, String arg1, String arg2, boolean arg3, boolean arg4) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getIndexInfo(arg0, arg1, arg2, arg3, arg4);
        }
    }
    
    public static final class GetMaxBinaryLiteralLength extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxBinaryLiteralLength(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxBinaryLiteralLength());
        }
    }
    
    public static final class GetMaxCatalogNameLength extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxCatalogNameLength(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxCatalogNameLength());
        }
    }
    
    public static final class GetMaxCharLiteralLength extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxCharLiteralLength(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxCharLiteralLength());
        }
    }
    
    public static final class GetMaxColumnNameLength extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxColumnNameLength(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxColumnNameLength());
        }
    }
    
    public static final class GetMaxColumnsInGroupBy extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxColumnsInGroupBy(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxColumnsInGroupBy());
        }
    }
    
    public static final class GetMaxColumnsInIndex extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxColumnsInIndex(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxColumnsInIndex());
        }
    }
    
    public static final class GetMaxColumnsInOrderBy extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxColumnsInOrderBy(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxColumnsInOrderBy());
        }
    }
    
    public static final class GetMaxColumnsInSelect extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxColumnsInSelect(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxColumnsInSelect());
        }
    }
    
    public static final class GetMaxColumnsInTable extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxColumnsInTable(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxColumnsInTable());
        }
    }
    
    public static final class GetMaxConnections extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxConnections(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxConnections());
        }
    }
    
    public static final class GetMaxCursorNameLength extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxCursorNameLength(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxCursorNameLength());
        }
    }
    
    public static final class GetMaxIndexLength extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxIndexLength(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxIndexLength());
        }
    }
    
    public static final class GetMaxProcedureNameLength extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxProcedureNameLength(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxProcedureNameLength());
        }
    }
    
    public static final class GetMaxRowSize extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxRowSize(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxRowSize());
        }
    }
    
    public static final class GetMaxSchemaNameLength extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxSchemaNameLength(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxSchemaNameLength());
        }
    }
    
    public static final class GetMaxStatementLength extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxStatementLength(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxStatementLength());
        }
    }
    
    public static final class GetMaxStatements extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxStatements(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxStatements());
        }
    }
    
    public static final class GetMaxTableNameLength extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxTableNameLength(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxTableNameLength());
        }
    }
    
    public static final class GetMaxTablesInSelect extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxTablesInSelect(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxTablesInSelect());
        }
    }
    
    public static final class GetMaxUserNameLength extends ForestTask<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxUserNameLength(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxUserNameLength());
        }
    }
    
    public static final class GetNumericFunctions extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetNumericFunctions(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getNumericFunctions();
        }
    }
    
    public static final class GetPrimaryKeys extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        
        public GetPrimaryKeys(final int serverid, final DatabaseMetaData dbmd, String arg0, String arg1, String arg2) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getPrimaryKeys(arg0, arg1, arg2);
        }
    }
    
    public static final class GetProcedureColumns extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        private final String arg3;
        
        public GetProcedureColumns(final int serverid, final DatabaseMetaData dbmd, String arg0, String arg1, String arg2, String arg3) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getProcedureColumns(arg0, arg1, arg2, arg3);
        }
    }
    
    public static final class GetProcedures extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        
        public GetProcedures(final int serverid, final DatabaseMetaData dbmd, String arg0, String arg1, String arg2) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getProcedures(arg0, arg1, arg2);
        }
    }
    
    public static final class GetProcedureTerm extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetProcedureTerm(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getProcedureTerm();
        }
    }
    
    public static final class GetSchemaTerm extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetSchemaTerm(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getSchemaTerm();
        }
    }
    
    public static final class GetSchemas extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        public GetSchemas(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getSchemas();
        }
    }
    
    public static final class GetSearchStringEscape extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetSearchStringEscape(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getSearchStringEscape();
        }
    }
    
    public static final class GetSQLKeywords extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetSQLKeywords(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getSQLKeywords();
        }
    }
    
    public static final class GetStringFunctions extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetStringFunctions(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getStringFunctions();
        }
    }
    
    public static final class GetSystemFunctions extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetSystemFunctions(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getSystemFunctions();
        }
    }
    
    public static final class GetTablePrivileges extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        public GetTablePrivileges(final int serverid, final DatabaseMetaData dbmd, String arg0, String arg1, String arg2) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getTablePrivileges(arg0, arg1, arg2);
        }
    }
    
    public static final class GetTables extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        private final String[] arg3;
        public GetTables(final int serverid, final DatabaseMetaData dbmd, String arg0, String arg1, String arg2, String[] arg3) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = (arg3 != null) ? arg3.clone() : null;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getTables(arg0, arg1, arg2, arg3);
        }
    }
    
    public static final class GetTableTypes extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        public GetTableTypes(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getTableTypes();
        }
    }
    
    public static final class GetTimeDateFunctions extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetTimeDateFunctions(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getTimeDateFunctions();
        }
    }
    
    public static final class GetTypeInfo extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        public GetTypeInfo(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getTypeInfo();
        }
    }
    
    public static final class GetUserName extends ForestTask<String> {
        private final DatabaseMetaData dbmd;
        public GetUserName(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getUserName();
        }
    }
    
    public static final class GetUDTs extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String catalog;
        private final String schemaPattern;
        private final String typeNamePattern;
        private final int[] types;
        public GetUDTs(final int serverid, final DatabaseMetaData dbmd, 
                final String catalog, final String schemaPattern, final String typeNamePattern, int[] types) {
            super(serverid);
            this.dbmd = dbmd;
            this.catalog = catalog;
            this.schemaPattern = schemaPattern;
            this.typeNamePattern = typeNamePattern;
            this.types = types;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getUDTs(catalog, schemaPattern, typeNamePattern, types);
        }
    }
    
    public static final class GetVersionColumns extends ForestTask<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        public GetVersionColumns(final int serverid, final DatabaseMetaData dbmd, String arg0, String arg1, String arg2) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getVersionColumns(arg0, arg1, arg2);
        }
    }
    
    public static final class IsCatalogAtStart extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public IsCatalogAtStart(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.isCatalogAtStart());
        }
    }
    
    public static final class IsReadOnly extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public IsReadOnly(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.isReadOnly());
        }
    }
    
    public static final class NullPlusNonNullIsNull extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public NullPlusNonNullIsNull(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.nullPlusNonNullIsNull());
        }
    }
    
    public static final class NullsAreSortedAtEnd extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public NullsAreSortedAtEnd(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.nullsAreSortedAtEnd());
        }
    }
    
    public static final class NullsAreSortedAtStart extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public NullsAreSortedAtStart(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.nullsAreSortedAtStart());
        }
    }
    
    public static final class NullsAreSortedHigh extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public NullsAreSortedHigh(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.nullsAreSortedHigh());
        }
    }
    
    public static final class NullsAreSortedLow extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public NullsAreSortedLow(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.nullsAreSortedLow());
        }
    }
    
    public static final class StoresLowerCaseIdentifiers extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public StoresLowerCaseIdentifiers(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.storesLowerCaseIdentifiers());
        }
    }
    
    public static final class StoresLowerCaseQuotedIdentifiers extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public StoresLowerCaseQuotedIdentifiers(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.storesLowerCaseQuotedIdentifiers());
        }
    }
    
    public static final class StoresMixedCaseIdentifiers extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public StoresMixedCaseIdentifiers(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.storesMixedCaseIdentifiers());
        }
    }
    
    public static final class StoresMixedCaseQuotedIdentifiers extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public StoresMixedCaseQuotedIdentifiers(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.storesMixedCaseQuotedIdentifiers());
        }
    }
    
    public static final class StoresUpperCaseIdentifiers extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public StoresUpperCaseIdentifiers(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.storesUpperCaseIdentifiers());
        }
    }
    
    public static final class StoresUpperCaseQuotedIdentifiers extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public StoresUpperCaseQuotedIdentifiers(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.storesUpperCaseQuotedIdentifiers());
        }
    }
    
    public static final class SupportsAlterTableWithAddColumn extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsAlterTableWithAddColumn(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsAlterTableWithAddColumn());
        }
    }
    
    public static final class SupportsAlterTableWithDropColumn extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsAlterTableWithDropColumn(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsAlterTableWithDropColumn());
        }
    }
    
    public static final class SupportsANSI92EntryLevelSQL extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsANSI92EntryLevelSQL(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsANSI92EntryLevelSQL());
        }
    }
    
    public static final class SupportsANSI92FullSQL extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsANSI92FullSQL(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsANSI92FullSQL());
        }
    }
    
    public static final class SupportsANSI92IntermediateSQL extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsANSI92IntermediateSQL(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsANSI92IntermediateSQL());
        }
    }
    
    public static final class SupportsBatchUpdates extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsBatchUpdates(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsBatchUpdates());
        }
    }
    
    public static final class SupportsCatalogsInDataManipulation extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsCatalogsInDataManipulation(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsCatalogsInDataManipulation());
        }
    }
    
    public static final class SupportsCatalogsInIndexDefinitions extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsCatalogsInIndexDefinitions(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsCatalogsInIndexDefinitions());
        }
    }
    
    public static final class SupportsCatalogsInPrivilegeDefinitions extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsCatalogsInPrivilegeDefinitions(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsCatalogsInPrivilegeDefinitions());
        }
    }
    
    public static final class SupportsCatalogsInProcedureCalls extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsCatalogsInProcedureCalls(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsCatalogsInProcedureCalls());
        }
    }
    
    public static final class SupportsCatalogsInTableDefinitions extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsCatalogsInTableDefinitions(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsCatalogsInTableDefinitions());
        }
    }
    
    public static final class SupportsColumnAliasing extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsColumnAliasing(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsColumnAliasing());
        }
    }
    
    public static final class SupportsConvert extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsConvert(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsConvert());
        }
    }
    
    public static final class SupportsConvert_IntInt extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        private final int arg0;
        private final int arg1;
        public SupportsConvert_IntInt(final int serverid, final DatabaseMetaData dbmd, int arg0, int arg1) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsConvert(arg0, arg1));
        }
    }
    
    public static final class SupportsCoreSQLGrammar extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsCoreSQLGrammar(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsCoreSQLGrammar());
        }
    }
    
    public static final class SupportsCorrelatedSubqueries extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsCorrelatedSubqueries(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsCorrelatedSubqueries());
        }
    }
    
    public static final class SupportsDataDefinitionAndDataManipulationTransactions extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsDataDefinitionAndDataManipulationTransactions(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsDataDefinitionAndDataManipulationTransactions());
        }
    }
    
    public static final class SupportsDataManipulationTransactionsOnly extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsDataManipulationTransactionsOnly(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsDataManipulationTransactionsOnly());
        }
    }
    
    public static final class SupportsDifferentTableCorrelationNames extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsDifferentTableCorrelationNames(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsDifferentTableCorrelationNames());
        }
    }
    
    public static final class SupportsExpressionsInOrderBy extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsExpressionsInOrderBy(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsExpressionsInOrderBy());
        }
    }
    
    public static final class SupportsExtendedSQLGrammar extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsExtendedSQLGrammar(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsExtendedSQLGrammar());
        }
    }
    
    public static final class SupportsFullOuterJoins extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsFullOuterJoins(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsFullOuterJoins());
        }
    }
    
    public static final class SupportsGroupBy extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsGroupBy(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsGroupBy());
        }
    }
    
    public static final class SupportsGroupByBeyondSelect extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsGroupByBeyondSelect(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsGroupByBeyondSelect());
        }
    }
    
    public static final class SupportsGroupByUnrelated extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsGroupByUnrelated(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsGroupByUnrelated());
        }
    }
    
    public static final class SupportsIntegrityEnhancementFacility extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsIntegrityEnhancementFacility(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsIntegrityEnhancementFacility());
        }
    }
    
    public static final class SupportsLikeEscapeClause extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsLikeEscapeClause(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsLikeEscapeClause());
        }
    }
    
    public static final class SupportsLimitedOuterJoins extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsLimitedOuterJoins(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsLimitedOuterJoins());
        }
    }
    
    public static final class SupportsMinimumSQLGrammar extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsMinimumSQLGrammar(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsMinimumSQLGrammar());
        }
    }
    
    public static final class SupportsMixedCaseIdentifiers extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsMixedCaseIdentifiers(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsMixedCaseIdentifiers());
        }
    }
    
    public static final class SupportsMixedCaseQuotedIdentifiers extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsMixedCaseQuotedIdentifiers(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsMixedCaseQuotedIdentifiers());
        }
    }
    
    public static final class SupportsMultipleResultSets extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsMultipleResultSets(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsMultipleResultSets());
        }
    }
    
    public static final class SupportsMultipleTransactions extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsMultipleTransactions(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsMultipleTransactions());
        }
    }
    
    public static final class SupportsNonNullableColumns extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsNonNullableColumns(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsNonNullableColumns());
        }
    }
    
    public static final class SupportsOpenCursorsAcrossCommit extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsOpenCursorsAcrossCommit(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsOpenCursorsAcrossCommit());
        }
    }
    
    public static final class SupportsOpenCursorsAcrossRollback extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsOpenCursorsAcrossRollback(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsOpenCursorsAcrossRollback());
        }
    }
    
    public static final class SupportsOpenStatementsAcrossCommit extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsOpenStatementsAcrossCommit(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsOpenStatementsAcrossCommit());
        }
    }
    
    public static final class SupportsOpenStatementsAcrossRollback extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsOpenStatementsAcrossRollback(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsOpenStatementsAcrossRollback());
        }
    }
    
    public static final class SupportsOrderByUnrelated extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsOrderByUnrelated(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsOrderByUnrelated());
        }
    }
    
    public static final class SupportsOuterJoins extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsOuterJoins(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsOuterJoins());
        }
    }
    
    public static final class SupportsPositionedDelete extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsPositionedDelete(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsPositionedDelete());
        }
    }
    
    public static final class SupportsPositionedUpdate extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsPositionedUpdate(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsPositionedUpdate());
        }
    }
    
    public static final class SupportsResultSetConcurrency extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        private final int type;
        private final int concurrency;
        public SupportsResultSetConcurrency(final int serverid, final DatabaseMetaData dbmd, final int type, final int concurrency) {
            super(serverid); this.dbmd = dbmd;
            this.type = type;
            this.concurrency = concurrency;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsResultSetConcurrency(type, concurrency));
        }
    }
    
    public static final class SupportsResultSetType extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        private final int type;
        public SupportsResultSetType(final int serverid, final DatabaseMetaData dbmd, final int type) {
            super(serverid); this.dbmd = dbmd;
            this.type = type;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsResultSetType(type));
        }
    }
    
    public static final class SupportsSchemasInDataManipulation extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSchemasInDataManipulation(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSchemasInDataManipulation());
        }
    }
    
    public static final class SupportsSchemasInIndexDefinitions extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSchemasInIndexDefinitions(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSchemasInIndexDefinitions());
        }
    }
    
    public static final class SupportsSchemasInPrivilegeDefinitions extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSchemasInPrivilegeDefinitions(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSchemasInPrivilegeDefinitions());
        }
    }
    
    public static final class SupportsSchemasInProcedureCalls extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSchemasInProcedureCalls(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSchemasInProcedureCalls());
        }
    }
    
    public static final class SupportsSchemasInTableDefinitions extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSchemasInTableDefinitions(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSchemasInTableDefinitions());
        }
    }
    
    public static final class SupportsSelectForUpdate extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSelectForUpdate(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSelectForUpdate());
        }
    }
    
    public static final class SupportsStoredProcedures extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsStoredProcedures(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsStoredProcedures());
        }
    }
    
    public static final class SupportsSubqueriesInComparisons extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSubqueriesInComparisons(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSubqueriesInComparisons());
        }
    }
    
    public static final class SupportsSubqueriesInExists extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSubqueriesInExists(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSubqueriesInExists());
        }
    }
    
    public static final class SupportsSubqueriesInIns extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSubqueriesInIns(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSubqueriesInIns());
        }
    }
    
    public static final class SupportsSubqueriesInQuantifieds extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSubqueriesInQuantifieds(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSubqueriesInQuantifieds());
        }
    }
    
    public static final class SupportsTableCorrelationNames extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsTableCorrelationNames(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsTableCorrelationNames());
        }
    }
    
    public static final class SupportsTransactionIsolationLevel extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        private final int arg0;
        public SupportsTransactionIsolationLevel(final int serverid, final DatabaseMetaData dbmd, int arg0) {
            super(serverid); this.dbmd = dbmd;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsTransactionIsolationLevel(arg0));
        }
    }
    
    public static final class SupportsTransactions extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsTransactions(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsTransactions());
        }
    }
    
    public static final class SupportsUnion extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsUnion(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsUnion());
        }
    }
    
    public static final class SupportsUnionAll extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsUnionAll(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsUnionAll());
        }
    }
    
    public static final class UsesLocalFilePerTable extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public UsesLocalFilePerTable(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.usesLocalFilePerTable());
        }
    }
    
    public static final class UsesLocalFiles extends ForestTask<Boolean> {
        private final DatabaseMetaData dbmd;
        public UsesLocalFiles(final int serverid, final DatabaseMetaData dbmd) {
            super(serverid); this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.usesLocalFiles());
        }
    }
}
