/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.apibase;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

import org.postgresforest.util.ForestTask;
import org.postgresforest.exception.ForestTaskNotExecutedException;

public final class CallableStatementTask {
    
    public static final class GetArray_Int extends ForestTask<Array> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetArray_Int(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Array call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getArray(arg0);
        }
    }
    
    public static final class GetBigDecimal_IntInt extends ForestTask<BigDecimal> {
        private final CallableStatement cstmt;
        private final int arg0;
        private final int arg1;
        public GetBigDecimal_IntInt(int serverid, CallableStatement cstmt, int arg0, int arg1) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        @SuppressWarnings("deprecation")
        public BigDecimal call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getBigDecimal(arg0, arg1);
        }
    }
    
    public static final class GetBigDecimal_Int extends ForestTask<BigDecimal> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetBigDecimal_Int(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public BigDecimal call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getBigDecimal(arg0);
        }
    }
    
    public static final class GetBlob_Int extends ForestTask<Blob> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetBlob_Int(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Blob call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getBlob(arg0);
        }
    }
    
    public static final class GetBoolean extends ForestTask<Boolean> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetBoolean(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(cstmt.getBoolean(arg0));
        }
    }
    
    public static final class GetByte extends ForestTask<Byte> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetByte(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Byte call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Byte.valueOf(cstmt.getByte(arg0));
        }
    }
    
    public static final class GetBytes extends ForestTask<byte[]> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetBytes(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public byte[] call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getBytes(arg0);
        }
    }
    
    public static final class GetClob_Int extends ForestTask<Clob> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetClob_Int(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Clob call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getClob(arg0);
        }
    }
    
    public static final class GetDate extends ForestTask<Date> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetDate(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Date call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getDate(arg0);
        }
    }
    
    public static final class GetDate_IntCalendar extends ForestTask<Date> {
        private final CallableStatement cstmt;
        private final int arg0;
        private final Calendar arg1;
        public GetDate_IntCalendar(int serverid, CallableStatement cstmt, int arg0, Calendar arg1) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Date call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getDate(arg0, arg1);
        }
    }
    
    public static final class GetDouble extends ForestTask<Double> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetDouble(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Double call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Double.valueOf(cstmt.getDouble(arg0));
        }
    }
    
    public static final class GetFloat extends ForestTask<Float> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetFloat(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Float call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Float.valueOf(cstmt.getFloat(arg0));
        }
    }
    
    public static final class GetInt extends ForestTask<Integer> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetInt(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Integer call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(cstmt.getInt(arg0));
        }
    }
    
    public static final class GetLong extends ForestTask<Long> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetLong(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Long call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Long.valueOf(cstmt.getLong(arg0));
        }
    }
    
    public static final class GetObject extends ForestTask<Object> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetObject(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Object call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getObject(arg0);
        }
    }
    
    public static final class GetObject_IntMap extends ForestTask<Object> {
        private final CallableStatement cstmt;
        private final int arg0;
        private final Map<String, Class<?>> arg1;
        public GetObject_IntMap(int serverid, CallableStatement cstmt, int arg0, Map<String, Class<?>> arg1) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Object call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getObject(arg0, arg1);
        }
    }
    
    public static final class GetRef_Int extends ForestTask<Ref> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetRef_Int(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Ref call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getRef(arg0);
        }
    }
    
    public static final class GetShort extends ForestTask<Short> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetShort(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Short call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Short.valueOf(cstmt.getShort(arg0));
        }
    }
    
    public static final class GetString extends ForestTask<String> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetString(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getString(arg0);
        }
    }
    
    public static final class GetTime extends ForestTask<Time> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetTime(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Time call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getTime(arg0);
        }
    }
    
    public static final class GetTime_IntCalendar extends ForestTask<Time> {
        private final CallableStatement cstmt;
        private final int arg0;
        private final Calendar arg1;
        public GetTime_IntCalendar(int serverid, CallableStatement cstmt, int arg0, Calendar arg1) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Time call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getTime(arg0, arg1);
        }
    }
    
    public static final class GetTimestamp extends ForestTask<Timestamp> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetTimestamp(int serverid, CallableStatement cstmt, int arg0) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Timestamp call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getTimestamp(arg0);
        }
    }
    
    public static final class GetTimestamp_IntCalendar extends ForestTask<Timestamp> {
        private final CallableStatement cstmt;
        private final int arg0;
        private final Calendar arg1;
        public GetTimestamp_IntCalendar(int serverid, CallableStatement cstmt, int arg0, Calendar arg1) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Timestamp call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getTimestamp(arg0, arg1);
        }
    }
    
    public static final class WasNull extends ForestTask<Boolean> {
        private final CallableStatement cstmt;
        public WasNull(int serverid, CallableStatement cstmt) {
            super(serverid);
            this.cstmt = cstmt;
        }
        public Boolean call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(cstmt.wasNull());
        }
    }
    
    public static final class RegisterOutParameter_IntInt extends ForestTask<Void> {
        private final CallableStatement cstmt;
        private final int arg0;
        private final int arg1;
        public RegisterOutParameter_IntInt(int serverid, CallableStatement cstmt, int arg0, int arg1) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            cstmt.registerOutParameter(arg0, arg1);
            return null;
        }
    }
    
    public static final class RegisterOutParameter_IntIntInt extends ForestTask<Void> {
        private final CallableStatement cstmt;
        private final int arg0;
        private final int arg1;
        private final int arg2;
        public RegisterOutParameter_IntIntInt(int serverid, CallableStatement cstmt, int arg0, int arg1, int arg2) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public Void call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            cstmt.registerOutParameter(arg0, arg1, arg2);
            return null;
        }
    }
    
    public static final class RegisterOutParameter_IntIntString extends ForestTask<Void> {
        private final CallableStatement cstmt;
        private final int arg0;
        private final int arg1;
        private final String arg2;
        public RegisterOutParameter_IntIntString(int serverid, CallableStatement cstmt, int arg0, int arg1, String arg2) {
            super(serverid);
            this.cstmt = cstmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public Void call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            cstmt.registerOutParameter(arg0, arg1, arg2);
            return null;
        }
    }
    
}
