/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest;

import java.sql.*;
import java.util.List;

import org.postgresforest.apibase.*;
import org.postgresforest.constant.ErrorStr;
import org.postgresforest.exception.ForestResourceDisposedException;
import org.postgresforest.util.ForestTask;

public final class ForestResultSetMetaData implements ResultSetMetaData {
    
    private final EntrypointCommonResource epCommonResource;
    private final List<ResultSetMetaData> resMetaList;
    private final int execServerId;
    
    public ForestResultSetMetaData(final EntrypointCommonResource epCommonResource, final List<ResultSetMetaData> resMetaList, final int execServerId) {
        this.epCommonResource = epCommonResource;
        this.execServerId = execServerId;
        this.resMetaList = resMetaList;
    }
    
    private boolean isClosed = false;
    private void checkClosed() throws ForestResourceDisposedException {
        if (isClosed == true) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
    }
    
    public String getCatalogName(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<String> task = new ResultSetMetaDataTask.GetCatalogName(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public String getColumnClassName(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<String> task = new ResultSetMetaDataTask.GetColumnClassName_Int(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public int getColumnCount() throws SQLException {
        checkClosed();
        final ForestTask<Integer> task = new ResultSetMetaDataTask.GetColumnCount(execServerId, resMetaList.get(execServerId));
        return epCommonResource.executeOneApi(task).intValue();
    }
    
    public int getColumnDisplaySize(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<Integer> task = new ResultSetMetaDataTask.GetColumnDisplaySize(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task).intValue();
    }
    
    public String getColumnLabel(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<String> task = new ResultSetMetaDataTask.GetColumnLabel(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public String getColumnName(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<String> task = new ResultSetMetaDataTask.GetColumnName(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public int getColumnType(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<Integer> task = new ResultSetMetaDataTask.GetColumnType(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task).intValue();
    }
    
    public String getColumnTypeName(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<String> task = new ResultSetMetaDataTask.GetColumnTypeName(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public int getPrecision(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<Integer> task = new ResultSetMetaDataTask.GetPrecision(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task).intValue();
    }
    
    public int getScale(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<Integer> task = new ResultSetMetaDataTask.GetScale(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task).intValue();
    }
    
    public String getSchemaName(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<String> task = new ResultSetMetaDataTask.GetSchemaName(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public String getTableName(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<String> task = new ResultSetMetaDataTask.GetTableName(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public boolean isAutoIncrement(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<Boolean> task = new ResultSetMetaDataTask.IsAutoIncrement(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task).booleanValue();
    }
    
    public boolean isCaseSensitive(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<Boolean> task = new ResultSetMetaDataTask.IsCaseSensitive(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task).booleanValue();
    }
    
    public boolean isCurrency(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<Boolean> task = new ResultSetMetaDataTask.IsCurrency(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task).booleanValue();
    }
    
    public boolean isDefinitelyWritable(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<Boolean> task = new ResultSetMetaDataTask.IsDefinitelyWritable(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task).booleanValue();
    }
    
    public int isNullable(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<Integer> task = new ResultSetMetaDataTask.IsNullable(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task).intValue();
    }
    
    public boolean isReadOnly(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<Boolean> task = new ResultSetMetaDataTask.IsReadOnly(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task).booleanValue();
    }
    
    public boolean isSearchable(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<Boolean> task = new ResultSetMetaDataTask.IsSearchable(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task).booleanValue();
    }
    
    public boolean isSigned(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<Boolean> task = new ResultSetMetaDataTask.IsSigned(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task).booleanValue();
    }
    
    public boolean isWritable(int arg0) throws SQLException {
        checkClosed();
        final ForestTask<Boolean> task = new ResultSetMetaDataTask.IsWritable(execServerId, resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task).booleanValue();
    }
    
}
