/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */

package org.postgresforest;

import java.sql.Ref;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.postgresforest.apibase.EntrypointCommonResource;
import org.postgresforest.apibase.RefTask;
import org.postgresforest.util.ForestTask;

public class ForestRef implements Ref {
    
    private final EntrypointCommonResource epCommonResource;
    private final List<Ref> resRefList;
    private final int execServerId;
    
    public ForestRef(EntrypointCommonResource epCommonResource, List<Ref> resRefList, int execServerId) {
        this.epCommonResource = epCommonResource;
        this.resRefList = resRefList;
        this.execServerId = execServerId;
    }
    
    public String getBaseTypeName() throws SQLException {
        final ForestTask<String> task = new RefTask.GetBaseTypeName(execServerId, resRefList.get(execServerId));
        return epCommonResource.executeOneApi(task);
    }
    
    public Object getObject() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Object getObject(Map<String, Class<?>> arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setObject(Object arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
}
