/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest;

import java.lang.ref.WeakReference;
import java.sql.*;
import java.util.*;

import org.postgresforest.apibase.*;
import org.postgresforest.constant.ConstStr;
import org.postgresforest.constant.ErrorStr;
import org.postgresforest.constant.UdbValidity;
import org.postgresforest.exception.ForestResourceDisposedException;
import org.postgresforest.mng.MngInfo.GlobalConfig;
import org.postgresforest.mng.MngInfo.LocalConfig;
import org.postgresforest.util.*;

public final class ForestDatabaseMetaData implements DatabaseMetaData, ForestCloseable, ForestJdbcInfo {
    
    private boolean isClosed = false;
    private final List<DatabaseMetaData> dbmds;
    private final EntrypointCommonResource epCommonResource;
    private ForestResultSet resultSet;
    private final WeakReference<ForestConnection> con;
    
    private void setForestResultSet(ForestResultSet newResultSet) {
        if (resultSet != null) {
            try { resultSet.close(); } catch (SQLException e) { }
        }
        resultSet = newResultSet;
    }
    
    public ForestDatabaseMetaData(final EntrypointCommonResource epCommonResource, final List<DatabaseMetaData> dbmds, final WeakReference<ForestConnection> con) {
        this.epCommonResource = epCommonResource;
        this.dbmds = dbmds;
        this.con = con;
    }
    
    public boolean allProceduresAreCallable() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.AllProceduresAreCallable(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.AllProceduresAreCallable(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean allTablesAreSelectable() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.AllTablesAreSelectable(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.AllTablesAreSelectable(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.DataDefinitionCausesTransactionCommit(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.DataDefinitionCausesTransactionCommit(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.DataDefinitionIgnoredInTransactions(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.DataDefinitionIgnoredInTransactions(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean deletesAreDetected(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.DoesMaxRowSizeIncludeBlobs(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.DoesMaxRowSizeIncludeBlobs(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3)
    throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public ResultSet getBestRowIdentifier(String arg0, String arg1,
            String arg2, int arg3, boolean arg4) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetBestRowIdentifier(0, dbmds.get(0), arg0, arg1, arg2, arg3, arg4);
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetBestRowIdentifier(1, dbmds.get(1), arg0, arg1, arg2, arg3, arg4);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public String getCatalogSeparator() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getCatalogTerm() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<String> task0 = new DatabaseMetaDataTask.GetCatalogTerm(0, dbmds.get(0));
        final ForestTask<String> task1 = new DatabaseMetaDataTask.GetCatalogTerm(1, dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getCatalogs() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetCatalogs(0, dbmds.get(0));
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetCatalogs(1, dbmds.get(1));
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public ResultSet getColumnPrivileges(String arg0, String arg1, String arg2, String arg3)
    throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetColumnPrivileges(0, dbmds.get(0), arg0, arg1, arg2, arg3);
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetColumnPrivileges(1, dbmds.get(1), arg0, arg1, arg2, arg3);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public ResultSet getColumns(String arg0, String arg1, String arg2, String arg3)
    throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetColumns(0, dbmds.get(0), arg0, arg1, arg2, arg3);
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetColumns(1, dbmds.get(1), arg0, arg1, arg2, arg3);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public Connection getConnection() throws SQLException {
        return con.get();
    }
    
    public ResultSet getCrossReference(String arg0, String arg1, String arg2,
            String arg3, String arg4, String arg5) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetCrossReference(0, dbmds.get(0), arg0, arg1, arg2, arg3, arg4, arg5);
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetCrossReference(1, dbmds.get(1), arg0, arg1, arg2, arg3, arg4, arg5);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public int getDatabaseMajorVersion() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int getDatabaseMinorVersion() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getDatabaseProductName() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<String> task0 = new DatabaseMetaDataTask.GetDatabaseProductName(0, dbmds.get(0));
        final ForestTask<String> task1 = new DatabaseMetaDataTask.GetDatabaseProductName(1, dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public String getDatabaseProductVersion() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<String> task0 = new DatabaseMetaDataTask.GetDatabaseProductVersion(0, dbmds.get(0));
        final ForestTask<String> task1 = new DatabaseMetaDataTask.GetDatabaseProductVersion(1, dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public int getDefaultTransactionIsolation() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetDefaultTransactionIsolation(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetDefaultTransactionIsolation(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getDriverMajorVersion() {
        return 0;
    }
    
    public int getDriverMinorVersion() {
        return 0;
    }
    
    public String getDriverName() throws SQLException {
        return ConstStr.DRIVER_NAME.toString();
    }
    
    public String getDriverVersion() throws SQLException {
        return ConstStr.DRIVER_VERSION.toString();
    }
    
    public ResultSet getExportedKeys(String arg0, String arg1, String arg2)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetExportedKeys(0, dbmds.get(0), arg0, arg1, arg2);
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetExportedKeys(1, dbmds.get(1), arg0, arg1, arg2);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public String getExtraNameCharacters() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<String> task0 = new DatabaseMetaDataTask.GetExtraNameCharacters(0, dbmds.get(0));
        final ForestTask<String> task1 = new DatabaseMetaDataTask.GetExtraNameCharacters(1, dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public String getIdentifierQuoteString() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<String> task0 = new DatabaseMetaDataTask.GetIdentifierQuoteString(0, dbmds.get(0));
        final ForestTask<String> task1 = new DatabaseMetaDataTask.GetIdentifierQuoteString(1, dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getImportedKeys(String arg0, String arg1, String arg2)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetImportedKeys(0, dbmds.get(0), arg0, arg1, arg2);
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetImportedKeys(1, dbmds.get(1), arg0, arg1, arg2);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public ResultSet getIndexInfo(String arg0, String arg1, String arg2,
            boolean arg3, boolean arg4) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetIndexInfo(0, dbmds.get(0), arg0, arg1, arg2, arg3, arg4);
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetIndexInfo(1, dbmds.get(1), arg0, arg1, arg2, arg3, arg4);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public int getJDBCMajorVersion() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int getJDBCMinorVersion() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int getMaxBinaryLiteralLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxBinaryLiteralLength(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxBinaryLiteralLength(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxCatalogNameLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxCatalogNameLength(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxCatalogNameLength(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxCharLiteralLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxCharLiteralLength(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxCharLiteralLength(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxColumnNameLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxColumnNameLength(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxColumnNameLength(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxColumnsInGroupBy() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxColumnsInGroupBy(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxColumnsInGroupBy(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxColumnsInIndex() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxColumnsInIndex(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxColumnsInIndex(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxColumnsInOrderBy() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxColumnsInOrderBy(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxColumnsInOrderBy(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxColumnsInSelect() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxColumnsInSelect(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxColumnsInSelect(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxColumnsInTable() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxColumnsInTable(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxColumnsInTable(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxConnections() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxConnections(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxConnections(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxCursorNameLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxCursorNameLength(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxCursorNameLength(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxIndexLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxIndexLength(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxIndexLength(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxProcedureNameLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxProcedureNameLength(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxProcedureNameLength(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxRowSize() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxRowSize(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxRowSize(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxSchemaNameLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxSchemaNameLength(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxSchemaNameLength(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxStatementLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxStatementLength(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxStatementLength(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxStatements() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxStatements(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxStatements(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxTableNameLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxTableNameLength(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxTableNameLength(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxTablesInSelect() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxTablesInSelect(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxTablesInSelect(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxUserNameLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Integer> task0 = new DatabaseMetaDataTask.GetMaxUserNameLength(0, dbmds.get(0));
        final ForestTask<Integer> task1 = new DatabaseMetaDataTask.GetMaxUserNameLength(1, dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public String getNumericFunctions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<String> task0 = new DatabaseMetaDataTask.GetNumericFunctions(0, dbmds.get(0));
        final ForestTask<String> task1 = new DatabaseMetaDataTask.GetNumericFunctions(1, dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getPrimaryKeys(String arg0, String arg1, String arg2)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetPrimaryKeys(0, dbmds.get(0), arg0, arg1, arg2);
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetPrimaryKeys(1, dbmds.get(1), arg0, arg1, arg2);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public ResultSet getProcedureColumns(String arg0, String arg1, String arg2,
            String arg3) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetProcedureColumns(0, dbmds.get(0), arg0, arg1, arg2, arg3);
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetProcedureColumns(1, dbmds.get(1), arg0, arg1, arg2, arg3);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public String getProcedureTerm() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<String> task0 = new DatabaseMetaDataTask.GetProcedureTerm(0, dbmds.get(0));
        final ForestTask<String> task1 = new DatabaseMetaDataTask.GetProcedureTerm(1, dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getProcedures(String arg0, String arg1, String arg2)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetProcedures(0, dbmds.get(0), arg0, arg1, arg2);
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetProcedures(1, dbmds.get(1), arg0, arg1, arg2);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getSQLKeywords() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<String> task0 = new DatabaseMetaDataTask.GetSQLKeywords(0, dbmds.get(0));
        final ForestTask<String> task1 = new DatabaseMetaDataTask.GetSQLKeywords(1, dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public int getSQLStateType() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getSchemaTerm() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<String> task0 = new DatabaseMetaDataTask.GetSchemaTerm(0, dbmds.get(0));
        final ForestTask<String> task1 = new DatabaseMetaDataTask.GetSchemaTerm(1, dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getSchemas() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetSchemas(0, dbmds.get(0));
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetSchemas(1, dbmds.get(1));
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public String getSearchStringEscape() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<String> task0 = new DatabaseMetaDataTask.GetSearchStringEscape(0, dbmds.get(0));
        final ForestTask<String> task1 = new DatabaseMetaDataTask.GetSearchStringEscape(1, dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public String getStringFunctions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<String> task0 = new DatabaseMetaDataTask.GetStringFunctions(0, dbmds.get(0));
        final ForestTask<String> task1 = new DatabaseMetaDataTask.GetStringFunctions(1, dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getSuperTables(String arg0, String arg1, String arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public ResultSet getSuperTypes(String arg0, String arg1, String arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getSystemFunctions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<String> task0 = new DatabaseMetaDataTask.GetSystemFunctions(0, dbmds.get(0));
        final ForestTask<String> task1 = new DatabaseMetaDataTask.GetSystemFunctions(1, dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getTablePrivileges(String arg0, String arg1, String arg2)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetTablePrivileges(0, dbmds.get(0), arg0, arg1, arg2);
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetTablePrivileges(1, dbmds.get(1), arg0, arg1, arg2);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public ResultSet getTableTypes() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetTableTypes(0, dbmds.get(0));
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetTableTypes(1, dbmds.get(1));
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public ResultSet getTables(String arg0, String arg1, String arg2,
            String[] arg3) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetTables(0, dbmds.get(0), arg0, arg1, arg2, arg3);
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetTables(1, dbmds.get(1), arg0, arg1, arg2, arg3);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public String getTimeDateFunctions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<String> task0 = new DatabaseMetaDataTask.GetTimeDateFunctions(0, dbmds.get(0));
        final ForestTask<String> task1 = new DatabaseMetaDataTask.GetTimeDateFunctions(1, dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getTypeInfo() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetTypeInfo(0, dbmds.get(0));
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetTypeInfo(1, dbmds.get(1));
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetUDTs(0, dbmds.get(0), catalog, schemaPattern, typeNamePattern, types);
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetUDTs(1, dbmds.get(1), catalog, schemaPattern, typeNamePattern, types);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public String getURL() throws SQLException {
        return epCommonResource.getForestUrl();
    }
    
    public String getUserName() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<String> task0 = new DatabaseMetaDataTask.GetUserName(0, dbmds.get(0));
        final ForestTask<String> task1 = new DatabaseMetaDataTask.GetUserName(1, dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getVersionColumns(String arg0, String arg1, String arg2)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<ResultSet> task0 = new DatabaseMetaDataTask.GetVersionColumns(0, dbmds.get(0), arg0, arg1, arg2);
        final ForestTask<ResultSet> task1 = new DatabaseMetaDataTask.GetVersionColumns(1, dbmds.get(1), arg0, arg1, arg2);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1, null);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public boolean insertsAreDetected(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean isCatalogAtStart() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.IsCatalogAtStart(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.IsCatalogAtStart(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean isReadOnly() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.IsReadOnly(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.IsReadOnly(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean nullPlusNonNullIsNull() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.NullPlusNonNullIsNull(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.NullPlusNonNullIsNull(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean nullsAreSortedAtEnd() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.NullsAreSortedAtEnd(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.NullsAreSortedAtEnd(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean nullsAreSortedAtStart() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.NullsAreSortedAtStart(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.NullsAreSortedAtStart(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean nullsAreSortedHigh() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.NullsAreSortedHigh(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.NullsAreSortedHigh(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean nullsAreSortedLow() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.NullsAreSortedLow(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.NullsAreSortedLow(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean othersDeletesAreVisible(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean othersInsertsAreVisible(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean othersUpdatesAreVisible(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean ownDeletesAreVisible(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean ownInsertsAreVisible(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean ownUpdatesAreVisible(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.StoresLowerCaseIdentifiers(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.StoresLowerCaseIdentifiers(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.StoresLowerCaseQuotedIdentifiers(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.StoresLowerCaseQuotedIdentifiers(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.StoresMixedCaseIdentifiers(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.StoresMixedCaseIdentifiers(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.StoresMixedCaseQuotedIdentifiers(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.StoresMixedCaseQuotedIdentifiers(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.StoresUpperCaseIdentifiers(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.StoresUpperCaseIdentifiers(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.StoresUpperCaseQuotedIdentifiers(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.StoresUpperCaseQuotedIdentifiers(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsANSI92EntryLevelSQL(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsANSI92EntryLevelSQL(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsANSI92FullSQL() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsANSI92FullSQL(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsANSI92FullSQL(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsANSI92IntermediateSQL(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsANSI92IntermediateSQL(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsAlterTableWithAddColumn(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsAlterTableWithAddColumn(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsAlterTableWithDropColumn(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsAlterTableWithDropColumn(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsBatchUpdates() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsBatchUpdates(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsBatchUpdates(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsCatalogsInDataManipulation(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsCatalogsInDataManipulation(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsCatalogsInIndexDefinitions(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsCatalogsInIndexDefinitions(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsCatalogsInPrivilegeDefinitions(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsCatalogsInPrivilegeDefinitions(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsCatalogsInProcedureCalls(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsCatalogsInProcedureCalls(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsCatalogsInTableDefinitions(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsCatalogsInTableDefinitions(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsColumnAliasing() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsColumnAliasing(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsColumnAliasing(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsConvert() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsConvert(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsConvert(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsConvert(int arg0, int arg1) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsConvert_IntInt(0, dbmds.get(0), arg0, arg1);
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsConvert_IntInt(1, dbmds.get(1), arg0, arg1);
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsCoreSQLGrammar() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsCoreSQLGrammar(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsCoreSQLGrammar(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsCorrelatedSubqueries(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsCorrelatedSubqueries(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsDataDefinitionAndDataManipulationTransactions()
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsDataDefinitionAndDataManipulationTransactions(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsDataDefinitionAndDataManipulationTransactions(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsDataManipulationTransactionsOnly()
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsDataManipulationTransactionsOnly(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsDataManipulationTransactionsOnly(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsDifferentTableCorrelationNames(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsDifferentTableCorrelationNames(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsExpressionsInOrderBy(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsExpressionsInOrderBy(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsExtendedSQLGrammar(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsExtendedSQLGrammar(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsFullOuterJoins() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsFullOuterJoins(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsFullOuterJoins(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsGroupBy() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsGroupBy(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsGroupBy(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsGroupByBeyondSelect(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsGroupByBeyondSelect(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsGroupByUnrelated() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsGroupByUnrelated(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsGroupByUnrelated(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsIntegrityEnhancementFacility(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsIntegrityEnhancementFacility(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsLikeEscapeClause() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsLikeEscapeClause(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsLikeEscapeClause(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsLimitedOuterJoins() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsLimitedOuterJoins(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsLimitedOuterJoins(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsMinimumSQLGrammar(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsMinimumSQLGrammar(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsMixedCaseIdentifiers(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsMixedCaseIdentifiers(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsMixedCaseQuotedIdentifiers(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsMixedCaseQuotedIdentifiers(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsMultipleResultSets() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsMultipleResultSets(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsMultipleResultSets(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsMultipleTransactions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsMultipleTransactions(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsMultipleTransactions(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsNamedParameters() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsNonNullableColumns() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsNonNullableColumns(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsNonNullableColumns(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsOpenCursorsAcrossCommit(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsOpenCursorsAcrossCommit(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsOpenCursorsAcrossRollback(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsOpenCursorsAcrossRollback(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsOpenStatementsAcrossCommit(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsOpenStatementsAcrossCommit(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsOpenStatementsAcrossRollback(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsOpenStatementsAcrossRollback(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsOrderByUnrelated() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsOrderByUnrelated(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsOrderByUnrelated(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsOuterJoins() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsOuterJoins(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsOuterJoins(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsPositionedDelete() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsPositionedDelete(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsPositionedDelete(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsPositionedUpdate() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsPositionedUpdate(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsPositionedUpdate(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsResultSetConcurrency(int type, int concurrency)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        
        // 読み込み専用以外のカーソルを取得しようとした場合、サポート対象外の例外をスローする
        if (concurrency != ResultSet.CONCUR_READ_ONLY) {
            throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
        }
        
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsResultSetConcurrency(0, dbmds.get(0), type, concurrency);
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsResultSetConcurrency(1, dbmds.get(1), type, concurrency);
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsResultSetHoldability(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsResultSetType(int type) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsResultSetType(0, dbmds.get(0), type);
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsResultSetType(1, dbmds.get(1), type);
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSavepoints() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsSchemasInDataManipulation(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsSchemasInDataManipulation(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsSchemasInIndexDefinitions(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsSchemasInIndexDefinitions(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsSchemasInPrivilegeDefinitions(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsSchemasInPrivilegeDefinitions(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsSchemasInProcedureCalls(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsSchemasInProcedureCalls(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsSchemasInTableDefinitions(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsSchemasInTableDefinitions(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSelectForUpdate() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsSelectForUpdate(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsSelectForUpdate(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsStatementPooling() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsStoredProcedures() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsStoredProcedures(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsStoredProcedures(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsSubqueriesInComparisons(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsSubqueriesInComparisons(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSubqueriesInExists() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsSubqueriesInExists(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsSubqueriesInExists(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSubqueriesInIns() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsSubqueriesInIns(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsSubqueriesInIns(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsSubqueriesInQuantifieds(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsSubqueriesInQuantifieds(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsTableCorrelationNames() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsTableCorrelationNames(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsTableCorrelationNames(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsTransactionIsolationLevel(int arg0)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsTransactionIsolationLevel(0, dbmds.get(0), arg0);
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsTransactionIsolationLevel(1, dbmds.get(1), arg0);
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsTransactions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsTransactions(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsTransactions(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsUnion() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsUnion(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsUnion(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsUnionAll() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.SupportsUnionAll(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.SupportsUnionAll(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean updatesAreDetected(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean usesLocalFilePerTable() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.UsesLocalFilePerTable(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.UsesLocalFilePerTable(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean usesLocalFiles() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final ForestTask<Boolean> task0 = new DatabaseMetaDataTask.UsesLocalFiles(0, dbmds.get(0));
        final ForestTask<Boolean> task1 = new DatabaseMetaDataTask.UsesLocalFiles(1, dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public void close() {
        if (isClosed == false && resultSet != null) {
            try {
                ((ForestCloseable) resultSet).close();
            } catch (SQLException ignore) { 
            }
        }
        this.isClosed = true;
    }
    
    public void closeOneSide(int serverId) {
        if (isClosed == false && resultSet != null) {
            ((ForestCloseable) resultSet).closeOneSide(serverId);
            dbmds.set(serverId, null);
        }
    }
    
    public List<UdbValidity> getValidityList() throws ForestResourceDisposedException {
        return epCommonResource.getCurrentMngInfo().getValidityList();
    }
    
    public Map<String, LocalConfig> getConnectionConfigMap() throws ForestResourceDisposedException {
        return epCommonResource.getCurrentMngInfo().getLocalConfigMap();
    }
    
    public GlobalConfig getForestGlobalConfig() throws ForestResourceDisposedException {
        return epCommonResource.getCurrentMngInfo().getGlobalConfig();
    }
}
