/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */

package org.postgresforest;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.List;

import org.postgresforest.apibase.ClobTask;
import org.postgresforest.apibase.EntrypointCommonResource;
import org.postgresforest.util.ForestTask;

public class ForestClob implements Clob {
    
    private final EntrypointCommonResource epCommonResource;
    private final List<Clob> resClobList;
    private final int execServerId;
    
    public ForestClob(EntrypointCommonResource epCommonResource, List<Clob> resClobList, final int execServerId) {
        this.epCommonResource = epCommonResource;
        this.resClobList = resClobList;
        this.execServerId = execServerId;
    }
    
    public InputStream getAsciiStream() throws SQLException {
        final ForestTask<InputStream> task = new ClobTask.GetAsciiStream(execServerId, resClobList.get(execServerId));
        return epCommonResource.executeOneApi(task);
    }
    
    public Reader getCharacterStream() throws SQLException {
        final ForestTask<Reader> task = new ClobTask.GetCharacterStream(execServerId, resClobList.get(execServerId));
        return epCommonResource.executeOneApi(task);
    }
    
    public String getSubString(long pos, int length) throws SQLException {
        final ForestTask<String> task = new ClobTask.GetSubString_LongInt(execServerId, resClobList.get(execServerId), pos, length);
        return epCommonResource.executeOneApi(task);
    }
    
    public long length() throws SQLException {
        final ForestTask<Long> task = new ClobTask.Length(execServerId, resClobList.get(execServerId));
        return Long.valueOf(epCommonResource.executeOneApi(task));
    }
    
    public long position(String searchstr, long start) throws SQLException {
        final ForestTask<Long> task = new ClobTask.Position_StringLong(execServerId, resClobList.get(execServerId), searchstr, start);
        return Long.valueOf(epCommonResource.executeOneApi(task));
    }
    
    public long position(Clob searchstr, long start) throws SQLException {
        final ForestTask<Long> task = new ClobTask.Position_ClobLong(execServerId, resClobList.get(execServerId), searchstr, start);
        return Long.valueOf(epCommonResource.executeOneApi(task));
    }
    
    public OutputStream setAsciiStream(long arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Writer setCharacterStream(long arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int setString(long arg0, String arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int setString(long arg0, String arg1, int arg2, int arg3)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void truncate(long arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
}
