/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest;

import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

import org.postgresforest.apibase.*;
import org.postgresforest.util.ForestTask;

public class ForestCallableStatement extends ForestPreparedStatement implements
        CallableStatement {
    
    public ForestCallableStatement(EntrypointCommonResource epCommonResource,
            List<CallableStatement> stmts, String executeSql, final WeakReference<ForestConnection> con) {
        super(epCommonResource, stmts, executeSql, con);
    }
    
    public Array getArray(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Array> task = new CallableStatementTask.GetArray_Int(getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        final Array newArray = epCommonResource.executeOneApi(task);
        final List<Array> arrayList = new ArrayList<Array>(2);
        arrayList.add(null);
        arrayList.add(null);
        arrayList.set(getFixExecuteId(), newArray);
        final ForestArray newForestArray = new ForestArray(epCommonResource, arrayList, getFixExecuteId());
        return newForestArray;
    }
    
    public Array getArray(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public BigDecimal getBigDecimal(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<BigDecimal> task = new CallableStatementTask.GetBigDecimal_Int(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public BigDecimal getBigDecimal(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<BigDecimal> task = new CallableStatementTask.GetBigDecimal_IntInt(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0, arg1);
        return epCommonResource.executeOneApi(task);
    }
    
    public Blob getBlob(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Blob> task = new CallableStatementTask.GetBlob_Int(getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        final Blob newBlob = epCommonResource.executeOneApi(task);
        final List<Blob> blobList = new ArrayList<Blob>(2);
        blobList.add(null);
        blobList.add(null);
        blobList.set(getFixExecuteId(), newBlob);
        final ForestBlob newForestBlob = new ForestBlob(epCommonResource, blobList, getFixExecuteId());
        return newForestBlob;
    }
    
    public Blob getBlob(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean getBoolean(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Boolean> task = new CallableStatementTask.GetBoolean(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task).booleanValue();
    }
    
    public boolean getBoolean(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public byte getByte(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Byte> task = new CallableStatementTask.GetByte(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task).byteValue();
    }
    
    public byte getByte(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public byte[] getBytes(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<byte[]> task = new CallableStatementTask.GetBytes(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public byte[] getBytes(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Clob getClob(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Clob> task = new CallableStatementTask.GetClob_Int(getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        final Clob newClob = epCommonResource.executeOneApi(task);
        final List<Clob> clobList = new ArrayList<Clob>(2);
        clobList.add(null);
        clobList.add(null);
        clobList.set(getFixExecuteId(), newClob);
        final ForestClob newForestClob = new ForestClob(epCommonResource, clobList, getFixExecuteId());
        return newForestClob;
    }
    
    public Clob getClob(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Date getDate(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Date> task = new CallableStatementTask.GetDate(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public Date getDate(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Date> task = new CallableStatementTask.GetDate_IntCalendar(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0, arg1);
        return epCommonResource.executeOneApi(task);
    }
    
    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public double getDouble(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Double> task = new CallableStatementTask.GetDouble(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task).doubleValue();
    }
    
    public double getDouble(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public float getFloat(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Float> task = new CallableStatementTask.GetFloat(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task).floatValue();
    }
    
    public float getFloat(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int getInt(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Integer> task = new CallableStatementTask.GetInt(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task).intValue();
    }
    
    public int getInt(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public long getLong(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Long> task = new CallableStatementTask.GetLong(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task).longValue();
    }
    
    public long getLong(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Object getObject(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Object> task = new CallableStatementTask.GetObject(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public Object getObject(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Object getObject(int arg0, Map<String, Class<?>> arg1)
            throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Object> task = new CallableStatementTask.GetObject_IntMap(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0, arg1);
        return epCommonResource.executeOneApi(task);
    }
    
    public Object getObject(String arg0, Map<String, Class<?>> arg1)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Ref getRef(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Ref> task = new CallableStatementTask.GetRef_Int(getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        final Ref newRef = epCommonResource.executeOneApi(task);
        final List<Ref> refList = new ArrayList<Ref>(2);
        refList.add(null);
        refList.add(null);
        refList.set(getFixExecuteId(), newRef);
        final ForestRef newForestRef = new ForestRef(epCommonResource, refList, getFixExecuteId());
        return newForestRef;
    }
    
    public Ref getRef(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public short getShort(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Short> task = new CallableStatementTask.GetShort(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task).shortValue();
    }
    
    public short getShort(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getString(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<String> task = new CallableStatementTask.GetString(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public String getString(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Time getTime(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Time> task = new CallableStatementTask.GetTime(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public Time getTime(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Time> task = new CallableStatementTask.GetTime_IntCalendar(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0, arg1);
        return epCommonResource.executeOneApi(task);
    }
    
    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Timestamp getTimestamp(int arg0) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Timestamp> task = new CallableStatementTask.GetTimestamp(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public Timestamp getTimestamp(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Timestamp> task = new CallableStatementTask.GetTimestamp_IntCalendar(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()), arg0, arg1);
        return epCommonResource.executeOneApi(task);
    }
    
    public Timestamp getTimestamp(String arg0, Calendar arg1)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public URL getURL(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public URL getURL(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void registerOutParameter(int arg0, int arg1) throws SQLException {
        checkObjectClosed();
        final ForestTask<Void> task0 = new CallableStatementTask.RegisterOutParameter_IntInt(0, (CallableStatement) stmts.get(0), arg0, arg1);
        final ForestTask<Void> task1 = new CallableStatementTask.RegisterOutParameter_IntInt(1, (CallableStatement) stmts.get(1), arg0, arg1);
        epCommonResource.executeAllApi(task0, task1);
        return;
    }
    
    public void registerOutParameter(String arg0, int arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void registerOutParameter(int arg0, int arg1, int arg2)
            throws SQLException {
        checkObjectClosed();
        final ForestTask<Void> task0 = new CallableStatementTask.RegisterOutParameter_IntIntInt(0, (CallableStatement) stmts.get(0), arg0, arg1, arg2);
        final ForestTask<Void> task1 = new CallableStatementTask.RegisterOutParameter_IntIntInt(1, (CallableStatement) stmts.get(1), arg0, arg1, arg2);
        epCommonResource.executeAllApi(task0, task1);
        return;
    }
    
    public void registerOutParameter(int arg0, int arg1, String arg2)
            throws SQLException {
        checkObjectClosed();
        final ForestTask<Void> task0 = new CallableStatementTask.RegisterOutParameter_IntIntString(0, (CallableStatement) stmts.get(0), arg0, arg1, arg2);
        final ForestTask<Void> task1 = new CallableStatementTask.RegisterOutParameter_IntIntString(1, (CallableStatement) stmts.get(0), arg0, arg1, arg2);
        epCommonResource.executeAllApi(task0, task1);
        return;
    }
    
    public void registerOutParameter(String arg0, int arg1, int arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void registerOutParameter(String arg0, int arg1, String arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setAsciiStream(String arg0, InputStream arg1, int arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setBinaryStream(String arg0, InputStream arg1, int arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setBoolean(String arg0, boolean arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setByte(String arg0, byte arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setBytes(String arg0, byte[] arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setCharacterStream(String arg0, Reader arg1, int arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setDate(String arg0, Date arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setDate(String arg0, Date arg1, Calendar arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setDouble(String arg0, double arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setFloat(String arg0, float arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setInt(String arg0, int arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setLong(String arg0, long arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setNull(String arg0, int arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setNull(String arg0, int arg1, String arg2) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setObject(String arg0, Object arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setObject(String arg0, Object arg1, int arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setObject(String arg0, Object arg1, int arg2, int arg3)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setShort(String arg0, short arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setString(String arg0, String arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setTime(String arg0, Time arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setTime(String arg0, Time arg1, Calendar arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setTimestamp(String arg0, Timestamp arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setTimestamp(String arg0, Timestamp arg1, Calendar arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setURL(String arg0, URL arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean wasNull() throws SQLException {
        checkObjectClosed();
        checkObjectExecuted();
        final ForestTask<Boolean> task = new CallableStatementTask.WasNull(
                getFixExecuteId(), (CallableStatement) stmts.get(getFixExecuteId()));
        return epCommonResource.executeOneApi(task).booleanValue();
    }
    
}
